/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.util.LinkedList;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.transaction.xa.XAException;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.Subscription;

public class SpyMessageConsumer
implements MessageConsumer,
SpyConsumer,
Runnable {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$SpyMessageConsumer == null ? (class$org$jboss$mq$SpyMessageConsumer = SpyMessageConsumer.class$("org.jboss.mq.SpyMessageConsumer")) : class$org$jboss$mq$SpyMessageConsumer));
    public SpySession session;
    public Subscription subscription = new Subscription();
    protected boolean closed;
    protected Object stateLock = new Object();
    protected boolean receiving = false;
    protected boolean waitingForMessage = false;
    protected boolean listening = false;
    protected Thread listenerThread = null;
    MessageListener messageListener;
    LinkedList messages;
    boolean sessionConsumer;
    static /* synthetic */ Class class$org$jboss$mq$SpyMessageConsumer;

    SpyMessageConsumer(SpySession s, boolean sessionConsumer) {
        this.session = s;
        this.sessionConsumer = sessionConsumer;
        this.messageListener = null;
        this.closed = false;
        this.messages = new LinkedList();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            boolean oldListening = this.listening;
            this.listening = listener != null;
            this.messageListener = listener;
            if (!this.sessionConsumer && this.listening && !oldListening && this.listenerThread == null) {
                this.listenerThread = new Thread((Runnable)this, "MessageListenerThread - " + this.subscription.destination.getName());
                this.listenerThread.start();
            }
        }
    }

    public String getMessageSelector() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.subscription.messageSelector;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.messageListener;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
        }
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            Message message;
            block26: {
                Object object2;
                Message mes;
                Message message2 = this.getMessage();
                if (message2 != null) {
                    Object object3 = this.stateLock;
                    synchronized (object3) {
                        this.receiving = false;
                        return message2;
                    }
                }
                SpyMessage msg = this.session.connection.receive(this.subscription, 0L);
                if (msg != null && (mes = this.preProcessMessage(msg)) != null) {
                    Object object4 = this.stateLock;
                    synchronized (object4) {
                        this.receiving = false;
                        return mes;
                    }
                }
                try {
                    try {
                        this.waitingForMessage = true;
                        while (true) {
                            if (this.closed) {
                                mes = null;
                                Object var9_13 = null;
                                this.waitingForMessage = false;
                                object2 = this.stateLock;
                                break;
                            }
                            mes = this.getMessage();
                            if (mes != null) {
                                message = mes;
                                break block26;
                            }
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"receive in messages.wait()");
                            }
                            this.messages.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        SpyJMSException newE = new SpyJMSException("Receive interupted");
                        newE.setLinkedException(e);
                        throw newE;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    this.waitingForMessage = false;
                    Object object5 = this.stateLock;
                    synchronized (object5) {
                        this.receiving = false;
                        throw throwable;
                    }
                }
                synchronized (object2) {
                    this.receiving = false;
                    return mes;
                }
            }
            Object var9_14 = null;
            this.waitingForMessage = false;
            Object object6 = this.stateLock;
            synchronized (object6) {
                this.receiving = false;
                return message;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive(long timeOut) throws JMSException {
        if (timeOut == 0L) {
            return this.receive();
        }
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
        }
        long endTime = System.currentTimeMillis() + timeOut;
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            Message message;
            block29: {
                Message message2;
                block28: {
                    Object object2;
                    Message mes;
                    Message message3 = this.getMessage();
                    if (message3 != null) {
                        Object object3 = this.stateLock;
                        synchronized (object3) {
                            this.receiving = false;
                            return message3;
                        }
                    }
                    SpyMessage msg = this.session.connection.receive(this.subscription, timeOut);
                    if (msg != null && (mes = this.preProcessMessage(msg)) != null) {
                        Object object4 = this.stateLock;
                        synchronized (object4) {
                            this.receiving = false;
                            return mes;
                        }
                    }
                    try {
                        try {
                            this.waitingForMessage = true;
                            while (true) {
                                if (this.closed) {
                                    mes = null;
                                    Object var14_16 = null;
                                    this.waitingForMessage = false;
                                    object2 = this.stateLock;
                                    break;
                                }
                                mes = this.getMessage();
                                if (mes != null) {
                                    message2 = mes;
                                    break block28;
                                }
                                long att = endTime - System.currentTimeMillis();
                                if (att <= 0L) {
                                    message = null;
                                    break block29;
                                }
                                this.messages.wait(att);
                            }
                        }
                        catch (InterruptedException e) {
                            SpyJMSException newE = new SpyJMSException("Receive interupted");
                            newE.setLinkedException(e);
                            throw newE;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        this.waitingForMessage = false;
                        Object object5 = this.stateLock;
                        synchronized (object5) {
                            this.receiving = false;
                            throw throwable;
                        }
                    }
                    synchronized (object2) {
                        this.receiving = false;
                        return mes;
                    }
                }
                Object var14_17 = null;
                this.waitingForMessage = false;
                Object object6 = this.stateLock;
                synchronized (object6) {
                    this.receiving = false;
                    return message2;
                }
            }
            Object var14_18 = null;
            this.waitingForMessage = false;
            Object object7 = this.stateLock;
            synchronized (object7) {
                this.receiving = false;
                return message;
            }
        }
    }

    public Message receiveNoWait() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
        }
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            Message message = this.getMessage();
            if (message != null) {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.receiving = false;
                }
                Message message2 = message;
                return message2;
            }
        }
        SpyMessage msg = this.session.connection.receive(this.subscription, -1L);
        Object object3 = this.stateLock;
        synchronized (object3) {
            this.receiving = false;
        }
        if (msg == null) {
            return null;
        }
        return this.preProcessMessage(msg);
    }

    public void close() throws JMSException {
        log.debug((Object)"Message consumer closing.");
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.messages.notify();
        }
        if (this.listenerThread != null && !Thread.currentThread().equals(this.listenerThread)) {
            try {
                this.listenerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.sessionConsumer) {
            this.session.removeConsumer(this);
        }
    }

    public void addMessage(SpyMessage message) throws JMSException {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (this.closed) {
                log.debug((Object)"WARNING: NACK issued. The message consumer was closed.");
                this.session.connection.send(message.getAcknowledgementRequest(false));
                return;
            }
            if (this.subscription.accepts(message.header)) {
                if (this.sessionConsumer) {
                    this.sessionConsumerProcessMessage(message);
                } else if (this.waitingForMessage) {
                    this.messages.addLast(message);
                    this.messages.notifyAll();
                } else {
                    log.debug((Object)"WARNING: NACK issued. The message consumer was not waiting for a message.");
                    this.session.connection.send(message.getAcknowledgementRequest(false));
                }
            } else {
                log.debug((Object)"WARNING: NACK issued. The subscription did not accept the message");
                this.session.connection.send(message.getAcknowledgementRequest(false));
            }
        }
    }

    public void run() {
        SpyMessage mes = null;
        try {
            while (true) {
                block29: {
                    block30: {
                        MessageListener thisListener;
                        if (mes == null) {
                            LinkedList linkedList = this.messages;
                            synchronized (linkedList) {
                                if (this.closed) {
                                    this.waitingForMessage = false;
                                    break;
                                }
                                mes = this.session.connection.receive(this.subscription, 0L);
                                if (mes == null) {
                                    this.waitingForMessage = true;
                                    while (this.messages.isEmpty() && !this.closed || !this.session.running) {
                                        try {
                                            this.messages.wait();
                                        }
                                        catch (InterruptedException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (this.closed) {
                                        this.waitingForMessage = false;
                                        break;
                                    }
                                    mes = (SpyMessage)this.messages.removeFirst();
                                    this.waitingForMessage = false;
                                }
                            }
                            mes.session = this.session;
                            if (!mes.isOutdated()) continue;
                            mes.doAcknowledge();
                            mes = null;
                            continue;
                        }
                        Object e = this.stateLock;
                        synchronized (e) {
                            if (!this.isListening()) {
                                if (mes != null) {
                                    this.session.connection.send(mes.getAcknowledgementRequest(false));
                                }
                                this.listenerThread = null;
                                mes = null;
                                break;
                            }
                            thisListener = this.messageListener;
                        }
                        SpyMessage message = mes;
                        if (mes instanceof SpyEncapsulatedMessage) {
                            message = ((SpyEncapsulatedMessage)mes).getMessage();
                        }
                        if (this.session.transacted) {
                            this.session.connection.spyXAResourceManager.ackMessage(this.session.getCurrentTransactionId(), mes);
                        }
                        try {
                            this.session.addUnacknowlegedMessage(message);
                            thisListener.onMessage((Message)message);
                        }
                        catch (RuntimeException e2) {
                            log.warn((Object)("Message listener " + thisListener + " threw a RuntimeException."));
                        }
                        if (this.session.transacted) break block29;
                        if (this.session.acknowledgeMode == 1) break block30;
                        if (this.session.acknowledgeMode != 3) break block29;
                    }
                    mes.doAcknowledge();
                }
                mes = null;
            }
        }
        catch (JMSException e) {
            log.warn((Object)"Message consumer closing due to error in listening thread.", (Throwable)e);
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "SpyMessageConsumer:" + this.subscription.destination;
    }

    protected boolean isListening() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = this.listening;
            return bl;
        }
    }

    protected void sessionConsumerProcessMessage(SpyMessage message) throws JMSException {
        block20: {
            block21: {
                block19: {
                    MessageListener thisListener;
                    message.session = this.session;
                    if (message.isOutdated()) {
                        log.debug((Object)"I dropped a message (timeout)");
                        message.doAcknowledge();
                        return;
                    }
                    Object object = this.stateLock;
                    synchronized (object) {
                        thisListener = this.messageListener;
                    }
                    Object anonymousTXID = null;
                    if (this.session.transacted) {
                        if (this.session.getCurrentTransactionId() == null) {
                            anonymousTXID = this.session.connection.spyXAResourceManager.startTx();
                            this.session.setCurrentTransactionId(anonymousTXID);
                        }
                        this.session.connection.spyXAResourceManager.ackMessage(this.session.getCurrentTransactionId(), message);
                    }
                    if (thisListener != null) {
                        SpyMessage mes = message;
                        if (message instanceof SpyEncapsulatedMessage) {
                            mes = ((SpyEncapsulatedMessage)message).getMessage();
                        }
                        this.session.addUnacknowlegedMessage(message);
                        thisListener.onMessage((Message)mes);
                    }
                    if (!this.session.transacted) break block19;
                    if (anonymousTXID != null && this.session.getCurrentTransactionId() == anonymousTXID) {
                        try {
                            try {
                                this.session.connection.spyXAResourceManager.endTx(anonymousTXID, true);
                                this.session.connection.spyXAResourceManager.rollback(anonymousTXID);
                            }
                            catch (XAException e) {
                                log.error((Object)"Could not rollback", (Throwable)e);
                                Object var7_9 = null;
                                this.session.unsetCurrentTransactionId();
                            }
                            Object var7_8 = null;
                            this.session.unsetCurrentTransactionId();
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            this.session.unsetCurrentTransactionId();
                            throw throwable;
                        }
                        throw new SpyJMSException("Messaged delivery was not controled by a Transaction Manager");
                    }
                    break block20;
                }
                if (this.session.acknowledgeMode == 1) break block21;
                if (this.session.acknowledgeMode != 3) break block20;
            }
            message.doAcknowledge();
        }
    }

    public void restartProcessing() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            this.messages.notifyAll();
        }
    }

    Message getMessage() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            while (true) {
                try {
                    SpyMessage mes;
                    Message rc;
                    do {
                        if (this.messages.size() != 0) continue;
                        Message message = null;
                        return message;
                    } while ((rc = this.preProcessMessage(mes = (SpyMessage)this.messages.removeFirst())) == null);
                    Message message = rc;
                    return message;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    Message preProcessMessage(SpyMessage message) throws JMSException {
        block4: {
            block6: {
                block5: {
                    message.session = this.session;
                    if (message.isOutdated()) {
                        SpyMessageConsumer.log.debug((Object)"I dropped a message (timeout)");
                        message.doAcknowledge();
                        return null;
                    }
                    if (this.isListening()) break block4;
                    if (!this.session.transacted) break block5;
                    this.session.connection.spyXAResourceManager.ackMessage(this.session.getCurrentTransactionId(), message);
                    break block6;
                }
                if (this.session.acknowledgeMode == 1) ** GOTO lbl-1000
                if (this.session.acknowledgeMode == 3) lbl-1000:
                // 2 sources

                {
                    message.doAcknowledge();
                } else {
                    this.session.addUnacknowlegedMessage(message);
                }
            }
            if (message instanceof SpyEncapsulatedMessage) {
                return ((SpyEncapsulatedMessage)message).getMessage();
            }
            return message;
        }
        return message;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

