/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.Connection;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyBytesMessage;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMapMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyMessageConsumer;
import org.jboss.mq.SpyObjectMessage;
import org.jboss.mq.SpyStreamMessage;
import org.jboss.mq.SpyTextMessage;
import org.jboss.mq.SpyXAResource;
import org.jboss.mq.SpyXAResourceManager;
import org.jboss.util.NullArgumentException;

public abstract class SpySession
implements Session,
XASession {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$SpySession == null ? (class$org$jboss$mq$SpySession = SpySession.class$("org.jboss.mq.SpySession")) : class$org$jboss$mq$SpySession));
    public Connection connection;
    public boolean running;
    protected boolean transacted;
    protected int acknowledgeMode;
    protected HashSet consumers;
    SpyMessageConsumer sessionConsumer;
    boolean closed;
    Object runLock = new Object();
    private Object currentTransactionId;
    SpyXAResource spyXAResource;
    LinkedList messages = new LinkedList();
    ArrayList unacknowledgedMessages = new ArrayList();
    static /* synthetic */ Class class$org$jboss$mq$SpySession;

    SpySession(Connection conn, boolean trans, int acknowledge, boolean xaSession) {
        this.connection = conn;
        this.transacted = trans;
        this.acknowledgeMode = acknowledge;
        if (xaSession) {
            this.spyXAResource = new SpyXAResource(this);
        }
        this.running = true;
        this.closed = false;
        this.consumers = new HashSet();
        if (this.spyXAResource == null && this.transacted) {
            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Current transaction id: " + this.currentTransactionId));
            }
        }
    }

    void setCurrentTransactionId(Object xid) {
        if (xid == null) {
            throw new NullArgumentException("xid");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("setting current tx id: " + xid + ", previous: " + this.currentTransactionId));
        }
        this.currentTransactionId = xid;
    }

    void unsetCurrentTransactionId() {
        log.trace((Object)"Unsetting current tx id");
        this.currentTransactionId = null;
    }

    Object getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        this.sessionConsumer = new SpyMessageConsumer(this, true);
        this.sessionConsumer.setMessageListener(listener);
    }

    public boolean getTransacted() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return this.transacted;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (this.sessionConsumer == null) {
            return null;
        }
        return this.sessionConsumer.getMessageListener();
    }

    public XAResource getXAResource() {
        return this.spyXAResource;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyBytesMessage message = MessagePool.getBytesMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public MapMessage createMapMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyMapMessage message = MessagePool.getMapMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public Message createMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyMessage message = MessagePool.getMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyObjectMessage message = MessagePool.getObjectMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyObjectMessage message = MessagePool.getObjectMessage();
        message.setObject(object);
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyStreamMessage message = MessagePool.getStreamMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public TextMessage createTextMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTextMessage message = MessagePool.getTextMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Begin run, size=" + this.messages.size()));
        }
        LinkedList linkedList = this.messages;
        // MONITORENTER : linkedList
        while (this.messages.size() > 0) {
            SpyMessage message = (SpyMessage)this.messages.removeFirst();
            try {
                if (this.sessionConsumer == null) {
                    log.warn((Object)"Session has no message listener set, cannot process message.");
                    this.connection.send(message.getAcknowledgementRequest(false));
                    continue;
                }
                this.sessionConsumer.addMessage(message);
            }
            catch (JMSException ignore) {
                // empty catch block
            }
        }
        // MONITOREXIT : linkedList
        if (!trace) return;
        log.trace((Object)"End run");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws JMSException {
        log.debug((Object)"Session closing.");
        Object object = this.runLock;
        synchronized (object) {
            Iterator i;
            if (this.closed) {
                return;
            }
            HashSet hashSet = this.consumers;
            synchronized (hashSet) {
                if (this.sessionConsumer != null) {
                    this.sessionConsumer.close();
                }
                i = this.consumers.iterator();
            }
            while (i.hasNext()) {
                SpyMessageConsumer messageConsumer = (SpyMessageConsumer)i.next();
                messageConsumer.close();
            }
            if (this.spyXAResource == null) {
                if (this.transacted) {
                    this.rollback();
                } else {
                    i = this.unacknowledgedMessages.iterator();
                    while (i.hasNext()) {
                        SpyMessage message = (SpyMessage)i.next();
                        this.connection.send(message.getAcknowledgementRequest(false));
                        i.remove();
                    }
                }
            }
            this.connection.sessionClosing(this);
            this.closed = true;
            return;
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void commit() throws JMSException {
        if (this.spyXAResource != null) {
            throw new TransactionInProgressException("Should not be call from a XASession");
        }
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (!this.transacted) {
            throw new IllegalStateException("The session is not transacted");
        }
        Object object = this.runLock;
        synchronized (object) {
            block16: {
                this.connection.spyXAResourceManager.endTx(this.currentTransactionId, true);
                this.connection.spyXAResourceManager.commit(this.currentTransactionId, true);
                Object var4_2 = null;
                try {
                    this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Current transaction id: " + this.currentTransactionId));
                    }
                    break block16;
                }
                catch (Exception ignore) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Failed to start tx", (Throwable)ignore);
                    }
                    break block16;
                }
                {
                    catch (XAException e) {
                        throw new SpyJMSException("Could not commit", e);
                    }
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var4_3 = null;
                        try {
                            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Current transaction id: " + this.currentTransactionId));
                            }
                        }
                        catch (Exception ignore) {
                            if (!log.isTraceEnabled()) break block17;
                            log.trace((Object)"Failed to start tx", (Throwable)ignore);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void rollback() throws JMSException {
        Object object = this.runLock;
        synchronized (object) {
            block16: {
                if (this.spyXAResource != null) {
                    throw new TransactionInProgressException("Should not be call from a XASession");
                }
                if (this.closed) {
                    throw new IllegalStateException("The session is closed");
                }
                if (!this.transacted) {
                    throw new IllegalStateException("The session is not transacted");
                }
                this.connection.spyXAResourceManager.endTx(this.currentTransactionId, true);
                this.connection.spyXAResourceManager.rollback(this.currentTransactionId);
                Object var4_2 = null;
                try {
                    this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Current transaction id: " + this.currentTransactionId));
                    }
                    break block16;
                }
                catch (Exception ignore) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Failed to start tx", (Throwable)ignore);
                    }
                    break block16;
                }
                {
                    catch (XAException e) {
                        throw new SpyJMSException("Could not rollback", e);
                    }
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var4_3 = null;
                        try {
                            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Current transaction id: " + this.currentTransactionId));
                            }
                        }
                        catch (Exception ignore) {
                            if (!log.isTraceEnabled()) break block17;
                            log.trace((Object)"Failed to start tx", (Throwable)ignore);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    public synchronized void recover() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (this.transacted) {
            throw new IllegalStateException("The session is transacted");
        }
        try {
            this.connection.stop();
            this.running = false;
        }
        catch (JMSException e) {
            throw new SpyJMSException("Could not stop message delivery", e);
        }
        try {
            LinkedList e = this.messages;
            synchronized (e) {
                Iterator i = this.consumers.iterator();
                while (i.hasNext()) {
                    SpyMessageConsumer consumer = (SpyMessageConsumer)i.next();
                    Iterator ii = this.unacknowledgedMessages.iterator();
                    while (ii.hasNext()) {
                        SpyMessage message = (SpyMessage)ii.next();
                        if (!consumer.getSubscription().accepts(message.header)) continue;
                        message.setJMSRedelivered(true);
                        consumer.messages.addLast(message);
                        ii.remove();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SpyJMSException("Unable to recover session ", e);
        }
        try {
            this.running = true;
            this.connection.start();
            Iterator i = this.consumers.iterator();
            while (i.hasNext()) {
                ((SpyMessageConsumer)i.next()).restartProcessing();
            }
        }
        catch (JMSException e) {
            throw new SpyJMSException("Could not resume message delivery", e);
        }
    }

    public void doAcknowledge(Message message, AcknowledgementRequest ack) throws JMSException {
        ArrayList arrayList = this.unacknowledgedMessages;
        synchronized (arrayList) {
            this.connection.send(ack);
            this.unacknowledgedMessages.remove(message);
            if (ack.isAck) {
                Iterator i = this.unacknowledgedMessages.iterator();
                while (i.hasNext()) {
                    Message mess = (Message)i.next();
                    i.remove();
                    this.connection.send(((SpyMessage)mess).getAcknowledgementRequest(true));
                }
            }
        }
    }

    public void deleteTemporaryDestination(SpyDestination dest) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SpySession: deleteDestination(dest=" + dest.toString() + ")"));
        }
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            HashSet newMap = (HashSet)this.consumers.clone();
            newMap.remove(dest);
            this.consumers = newMap;
        }
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTextMessage message = new SpyTextMessage();
        message.setText(string);
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    String getNewMessageID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return this.connection.getNewMessageID();
    }

    void addMessage(SpyMessage message) {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            this.messages.addLast(message);
        }
    }

    void addUnacknowlegedMessage(Message message) {
        if (!this.transacted) {
            ArrayList arrayList = this.unacknowledgedMessages;
            synchronized (arrayList) {
                this.unacknowledgedMessages.add(message);
            }
        }
    }

    void sendMessage(SpyMessage m) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (this.transacted) {
            this.connection.spyXAResourceManager.addMessage(this.currentTransactionId, m.myClone());
        } else {
            this.connection.sendToServer(m);
        }
    }

    void addConsumer(SpyMessageConsumer who) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            HashSet newMap = (HashSet)this.consumers.clone();
            newMap.add(who);
            this.consumers = newMap;
        }
        try {
            this.connection.addConsumer(who);
        }
        catch (JMSSecurityException ex) {
            this.removeConsumerInternal(who);
            throw ex;
        }
    }

    void removeConsumer(SpyMessageConsumer who) throws JMSException {
        this.connection.removeConsumer(who);
        this.removeConsumerInternal(who);
    }

    private void removeConsumerInternal(SpyMessageConsumer who) {
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            HashSet newMap = (HashSet)this.consumers.clone();
            newMap.remove(who);
            this.consumers = newMap;
        }
    }

    public SpyXAResourceManager getXAResourceManager() {
        return this.connection.spyXAResourceManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

