/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.selectors.Selector;

public class Subscription
implements Serializable {
    public int subscriptionId;
    public SpyDestination destination;
    public String messageSelector;
    public boolean destroyDurableSubscription;
    public boolean noLocal;
    public transient Selector selector;
    public transient ConnectionToken connectionToken;
    public transient Object clientConsumer;

    public Selector getSelector() throws InvalidSelectorException {
        if (this.messageSelector == null) {
            return null;
        }
        if (this.selector == null) {
            this.selector = new Selector(this.messageSelector);
        }
        return this.selector;
    }

    public boolean accepts(SpyMessage.Header header) throws JMSException {
        if (header.jmsDestination instanceof SpyTopic && this.noLocal && header.producerClientId.equals(this.connectionToken.getClientID())) {
            return false;
        }
        Selector ms = this.getSelector();
        return ms == null || ms.test(header);
    }

    public Subscription myClone() {
        Subscription result = new Subscription();
        result.subscriptionId = this.subscriptionId;
        result.destination = this.destination;
        result.messageSelector = this.messageSelector;
        result.destroyDurableSubscription = this.destroyDurableSubscription;
        result.noLocal = this.noLocal;
        return result;
    }

    public String toString() {
        return "org.jboss.mq.Subscription {" + this.subscriptionId + "," + this.destination + "," + this.messageSelector + "," + (this.destroyDurableSubscription ? "Create" : "Destroy") + "," + (this.noLocal ? "NoLocal" : "Local") + "," + "}";
    }
}

