/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.uil.UILClientIL;
import org.jboss.mq.il.uil.UILServerIL;

public class UILClientILService
implements Runnable,
ClientILService {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$il$uil$UILClientILService == null ? (class$org$jboss$mq$il$uil$UILClientILService = UILClientILService.class$("org.jboss.mq.il.uil.UILClientILService")) : class$org$jboss$mq$il$uil$UILClientILService));
    static final int m_close = 2;
    static final int m_deleteTemporaryDestination = 1;
    static final int m_receive = 3;
    static final int m_pong = 4;
    UILClientIL clientIL;
    Thread worker;
    private Connection connection;
    private boolean running;
    static /* synthetic */ Class class$org$jboss$mq$il$uil$UILClientILService;

    public ClientIL getClientIL() throws Exception {
        return this.clientIL;
    }

    public void init(Connection connection, Properties props) throws Exception {
        this.connection = connection;
        this.clientIL = new UILClientIL();
    }

    public void run() {
        boolean trace = log.isTraceEnabled();
        log.debug((Object)"UILClientILService.run()");
        Socket socket = null;
        byte code = 0;
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        try {
            log.trace((Object)"getting streams");
            UILServerIL serverIL = (UILServerIL)this.connection.getServerIL();
            out = new ObjectOutputStream(new BufferedOutputStream(serverIL.mSocket.getOutputStream(2)));
            out.flush();
            in = new ObjectInputStream(new BufferedInputStream(serverIL.mSocket.getInputStream(2)));
            socket = serverIL.socket;
        }
        catch (IOException e) {
            log.trace((Object)"Could not initialize the UILClientIL Service", (Throwable)e);
            this.connection.asynchFailure("Could not initialize the UILClientIL Service.", e);
            this.running = false;
            return;
        }
        int count = 0;
        while (this.running) {
            block23: {
                try {
                    if (trace) {
                        log.trace((Object)"Waiting for a messgage from the server");
                    }
                    code = in.readByte();
                    ++count;
                }
                catch (InterruptedIOException e) {
                    continue;
                }
                catch (IOException e) {
                    if (!trace) break;
                    log.trace((Object)"Exiting run loop on IOE", (Throwable)e);
                    break;
                }
                try {
                    if (trace) {
                        log.trace((Object)("Begin(" + count + ") Code: " + code));
                    }
                    switch (code) {
                        case 3: {
                            int numReceives = in.readInt();
                            ReceiveRequest[] messages = new ReceiveRequest[numReceives];
                            int i = 0;
                            while (i < numReceives) {
                                messages[i] = new ReceiveRequest();
                                messages[i].readExternal(in);
                                ++i;
                            }
                            this.connection.asynchDeliver(messages);
                            break;
                        }
                        case 1: {
                            this.connection.asynchDeleteTemporaryDestination((SpyDestination)in.readObject());
                            break;
                        }
                        case 2: {
                            this.connection.asynchClose();
                            break;
                        }
                        case 4: {
                            this.connection.asynchPong(in.readLong());
                            break;
                        }
                        default: {
                            RemoteException e = new RemoteException("UILClientIL invocation contained a bad method code.");
                            this.connection.asynchFailure("UILClientIL invocation contained a bad method code.", e);
                            throw e;
                        }
                    }
                    try {
                        out.writeByte(0);
                        out.flush();
                        break block23;
                    }
                    catch (IOException e) {
                        if (this.running) break;
                        this.connection.asynchFailure("Connection failure", e);
                    }
                }
                catch (Exception e) {
                    if (this.running) break;
                    try {
                        out.writeByte(1);
                        out.writeObject(e);
                        out.reset();
                        out.flush();
                        break block23;
                    }
                    catch (IOException e2) {
                        this.connection.asynchFailure("Connection failure", e2);
                    }
                }
                break;
            }
            if (!trace) continue;
            log.trace((Object)("End(" + count + ") Code: " + code));
        }
        this.running = false;
        try {
            out.close();
            in.close();
            socket.close();
        }
        catch (IOException e) {
            this.connection.asynchFailure("Error whle closing UILClientIL connection", e);
            return;
        }
    }

    public void start() throws Exception {
        this.running = true;
        this.worker = new Thread(Connection.threadGroup, this, "UILClientILService");
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() throws Exception {
        this.running = false;
        this.worker.interrupt();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

