/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.uil.multiplexor.SocketMultiplexor;

public class UILServerIL
implements Serializable,
Cloneable,
ServerIL {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$il$uil$UILServerIL == null ? (class$org$jboss$mq$il$uil$UILServerIL = UILServerIL.class$("org.jboss.mq.il.uil.UILServerIL")) : class$org$jboss$mq$il$uil$UILServerIL));
    static final int m_acknowledge = 1;
    static final int m_addMessage = 2;
    static final int m_browse = 3;
    static final int m_checkID = 4;
    static final int m_connectionClosing = 5;
    static final int m_createQueue = 6;
    static final int m_createTopic = 7;
    static final int m_deleteTemporaryDestination = 8;
    static final int m_getID = 9;
    static final int m_getTemporaryQueue = 10;
    static final int m_getTemporaryTopic = 11;
    static final int m_receive = 13;
    static final int m_setEnabled = 14;
    static final int m_setSpyDistributedConnection = 15;
    static final int m_subscribe = 16;
    static final int m_transact = 17;
    static final int m_unsubscribe = 18;
    static final int m_destroySubscription = 19;
    static final int m_checkUser = 20;
    static final int m_ping = 21;
    static final int m_authenticate = 22;
    private static final String LOCAL_ADDR = "org.jboss.mq.il.oil.localAddr";
    private static final String LOCAL_PORT = "org.jboss.mq.il.oil.localPort";
    private InetAddress addr;
    private int port;
    private String socketFactoryName;
    private boolean enableTcpNoDelay = false;
    private transient InetAddress localAddr;
    private transient int localPort;
    protected transient ObjectInputStream in;
    protected transient Socket socket;
    protected transient SocketMultiplexor mSocket;
    protected transient ObjectOutputStream out;
    static /* synthetic */ Class class$org$jboss$mq$il$uil$UILServerIL;

    public UILServerIL(InetAddress addr, int port, String socketFactoryName, boolean enableTcpNoDelay) {
        this.addr = addr;
        this.port = port;
        this.socketFactoryName = socketFactoryName;
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public synchronized void setConnectionToken(ConnectionToken dest) throws Exception {
        this.checkConnection();
        this.out.writeByte(15);
        this.out.writeObject(dest);
        this.waitAnswer();
    }

    public synchronized void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(14);
        this.out.writeBoolean(enabled);
        this.waitAnswer();
    }

    public synchronized String getID() throws Exception {
        this.checkConnection();
        this.out.writeByte(9);
        return (String)this.waitAnswer();
    }

    public synchronized TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(10);
        return (TemporaryQueue)this.waitAnswer();
    }

    public synchronized TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(11);
        return (TemporaryTopic)this.waitAnswer();
    }

    public synchronized void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(1);
        item.writeExternal(this.out);
        this.waitAnswer();
    }

    public synchronized void addMessage(ConnectionToken dc, SpyMessage val) throws Exception {
        this.checkConnection();
        this.out.writeByte(2);
        SpyMessage.writeMessage(val, this.out);
        this.waitAnswer();
    }

    public synchronized SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(3);
        this.out.writeObject(dest);
        this.out.writeObject(selector);
        return (SpyMessage[])this.waitAnswer();
    }

    public synchronized void checkID(String ID) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(4);
        this.out.writeObject(ID);
        this.waitAnswer();
    }

    public synchronized String checkUser(String userName, String password) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(20);
        this.out.writeObject(userName);
        this.out.writeObject(password);
        return (String)this.waitAnswer();
    }

    public synchronized String authenticate(String userName, String password) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(22);
        this.out.writeObject(userName);
        this.out.writeObject(password);
        return (String)this.waitAnswer();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ServerIL cloneServerIL() throws Exception {
        return (ServerIL)this.clone();
    }

    public synchronized void connectionClosing(ConnectionToken dc) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(5);
        this.waitAnswer();
        this.destroyConnection();
    }

    public synchronized Queue createQueue(ConnectionToken dc, String dest) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(6);
        this.out.writeObject(dest);
        return (Queue)this.waitAnswer();
    }

    public synchronized Topic createTopic(ConnectionToken dc, String dest) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(7);
        this.out.writeObject(dest);
        return (Topic)this.waitAnswer();
    }

    public synchronized void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(8);
        this.out.writeObject(dest);
        this.waitAnswer();
    }

    public synchronized void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(19);
        this.out.writeObject(id);
        this.waitAnswer();
    }

    public synchronized void ping(ConnectionToken dc, long clientTime) throws Exception {
        this.checkConnection();
        this.out.writeByte(21);
        this.out.writeLong(clientTime);
        this.waitAnswer();
    }

    public synchronized SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws Exception, Exception {
        this.checkConnection();
        this.out.writeByte(13);
        this.out.writeInt(subscriberId);
        this.out.writeLong(wait);
        return (SpyMessage)this.waitAnswer();
    }

    public synchronized void subscribe(ConnectionToken dc, Subscription s) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(16);
        this.out.writeObject(s);
        this.waitAnswer();
    }

    public synchronized void transact(ConnectionToken dc, TransactionRequest t) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(17);
        t.writeExternal(this.out);
        this.waitAnswer();
    }

    public synchronized void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(18);
        this.out.writeInt(subscriptionId);
        this.waitAnswer();
    }

    protected void checkConnection() throws Exception {
        if (this.mSocket == null) {
            this.createConnection();
        }
    }

    protected void createConnection() throws Exception {
        String tmp;
        boolean tracing = log.isTraceEnabled();
        if (tracing) {
            log.trace((Object)("Connecting to : " + this.addr + ":" + this.port));
        }
        SocketFactory socketFactory = null;
        if (this.socketFactoryName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = loader.loadClass(this.socketFactoryName);
                socketFactory = (SocketFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                log.debug((Object)("Failed to load socket factory: " + this.socketFactoryName), (Throwable)e);
            }
        }
        if (socketFactory == null) {
            socketFactory = SocketFactory.getDefault();
        }
        if ((tmp = System.getProperty(LOCAL_ADDR)) != null) {
            this.localAddr = InetAddress.getByName(tmp);
        }
        if ((tmp = System.getProperty(LOCAL_PORT)) != null) {
            this.localPort = Integer.parseInt(tmp);
        }
        if (tracing) {
            log.trace((Object)("Connecting with addr=" + this.addr + ", port=" + this.port + ", localAddr=" + this.localAddr + ", localPort=" + this.localPort + ", socketFactory=" + socketFactory + ", enableTcpNoDelay=" + this.enableTcpNoDelay));
        }
        this.socket = this.localAddr != null ? socketFactory.createSocket(this.addr, this.port, this.localAddr, this.localPort) : socketFactory.createSocket(this.addr, this.port);
        this.socket.setTcpNoDelay(this.enableTcpNoDelay);
        this.mSocket = new SocketMultiplexor(this.socket);
        this.out = new ObjectOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream(1)));
        this.out.flush();
        this.in = new ObjectInputStream(new BufferedInputStream(this.mSocket.getInputStream(1)));
    }

    protected void destroyConnection() throws Exception {
        try {
            this.in.close();
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Object waitAnswer() throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.debug((Object)"Begin waitAnswer");
        }
        this.out.reset();
        this.out.flush();
        byte val = this.in.readByte();
        if (trace) {
            log.debug((Object)("waitAnswer, val=" + val));
        }
        Object answer = null;
        if (val == 1) {
            answer = this.in.readObject();
        } else if (val != 0) {
            Exception e = (Exception)this.in.readObject();
            throw e;
        }
        if (trace) {
            log.debug((Object)"End waitAnswer");
        }
        return answer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

