/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.Invoker;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.uil.UILClientIL;
import org.jboss.mq.il.uil.UILServerIL;
import org.jboss.mq.il.uil.UILServerILServiceMBean;
import org.jboss.mq.il.uil.multiplexor.SocketMultiplexor;
import org.jboss.security.SecurityDomain;

public class UILServerILService
extends ServerILJMXService
implements Runnable,
UILServerILServiceMBean {
    protected Invoker server;
    static final int m_acknowledge = 1;
    static final int m_addMessage = 2;
    static final int m_browse = 3;
    static final int m_checkID = 4;
    static final int m_connectionClosing = 5;
    static final int m_createQueue = 6;
    static final int m_createTopic = 7;
    static final int m_deleteTemporaryDestination = 8;
    static final int m_getID = 9;
    static final int m_getTemporaryQueue = 10;
    static final int m_getTemporaryTopic = 11;
    static final int m_listenerChange = 12;
    static final int m_receive = 13;
    static final int m_setEnabled = 14;
    static final int m_setSpyDistributedConnection = 15;
    static final int m_subscribe = 16;
    static final int m_transact = 17;
    static final int m_unsubscribe = 18;
    static final int m_destroySubscription = 19;
    static final int m_checkUser = 20;
    static final int m_ping = 21;
    static final int m_authenticate = 22;
    static final int SO_TIMEOUT = 5000;
    private String securityDomain;
    private String clientSocketFactoryName;
    private ServerSocketFactory serverSocketFactory;
    protected ServerSocket serverSocket;
    UILServerIL serverIL;
    boolean running;
    int serverBindPort = 0;
    InetAddress bindAddress = null;
    Thread worker;
    private boolean enableTcpNoDelay = false;
    private int threadNumber = 0;
    private Properties connectionProperties;
    static /* synthetic */ Class class$org$jboss$security$SecurityDomain;

    public Properties getClientConnectionProperties() {
        return this.connectionProperties;
    }

    public String getName() {
        return "JBossMQ-UILServerIL";
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        socket = null;
        mSocket = null;
        code = 0;
        out = null;
        in = null;
        connectionToken = null;
        closed = false;
        try {
            while (true) {
                if (!this.running || socket != null) {
                    if (this.running) break;
                    return;
                }
                try {
                    socket = this.serverSocket.accept();
                }
                catch (InterruptedIOException e) {
                    // empty catch block
                }
            }
            socket.setSoTimeout(0);
            socket.setTcpNoDelay(this.enableTcpNoDelay);
            new Thread((Runnable)this, "UIL Worker-" + this.threadNumber++).start();
            mSocket = new SocketMultiplexor(socket);
            out = new ObjectOutputStream(new BufferedOutputStream(mSocket.getOutputStream(1)));
            out.flush();
            in = new ObjectInputStream(new BufferedInputStream(mSocket.getInputStream(1)));
            if (true) ** GOTO lbl151
        }
        catch (SocketException e) {
            this.log.warn((Object)"SocketException occured (Connection reset by peer?). Cannot initialize the UILServerILService.");
            return;
        }
        catch (IOException e) {
            this.log.warn((Object)"IOException occured. Cannot initialize the UILServerILService.");
            return;
        }
        do {
            try {
                code = in.readByte();
            }
            catch (EOFException e) {
                break;
            }
            catch (IOException e) {
                if (closed || !this.running) break;
                this.log.debug((Object)"Connection failure (1).", (Throwable)e);
                break;
            }
            try {
                result = null;
                switch (code) {
                    case 15: {
                        this.log.debug((Object)"Setting up the UILClientIL Connection");
                        connectionToken = (ConnectionToken)in.readObject();
                        ((UILClientIL)connectionToken.clientIL).mSocket = mSocket;
                        ((UILClientIL)connectionToken.clientIL).createConnection();
                        this.log.debug((Object)"The UILClientIL Connection is set up");
                        break;
                    }
                    case 1: {
                        ack = new AcknowledgementRequest();
                        ack.readExternal(in);
                        this.server.acknowledge(connectionToken, ack);
                        break;
                    }
                    case 2: {
                        this.server.addMessage(connectionToken, SpyMessage.readMessage(in));
                        break;
                    }
                    case 3: {
                        result = this.server.browse(connectionToken, (Destination)in.readObject(), (String)in.readObject());
                        break;
                    }
                    case 4: {
                        ID = (String)in.readObject();
                        this.server.checkID(ID);
                        if (connectionToken == null) break;
                        connectionToken.setClientID(ID);
                        break;
                    }
                    case 5: {
                        this.server.connectionClosing(connectionToken);
                        closed = true;
                        break;
                    }
                    case 6: {
                        result = this.server.createQueue(connectionToken, (String)in.readObject());
                        break;
                    }
                    case 7: {
                        result = this.server.createTopic(connectionToken, (String)in.readObject());
                        break;
                    }
                    case 8: {
                        this.server.deleteTemporaryDestination(connectionToken, (SpyDestination)in.readObject());
                        break;
                    }
                    case 9: {
                        result = this.server.getID();
                        if (connectionToken == null) break;
                        connectionToken.setClientID((String)result);
                        break;
                    }
                    case 10: {
                        result = this.server.getTemporaryQueue(connectionToken);
                        break;
                    }
                    case 11: {
                        result = this.server.getTemporaryTopic(connectionToken);
                        break;
                    }
                    case 13: {
                        result = this.server.receive(connectionToken, in.readInt(), in.readLong());
                        break;
                    }
                    case 14: {
                        this.server.setEnabled(connectionToken, in.readBoolean());
                        break;
                    }
                    case 16: {
                        this.server.subscribe(connectionToken, (Subscription)in.readObject());
                        break;
                    }
                    case 17: {
                        trans = new TransactionRequest();
                        trans.readExternal(in);
                        this.server.transact(connectionToken, trans);
                        break;
                    }
                    case 18: {
                        this.server.unsubscribe(connectionToken, in.readInt());
                        break;
                    }
                    case 19: {
                        this.server.destroySubscription(connectionToken, (DurableSubscriptionID)in.readObject());
                        break;
                    }
                    case 20: {
                        result = this.server.checkUser((String)in.readObject(), (String)in.readObject());
                        break;
                    }
                    case 21: {
                        this.server.ping(connectionToken, in.readLong());
                        break;
                    }
                    case 22: {
                        result = this.server.authenticate((String)in.readObject(), (String)in.readObject());
                        break;
                    }
                    default: {
                        throw new RemoteException("Bad method code !");
                    }
                }
                try {
                    if (result == null) {
                        out.writeByte(0);
                    } else {
                        out.writeByte(1);
                        out.writeObject(result);
                        out.reset();
                    }
                    out.flush();
                    continue;
                }
                catch (IOException e) {
                    if (closed) break;
                    this.log.warn((Object)"Connection failure (2).", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (closed) break;
                this.log.info((Object)"Client request resulted in a server exception: ", (Throwable)e);
                try {
                    out.writeByte(2);
                    out.writeObject(e);
                    out.reset();
                    out.flush();
                    continue;
                }
                catch (IOException e2) {
                    if (closed) break;
                    this.log.warn((Object)"Connection failure (3).", (Throwable)e);
                }
            }
            break;
lbl151:
            // 3 sources

        } while (!closed && this.running);
        try {
            if (!closed) {
                try {
                    this.server.connectionClosing(connectionToken);
                }
                catch (JMSException ignore) {
                    // empty catch block
                }
            }
            mSocket.close();
            return;
        }
        catch (IOException e) {
            this.log.warn((Object)"Connection failure during connection close.", (Throwable)e);
        }
    }

    public void startService() throws Exception {
        super.startService();
        this.running = true;
        this.server = this.lookupJMSServer();
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.securityDomain != null) {
            try {
                InitialContext ctx = new InitialContext();
                Class<?> ssfClass = this.serverSocketFactory.getClass();
                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.securityDomain);
                Class[] parameterTypes = new Class[]{class$org$jboss$security$SecurityDomain == null ? (class$org$jboss$security$SecurityDomain = UILServerILService.class$("org.jboss.security.SecurityDomain")) : class$org$jboss$security$SecurityDomain};
                Method m = ssfClass.getMethod("setSecurityDomain", parameterTypes);
                Object[] args = new Object[]{domain};
                m.invoke((Object)this.serverSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                this.log.error((Object)"Socket factory does not support setSecurityDomain(SecurityDomain)");
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to setSecurityDomain=" + this.securityDomain + " on socket factory"));
            }
        }
        this.serverSocket = this.serverSocketFactory.createServerSocket(this.serverBindPort, 50, this.bindAddress);
        this.serverSocket.setSoTimeout(5000);
        InetAddress socketAddress = this.serverSocket.getInetAddress();
        this.log.info((Object)("JBossMQ UIL service available at : " + socketAddress + ":" + this.serverSocket.getLocalPort()));
        this.worker = new Thread(this.server.getThreadGroup(), this, "UIL Worker");
        this.worker.start();
        if (socketAddress.toString().equals("0.0.0.0/0.0.0.0")) {
            socketAddress = InetAddress.getLocalHost();
        }
        this.serverIL = new UILServerIL(socketAddress, this.serverSocket.getLocalPort(), this.clientSocketFactoryName, this.enableTcpNoDelay);
        this.connectionProperties = super.getClientConnectionProperties();
        this.connectionProperties.setProperty("ClientILService", "org.jboss.mq.il.uil.UILClientILService");
        this.connectionProperties.setProperty("UIL_PORT_KEY", "" + this.serverSocket.getLocalPort());
        this.connectionProperties.setProperty("UIL_ADDRESS_KEY", "" + socketAddress.getHostAddress());
        this.connectionProperties.setProperty("UIL_TCPNODELAY_KEY", this.enableTcpNoDelay ? "yes" : "no");
        this.bindJNDIReferences();
    }

    public void stopService() {
        try {
            this.running = false;
            this.unbindJNDIReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public void setServerBindPort(int serverBindPort) {
        this.serverBindPort = serverBindPort;
    }

    public String getBindAddress() {
        String addr = "0.0.0.0";
        if (this.bindAddress != null) {
            addr = this.bindAddress.getHostName();
        }
        return addr;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    public boolean getEnableTcpNoDelay() {
        return this.enableTcpNoDelay;
    }

    public void setEnableTcpNoDelay(boolean enableTcpNoDelay) {
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public String getClientSocketFactory() {
        return this.clientSocketFactoryName;
    }

    public void setClientSocketFactory(String name) {
        this.clientSocketFactoryName = name;
    }

    public void setServerSocketFactory(String name) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> ssfClass = loader.loadClass(name);
        this.serverSocketFactory = (ServerSocketFactory)ssfClass.newInstance();
    }

    public String getServerSocketFactory() {
        String name = null;
        if (this.serverSocketFactory != null) {
            name = this.serverSocketFactory.getClass().getName();
        }
        return name;
    }

    public void setSecurityDomain(String domainName) {
        this.securityDomain = domainName;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

