/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.jboss.mq.il.uil.multiplexor.DynCircularBuffer;
import org.jboss.mq.il.uil.multiplexor.StreamDemux;

class DemuxInputStream
extends InputStream {
    StreamDemux streamDemux;
    short streamId;
    boolean atEOF = false;
    DynCircularBuffer buffer;

    DemuxInputStream(StreamDemux demux, short id) {
        this.streamDemux = demux;
        this.streamId = id;
        this.buffer = new DynCircularBuffer(1024);
    }

    public int available() throws IOException {
        return this.buffer.getSize();
    }

    public void close() throws IOException {
        this.streamDemux.closeStream(this.streamId);
    }

    public void loadBuffer(byte[] data, short dataLength) throws IOException {
        this.buffer.fill(data, dataLength);
    }

    public synchronized int read() throws IOException {
        if (this.atEOF) {
            return -1;
        }
        if (this.buffer.getSize() == 0) {
            this.fillBuffer();
        }
        if (this.atEOF) {
            return -1;
        }
        int result = this.buffer.get();
        return result & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.atEOF) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.buffer.getSize() == 0) {
            this.fillBuffer();
        }
        if (this.atEOF) {
            return -1;
        }
        int bytesRead = this.buffer.get(b, off, len);
        return bytesRead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillBuffer() throws IOException {
        boolean acquired = false;
        try {
            StreamDemux streamDemux = this.streamDemux;
            synchronized (streamDemux) {
                while (true) {
                    if (this.atEOF || acquired || this.buffer.getSize() != 0) {
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 9, 11] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (acquired) {
                            this.streamDemux.pumpData(this);
                        }
                        break;
                    }
                    acquired = this.streamDemux.attemptLock();
                    if (acquired) continue;
                    try {
                        this.streamDemux.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("Interrupted waiting for StreamDemux");
                    }
                }
            }
            Object var6_4 = null;
            if (!acquired) return;
            this.streamDemux.releaseLock();
            StreamDemux streamDemux2 = this.streamDemux;
            synchronized (streamDemux2) {
                this.streamDemux.notifyAll();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!acquired) throw throwable;
            this.streamDemux.releaseLock();
            StreamDemux streamDemux = this.streamDemux;
            synchronized (streamDemux) {
                this.streamDemux.notifyAll();
                throw throwable;
            }
        }
    }
}

