/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

public class DynCircularBuffer {
    byte[] buffer;
    int pos;
    int end;
    boolean isFull;

    public DynCircularBuffer() {
        this(1024);
    }

    public DynCircularBuffer(int capacity) {
        this.buffer = new byte[capacity];
        this.pos = 0;
        this.end = 0;
    }

    public synchronized void clear() {
        this.pos = 0;
        this.end = 0;
        this.isFull = false;
    }

    public synchronized void fill(byte[] data) {
        this.fill(data, data.length);
    }

    public synchronized void fill(byte[] data, int length) {
        int freeSpace = this.getFreeSpace();
        int currentLength = this.getSize();
        if (freeSpace < length) {
            int newSize = this.buffer.length + length - freeSpace;
            byte[] tmp = new byte[newSize];
            int i = 0;
            while (i < currentLength) {
                tmp[i] = this.buffer[this.pos];
                ++this.pos;
                if (this.pos == this.buffer.length) {
                    this.pos = 0;
                }
                ++i;
            }
            this.buffer = tmp;
            this.pos = 0;
            this.end = currentLength;
        }
        int i = 0;
        while (i < length) {
            this.buffer[this.end] = data[i];
            ++this.end;
            if (this.end == this.buffer.length) {
                this.end = 0;
            }
            ++i;
        }
        if (this.end == this.pos) {
            this.isFull = true;
        }
    }

    public synchronized int get() {
        if (this.pos == this.end && !this.isFull) {
            return -1;
        }
        int b = this.buffer[this.pos] & 0xFF;
        ++this.pos;
        if (this.pos == this.buffer.length) {
            this.pos = 0;
        }
        this.isFull = false;
        return b;
    }

    public synchronized int get(byte[] b, int off, int length) {
        if (this.pos == this.end && !this.isFull) {
            return -1;
        }
        int getSize = Math.min(this.getSize(), length);
        int i = 0;
        while (i < getSize) {
            b[off + i] = this.buffer[this.pos];
            ++this.pos;
            if (this.pos == this.buffer.length) {
                this.pos = 0;
            }
            ++i;
        }
        this.isFull = this.isFull ? getSize == 0 : false;
        return getSize;
    }

    public synchronized int getSize() {
        int length = this.buffer.length - this.getFreeSpace();
        return length;
    }

    public synchronized int getFreeSpace() {
        int available = 0;
        available = this.pos == this.end ? (this.isFull ? 0 : this.buffer.length) : (this.pos < this.end ? this.buffer.length - this.end + this.pos : this.pos - this.end);
        return available;
    }

    public static void main(String[] args) throws Exception {
        DynCircularBuffer dcb = new DynCircularBuffer(16);
        if (dcb.getFreeSpace() != 16) {
            throw new IllegalStateException("dcb.getFreeSpace() != 16");
        }
        if (dcb.getSize() != 0) {
            throw new IllegalStateException("dcb.getSize() != 0");
        }
        byte[] tst = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        dcb.fill(tst);
        if (dcb.getFreeSpace() != 1) {
            throw new IllegalStateException("dcb.getFreeSpace() != 1, " + dcb.getFreeSpace());
        }
        if (dcb.getSize() != 15) {
            throw new IllegalStateException("dcb.getSize() != 15");
        }
        byte[] tst2 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        dcb.clear();
        dcb.fill(tst2);
        if (dcb.getFreeSpace() != 0) {
            throw new IllegalStateException("dcb.getFreeSpace() != 0, " + dcb.getFreeSpace());
        }
        if (dcb.getSize() != 16) {
            throw new IllegalStateException("dcb.getSize() != 16");
        }
        dcb.clear();
        dcb.fill(tst);
        dcb.fill(tst2);
        if (dcb.getFreeSpace() != 0) {
            throw new IllegalStateException("dcb.getFreeSpace() != 0, " + dcb.getFreeSpace());
        }
        if (dcb.getSize() != 31) {
            throw new IllegalStateException("dcb.getSize() != 31, " + dcb.getSize());
        }
        int i = 0;
        while (i < tst.length) {
            int b = dcb.get();
            if (b != tst[i]) {
                throw new IllegalStateException("tst[" + i + "," + tst[i] + "] != " + b);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < tst2.length) {
            int b = dcb.get();
            if (b != tst2[i2]) {
                throw new IllegalStateException("tst2[" + i2 + "," + tst2[i2] + "] != " + b);
            }
            ++i2;
        }
        if (dcb.get() != -1) {
            throw new IllegalStateException("dcb.get() != -1");
        }
        dcb.fill(tst);
        byte[] out = new byte[128];
        int bytes = dcb.get(out, 0, 128);
        if (bytes != 15) {
            throw new IllegalStateException("dcb.get(out, 0, 128) != 15, " + bytes);
        }
        if (dcb.getFreeSpace() != 31) {
            throw new IllegalStateException("dcb.getFreeSpace() != 31, " + dcb.getFreeSpace());
        }
        if (dcb.getSize() != 0) {
            throw new IllegalStateException("dcb.getSize() != 0, " + dcb.getSize());
        }
        dcb.clear();
        int n = 0;
        while (n < 32) {
            dcb.fill(tst);
            if (dcb.getFreeSpace() != 16) {
                throw new IllegalStateException(n + ", dcb.getFreeSpace() != 16, " + dcb.getFreeSpace());
            }
            if (dcb.getSize() != 15) {
                throw new IllegalStateException(n + "dcb.getSize() != 15");
            }
            int i3 = 0;
            while (i3 < tst.length) {
                int b = dcb.get();
                if (b != tst[i3]) {
                    throw new IllegalStateException(n + "tst[" + i3 + "," + tst[i3] + "] != " + b);
                }
                ++i3;
            }
            if (dcb.get() != -1) {
                throw new IllegalStateException(n + "dcb.get() != -1");
            }
            if (dcb.getFreeSpace() != 31) {
                throw new IllegalStateException(n + ", dcb.getFreeSpace() != 31, " + dcb.getFreeSpace());
            }
            ++n;
        }
        byte[] tst3 = new byte[tst.length + tst2.length];
        System.arraycopy(tst, 0, tst3, 0, tst.length);
        System.arraycopy(tst2, 0, tst3, tst.length, tst2.length);
        dcb.clear();
        dcb.fill(tst3);
        if (dcb.getFreeSpace() != 0) {
            throw new IllegalStateException("dcb.getFreeSpace() != 0, " + dcb.getFreeSpace());
        }
        if (dcb.getSize() != 31) {
            throw new IllegalStateException("dcb.getSize() != 31, " + dcb.getSize());
        }
        dcb.fill(tst);
        if (dcb.getFreeSpace() != 0) {
            throw new IllegalStateException("dcb.getFreeSpace() != 0, " + dcb.getFreeSpace());
        }
        if (dcb.getSize() != 46) {
            throw new IllegalStateException("dcb.getSize() != 46, " + dcb.getSize());
        }
        int i4 = 0;
        while (i4 < tst.length) {
            int b = dcb.get();
            if (b != tst[i4]) {
                throw new IllegalStateException("tst[" + i4 + "," + tst[i4] + "] != " + b);
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < tst2.length) {
            int b = dcb.get();
            if (b != tst2[i5]) {
                throw new IllegalStateException("tst2[" + i5 + "," + tst2[i5] + "] != " + b);
            }
            ++i5;
        }
        int i6 = 0;
        while (i6 < tst.length) {
            int b = dcb.get();
            if (b != tst[i6]) {
                throw new IllegalStateException("tst[" + i6 + "," + tst[i6] + "] != " + b);
            }
            ++i6;
        }
        System.out.println("Done");
    }
}

