/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.jboss.mq.il.uil.multiplexor.DemuxInputStream;

public class StreamDemux {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$il$uil$multiplexor$StreamDemux == null ? (class$org$jboss$mq$il$uil$multiplexor$StreamDemux = StreamDemux.class$("org.jboss.mq.il.uil.multiplexor.StreamDemux")) : class$org$jboss$mq$il$uil$multiplexor$StreamDemux));
    private short frameSize = (short)512;
    private HashMap openStreams = new HashMap();
    private InputStream in;
    private DataInputStream objectIn;
    private Mutex pumpMutex = new Mutex();
    private byte[] inputBuffer = new byte[this.frameSize];
    private boolean trace;
    static /* synthetic */ Class class$org$jboss$mq$il$uil$multiplexor$StreamDemux;

    public StreamDemux(InputStream in) throws IOException {
        this.in = in;
        this.objectIn = new DataInputStream(in);
        this.trace = log.isTraceEnabled();
    }

    public void setFrameSize(short newFrameSize) throws IOException {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            if (this.openStreams.size() > 0) {
                throw new IOException("Cannot change the frame size while there are open streams.");
            }
            this.frameSize = newFrameSize;
            this.inputBuffer = new byte[this.frameSize];
        }
    }

    public short getFrameSize() {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            short s = this.frameSize;
            return s;
        }
    }

    public InputStream getStream(short id) throws IOException {
        InputStream s;
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            s = (InputStream)this.openStreams.get(new Short(id));
            if (s != null) {
                InputStream inputStream = s;
                return inputStream;
            }
            s = new DemuxInputStream(this, id);
            this.openStreams.put(new Short(id), s);
        }
        return s;
    }

    public int available(DemuxInputStream s) throws IOException {
        return this.objectIn.available();
    }

    public boolean attemptLock() throws InterruptedIOException {
        try {
            return this.pumpMutex.attempt(1L);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Failed to acquire StreamDemux lock");
        }
    }

    public void releaseLock() {
        this.pumpMutex.release();
    }

    public void pumpData(DemuxInputStream dest) throws IOException {
        if (this.trace) {
            log.trace((Object)("pumpData, destStream: " + dest.streamId));
        }
        boolean pumpingData = true;
        short nextFrameSize = this.frameSize;
        while (pumpingData) {
            DemuxInputStream s;
            short streamId = this.objectIn.readShort();
            if (this.trace) {
                log.trace((Object)("StreamId: " + streamId));
            }
            if (streamId == 0) {
                switch (this.objectIn.readByte()) {
                    case 0: {
                        short openID = this.objectIn.readShort();
                        this.getStream(openID);
                        if (!this.trace) break;
                        log.trace((Object)("Open stream: " + openID));
                        break;
                    }
                    case 1: {
                        DemuxInputStream s2;
                        short closeID = this.objectIn.readShort();
                        HashMap hashMap = this.openStreams;
                        synchronized (hashMap) {
                            s2 = (DemuxInputStream)this.openStreams.get(new Short(closeID));
                        }
                        if (s2 == null) break;
                        if (this.trace) {
                            log.trace((Object)("Close stream: " + closeID));
                        }
                        s2.atEOF = true;
                        this.closeStream(s2.streamId);
                        if (s2 != dest) break;
                        pumpingData = false;
                        break;
                    }
                    case 2: {
                        nextFrameSize = this.objectIn.readShort();
                    }
                }
                continue;
            }
            this.objectIn.readFully(this.inputBuffer, 0, nextFrameSize);
            HashMap hashMap = this.openStreams;
            synchronized (hashMap) {
                s = (DemuxInputStream)this.openStreams.get(new Short(streamId));
            }
            if (s == null) continue;
            s.loadBuffer(this.inputBuffer, nextFrameSize);
            if (this.trace) {
                log.trace((Object)("Loaded(" + nextFrameSize + ") bytes into: " + streamId));
            }
            if (s == dest) break;
            StreamDemux streamDemux = this;
            synchronized (streamDemux) {
                this.notifyAll();
            }
            nextFrameSize = this.frameSize;
        }
    }

    void closeStream(short id) throws IOException {
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            this.openStreams.remove(new Short(id));
        }
        StreamDemux streamDemux = this;
        synchronized (streamDemux) {
            this.notifyAll();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

