/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.jms.JMSException;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.file.CacheStoreMBean;
import org.jboss.mq.server.MessageReference;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;

public class CacheStore
extends ServiceMBeanSupport
implements org.jboss.mq.pm.CacheStore,
CacheStoreMBean {
    String dataDirectory;
    File dataDir;

    public SpyMessage loadFromStorage(MessageReference mh) throws JMSException {
        try {
            File f = new File(this.dataDir, "Message-" + mh.referenceId);
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
            Object rc = is.readObject();
            is.close();
            return (SpyMessage)rc;
        }
        catch (ClassNotFoundException e) {
            throw new SpyJMSException("Could not load message from secondary storage: ", e);
        }
        catch (IOException e) {
            throw new SpyJMSException("Could not load message from secondary storage: ", e);
        }
    }

    public void saveToStorage(MessageReference mh, SpyMessage message) throws JMSException {
        try {
            File f = new File(this.dataDir, "Message-" + mh.referenceId);
            ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            os.writeObject(message);
            os.close();
        }
        catch (IOException e) {
            throw new SpyJMSException("Could not load message from secondary storage: ", e);
        }
    }

    public void removeFromStorage(MessageReference mh) throws JMSException {
        File f = new File(this.dataDir, "Message-" + mh.referenceId);
        f.delete();
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String newDataDirectory) {
        this.dataDirectory = newDataDirectory;
    }

    protected void startService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        File systemHomeDir = ServerConfigLocator.locate().getServerHomeDir();
        this.dataDir = new File(systemHomeDir, this.dataDirectory);
        if (debug) {
            this.log.debug((Object)("Data directory set to: " + this.dataDir.getCanonicalPath()));
        }
        this.dataDir.mkdirs();
        if (!this.dataDir.isDirectory()) {
            throw new Exception("The configured data directory is not valid: " + this.dataDirectory);
        }
        File[] files = this.dataDir.listFiles();
        if (debug) {
            this.log.debug((Object)("Removing " + files.length + " file(s) from: " + this.dataDir.getCanonicalPath()));
        }
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
    }

    public Object getInstance() {
        return this;
    }
}

