/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.file;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.management.ObjectName;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.file.MessageLog;
import org.jboss.mq.pm.file.PersistenceManagerMBean;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSQueue;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;
import org.jboss.mq.server.PersistentQueue;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;

public class PersistenceManager
extends ServiceMBeanSupport
implements PersistenceManagerMBean,
org.jboss.mq.pm.PersistenceManager {
    protected static final int MAX_POOL_SIZE = 50;
    private ObjectName messageCacheName;
    private MessageCache messageCache;
    protected ArrayList txPool = new ArrayList();
    protected long tidcounter = Long.MIN_VALUE;
    String dataDirectory;
    File dataDir;
    TxManager txManager;
    HashMap messageLogs = new HashMap();
    HashMap transactedTasks = new HashMap();
    Map unrestoredMessages = new HashMap();

    public PersistenceManager() throws JMSException {
        this.txManager = new TxManager(this);
    }

    public Object getInstance() {
        return this;
    }

    public ObjectName getMessageCache() {
        return this.messageCacheName;
    }

    public void setMessageCache(ObjectName messageCache) {
        this.messageCacheName = messageCache;
    }

    public MessageCache getMessageCacheInstance() {
        return this.messageCache;
    }

    public void setDataDirectory(String newDataDirectory) {
        this.dataDirectory = newDataDirectory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void startService() throws Exception {
        File systemHomeDir = ServerConfigLocator.locate().getServerHomeDir();
        this.dataDir = new File(systemHomeDir, this.dataDirectory);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using data directory: " + this.dataDir));
        }
        this.dataDir.mkdirs();
        if (!this.dataDir.isDirectory()) {
            throw new Exception("The data directory is not valid: " + this.dataDir.getCanonicalPath());
        }
        this.messageCache = (MessageCache)this.getServer().getAttribute(this.messageCacheName, "Instance");
        this.restoreTransactions();
    }

    private void restoreTransactions() throws JMSException {
        HashMap clone;
        boolean debug = this.log.isDebugEnabled();
        TreeSet<Long> txs = new TreeSet<Long>();
        File[] transactFiles = this.dataDir.listFiles();
        int queueNameOffset = this.dataDir.toString().length() + 1;
        if (transactFiles != null) {
            int i = 0;
            while (i < transactFiles.length) {
                if (transactFiles[i].isDirectory()) {
                    String dirName = transactFiles[i].toString();
                    String key = dirName.substring(queueNameOffset);
                    MessageLog msgLog = new MessageLog(this.messageCache, transactFiles[i]);
                    LogInfo info = new LogInfo(msgLog, null);
                    HashMap hashMap = this.messageLogs;
                    synchronized (hashMap) {
                        this.messageLogs.put(key, info);
                    }
                    transactFiles[i] = null;
                } else {
                    try {
                        Long tx = new Long(Long.parseLong(transactFiles[i].getName()));
                        ArrayList removingMessages = this.readTxFile(transactFiles[i]);
                        if (this.testRollBackTx(tx, removingMessages)) {
                            txs.add(tx);
                        }
                    }
                    catch (NumberFormatException e) {
                        this.log.warn((Object)("Ignoring invalid transaction record file " + transactFiles[i].getAbsolutePath()));
                        transactFiles[i] = null;
                    }
                    catch (IOException e) {
                        SpyJMSException jmse = new SpyJMSException("IO Error when restoring.");
                        jmse.setLinkedException(e);
                        throw jmse;
                    }
                }
                ++i;
            }
        }
        if (!txs.isEmpty()) {
            this.tidcounter = (Long)txs.last() + 1L;
        }
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            clone = (HashMap)this.messageLogs.clone();
        }
        Iterator i = clone.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            LogInfo logInfo = (LogInfo)clone.get(key);
            if (debug) {
                this.log.debug((Object)("Recovered messages destined for: " + key));
            }
            this.unrestoredMessages.put(key, logInfo.log.restore(txs));
        }
        if (transactFiles != null) {
            int i2 = 0;
            while (i2 < transactFiles.length) {
                if (transactFiles[i2] != null) {
                    this.deleteTxFile(transactFiles[i2]);
                }
                ++i2;
            }
        }
    }

    public void restoreDestination(JMSDestination jmsDest) throws JMSException {
        if (jmsDest instanceof JMSQueue) {
            SpyDestination spyDest = jmsDest.getSpyDestination();
            this.restoreQueue(jmsDest, spyDest);
        } else if (jmsDest instanceof JMSTopic) {
            ArrayList persistQList = ((JMSTopic)jmsDest).getPersistentQueues();
            Iterator pq = persistQList.iterator();
            while (pq.hasNext()) {
                SpyDestination spyDest = ((PersistentQueue)pq.next()).getSpyDestination();
                this.restoreQueue(jmsDest, spyDest);
            }
        }
    }

    public void restoreQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        Map messages;
        String queueName;
        LogInfo info;
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("restoring destination: " + dest));
        }
        if ((info = (LogInfo)this.messageLogs.get(queueName = dest.toString())) == null) {
            File logDir = new File(this.dataDir, PersistenceManager.encodeFileName(queueName));
            MessageLog msgLog = new MessageLog(this.messageCache, logDir);
            info = new LogInfo(msgLog, dest);
            HashMap hashMap = this.messageLogs;
            synchronized (hashMap) {
                this.messageLogs.put(queueName, info);
            }
        } else {
            info.destination = dest;
        }
        if ((messages = (Map)this.unrestoredMessages.remove(queueName)) != null) {
            if (debug) {
                this.log.debug((Object)("Restore message count: " + messages.size()));
            }
            JMSDestination jMSDestination = jmsDest;
            synchronized (jMSDestination) {
                Iterator m = messages.values().iterator();
                while (m.hasNext()) {
                    MessageReference message = (MessageReference)m.next();
                    if (dest instanceof SpyTopic) {
                        SpyMessage sm = message.getMessage();
                        sm.header.durableSubscriberID = ((SpyTopic)dest).getDurableSubscriptionID();
                        message.invalidate();
                    }
                    jmsDest.restoreMessage(message);
                }
            }
        }
    }

    public void initQueue(SpyDestination dest) throws JMSException {
        try {
            File logDir = new File(this.dataDir, PersistenceManager.encodeFileName(dest.toString()));
            MessageLog log = new MessageLog(this.messageCache, logDir);
            LogInfo info = new LogInfo(log, dest);
            HashMap hashMap = this.messageLogs;
            synchronized (hashMap) {
                this.messageLogs.put(dest.toString(), info);
            }
        }
        catch (Exception e) {
            JMSException newE = new JMSException("Invalid configuration.");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    public void add(MessageReference messageRef, Tx txId) throws JMSException {
        LogInfo logInfo;
        SpyMessage message = messageRef.getMessage();
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logInfo = (LogInfo)this.messageLogs.get(message.getJMSDestination().toString());
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        logInfo.log.add(messageRef, txId);
        if (txId == null) {
            logInfo.log.finishAdd(messageRef, txId);
        } else {
            TxInfo info;
            HashMap hashMap2 = this.transactedTasks;
            synchronized (hashMap2) {
                info = (TxInfo)this.transactedTasks.get(txId);
            }
            if (info == null) {
                throw new JMSException("Transaction is not active 5.");
            }
            LinkedList linkedList = info.tasks;
            synchronized (linkedList) {
                info.tasks.addLast(new Transaction(true, logInfo, messageRef, txId));
            }
        }
    }

    public void commitPersistentTx(Tx txId) throws JMSException {
        TxInfo info;
        HashMap hashMap = this.transactedTasks;
        synchronized (hashMap) {
            info = (TxInfo)this.transactedTasks.remove(txId);
        }
        try {
            info.raf.close();
        }
        catch (IOException e) {
            SpyJMSException jmse = new SpyJMSException("IO Error when closing raf for tx.");
            jmse.setLinkedException(e);
            throw jmse;
        }
        LinkedList linkedList = info.tasks;
        synchronized (linkedList) {
            Iterator iter = info.tasks.iterator();
            while (iter.hasNext()) {
                Transaction task = (Transaction)iter.next();
                task.commit();
            }
        }
        this.deleteTxFile(info.txf);
        this.releaseTxInfo(info);
    }

    public Tx createPersistentTx() throws JMSException {
        Tx txId = null;
        HashMap hashMap = this.transactedTasks;
        synchronized (hashMap) {
            txId = new Tx(this.tidcounter++);
            this.transactedTasks.put(txId, this.getTxInfo(this.createTxFile(txId)));
        }
        return txId;
    }

    public void remove(MessageReference messageRef, Tx txId) throws JMSException {
        LogInfo logInfo;
        SpyMessage message = messageRef.getMessage();
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logInfo = (LogInfo)this.messageLogs.get(message.getJMSDestination().toString());
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        logInfo.log.remove(message, txId);
        if (txId == null) {
            logInfo.log.finishRemove(messageRef, txId);
        } else {
            TxInfo info;
            HashMap hashMap2 = this.transactedTasks;
            synchronized (hashMap2) {
                info = (TxInfo)this.transactedTasks.get(txId);
            }
            if (info == null) {
                throw new JMSException("Transaction is not active 6.");
            }
            try {
                info.raf.writeUTF(message.getJMSMessageID());
            }
            catch (IOException e) {
                SpyJMSException jmse = new SpyJMSException("IO Error when recording remove in txs raf.");
                jmse.setLinkedException(e);
                throw jmse;
            }
            LinkedList linkedList = info.tasks;
            synchronized (linkedList) {
                info.tasks.addLast(new Transaction(false, logInfo, messageRef, txId));
            }
        }
    }

    public void rollbackPersistentTx(Tx txId) throws JMSException {
        TxInfo info;
        HashMap hashMap = this.transactedTasks;
        synchronized (hashMap) {
            info = (TxInfo)this.transactedTasks.remove(txId);
        }
        try {
            info.raf.close();
        }
        catch (IOException e) {
            SpyJMSException jmse = new SpyJMSException("IO Error when closing raf for tx.");
            jmse.setLinkedException(e);
            throw jmse;
        }
        LinkedList linkedList = info.tasks;
        synchronized (linkedList) {
            Iterator iter = info.tasks.iterator();
            while (iter.hasNext()) {
                Transaction task = (Transaction)iter.next();
                task.rollback();
            }
        }
        this.deleteTxFile(info.txf);
        this.releaseTxInfo(info);
    }

    protected TxInfo getTxInfo(File f) throws JMSException {
        TxInfo info;
        ArrayList arrayList = this.txPool;
        synchronized (arrayList) {
            info = this.txPool.isEmpty() ? new TxInfo() : (TxInfo)this.txPool.remove(this.txPool.size() - 1);
        }
        info.setFile(f);
        return info;
    }

    protected void releaseTxInfo(TxInfo info) {
        ArrayList arrayList = this.txPool;
        synchronized (arrayList) {
            if (this.txPool.size() < 50) {
                info.tasks.clear();
                this.txPool.add(info);
            }
        }
    }

    protected boolean testRollBackTx(Long tx, ArrayList removingMessages) throws IOException {
        HashMap clone;
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            clone = (HashMap)this.messageLogs.clone();
        }
        ArrayList<File> files = new ArrayList<File>();
        boolean foundAll = true;
        int i = 0;
        while (i < removingMessages.size()) {
            String fileName = removingMessages.get(i) + "." + tx;
            boolean found = false;
            Iterator it = clone.keySet().iterator();
            block4: while (!found && it.hasNext()) {
                String dirName = (String)it.next();
                File dir = new File(this.dataDir, PersistenceManager.encodeFileName(dirName));
                File[] messageFiles = dir.listFiles();
                int j = 0;
                while (j < messageFiles.length) {
                    if (messageFiles[j].getName().equals(fileName)) {
                        found = true;
                        files.add(messageFiles[j]);
                        continue block4;
                    }
                    ++j;
                }
            }
            if (!found) {
                foundAll = false;
            }
            ++i;
        }
        if (!foundAll) {
            int i2 = 0;
            while (i2 < files.size()) {
                File f = (File)files.get(i2);
                if (!f.delete()) {
                    Thread.yield();
                    if (!f.delete()) {
                        throw new IOException("Could not delete file " + f.getAbsolutePath());
                    }
                }
                ++i2;
            }
            return false;
        }
        return true;
    }

    protected void deleteTxFile(File file) throws JMSException {
        if (!file.delete()) {
            Thread.yield();
            if (file.exists() && !file.delete()) {
                throw new JMSException("Unable to delete committing transaction record.");
            }
        }
    }

    protected ArrayList readTxFile(File file) throws JMSException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            try {
                while (true) {
                    result.add(raf.readUTF());
                }
            }
            catch (EOFException ignore) {
                raf.close();
                return result;
            }
        }
        catch (IOException e) {
            SpyJMSException newE = new SpyJMSException("Unable to read committing transaction record.");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    protected File createTxFile(Tx txId) throws JMSException {
        try {
            File file = new File(this.dataDir, txId.toString());
            if (!file.createNewFile()) {
                throw new JMSException("Error creating tx file.");
            }
            return file;
        }
        catch (IOException e) {
            SpyJMSException newE = new SpyJMSException("Unable to create committing transaction record.");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    public void closeQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("closing destination: " + dest));
        }
        String queueName = dest.toString();
        LogInfo info = (LogInfo)this.messageLogs.remove(queueName);
        this.unrestoredMessages.remove(queueName);
    }

    public static String encodeFileName(String name) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        StringBuffer rc = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            switch (name.charAt(i)) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    rc.append(name.charAt(i));
                    break;
                }
                default: {
                    try {
                        byte[] data = ("" + name.charAt(i)).getBytes("UTF8");
                        int j = 0;
                        while (j < data.length) {
                            int t = 0 | data[j];
                            rc.append('%');
                            rc.append(nf.format(t));
                            ++j;
                        }
                        break;
                    }
                    catch (UnsupportedEncodingException wonthappen) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return rc.toString();
    }

    class Transaction {
        private LogInfo logInfo;
        private MessageReference message;
        private Tx txId;
        private boolean add;

        public Transaction(boolean add, LogInfo logInfo, MessageReference message, Tx txId) {
            this.add = add;
            this.logInfo = logInfo;
            this.message = message;
            this.txId = txId;
        }

        public void commit() throws JMSException {
            if (this.add) {
                this.logInfo.log.finishAdd(this.message, this.txId);
            } else {
                this.logInfo.log.finishRemove(this.message, this.txId);
            }
        }

        public void rollback() throws JMSException {
            if (this.add) {
                this.logInfo.log.undoAdd(this.message, this.txId);
            } else {
                this.logInfo.log.undoRemove(this.message, this.txId);
            }
        }
    }

    class LogInfo {
        MessageLog log;
        SpyDestination destination;

        LogInfo(MessageLog log, SpyDestination destination) {
            this.log = log;
            this.destination = destination;
        }
    }

    class TxInfo {
        File txf;
        RandomAccessFile raf;
        LinkedList tasks = new LinkedList();

        TxInfo() throws JMSException {
        }

        void setFile(File f) throws JMSException {
            this.txf = f;
            try {
                this.raf = new RandomAccessFile(this.txf, "rw");
            }
            catch (IOException e) {
                SpyJMSException jmse = new SpyJMSException("IO Error create raf for txinfo.");
                jmse.setLinkedException(e);
                throw jmse;
            }
        }
    }
}

