/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.jdbc.MessageLog;
import org.jboss.mq.pm.jdbc.PersistenceManagerMBean;
import org.jboss.mq.pm.jdbc.TxLog;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;
import org.jboss.system.ServiceMBeanSupport;

public class PersistenceManager
extends ServiceMBeanSupport
implements PersistenceManagerMBean,
org.jboss.mq.pm.PersistenceManager {
    private ObjectName messageCacheName;
    private MessageCache messageCache;
    private ObjectName dataSourceName;
    private DataSource datasource;
    private String transactionTableName = "jms_transaction";
    private String messageTableName = "jms_messages";
    private String jmsDBPoolName;
    private MessageLog messageLog;
    private Map unrestoredMessages;
    private TxManager txManager;
    TxLog txLog;
    HashMap transactedTasks = new HashMap();

    public PersistenceManager() throws JMSException {
        this.txManager = new TxManager(this);
    }

    public Object getInstance() {
        return this;
    }

    public ObjectName getMessageCache() {
        return this.messageCacheName;
    }

    public void setMessageCache(ObjectName messageCache) {
        this.messageCacheName = messageCache;
    }

    public MessageCache getMessageCacheInstance() {
        return this.messageCache;
    }

    public ObjectName getDataSource() {
        return this.dataSourceName;
    }

    public void setDataSource(ObjectName dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getMessageTableName() {
        return this.messageTableName;
    }

    public void setMessageTableName(String tableName) {
        this.messageTableName = tableName;
    }

    public String getTransactionTableName() {
        return this.transactionTableName;
    }

    public void setTransactionTableName(String tableName) {
        this.transactionTableName = tableName;
    }

    public void startService() throws Exception {
        String dsName = (String)this.getServer().getAttribute(this.dataSourceName, "JndiName");
        InitialContext ctx = new InitialContext();
        this.datasource = (DataSource)ctx.lookup("java:/" + dsName);
        this.txLog = new TxLog(this.datasource, this.transactionTableName);
        this.messageCache = (MessageCache)this.getServer().getAttribute(this.messageCacheName, "Instance");
        this.messageLog = new MessageLog(this.messageCache, this.datasource, this.messageTableName);
        this.restoreTransactions();
    }

    private void restoreTransactions() throws JMSException {
        TreeSet lostTx = this.txLog.restore();
        if (!lostTx.isEmpty()) {
            this.log.error((Object)"Unrecoverable transactions found in jdbc persistence manager! Your data is corrupt!");
        }
        this.unrestoredMessages = this.messageLog.restoreAll();
    }

    public void restoreQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        if (jmsDest == null) {
            throw new IllegalArgumentException("Must supply non null JMSDestination to restoreQueue");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Must supply non null SpyDestination to restoreQueue");
        }
        Map messages = (Map)this.unrestoredMessages.get(dest.getName());
        if (messages != null) {
            Iterator i = messages.values().iterator();
            while (i.hasNext()) {
                jmsDest.restoreMessage((MessageReference)i.next());
            }
        }
    }

    public void add(MessageReference messageRef, Tx txId) throws JMSException {
        SpyMessage message = messageRef.getMessage();
        this.messageLog.add(message, txId);
        if (txId != null) {
            LinkedList tasks;
            HashMap hashMap = this.transactedTasks;
            synchronized (hashMap) {
                tasks = (LinkedList)this.transactedTasks.get(txId);
            }
            if (tasks == null) {
                throw new JMSException("Transaction is not active 5.");
            }
            LinkedList linkedList = tasks;
            synchronized (linkedList) {
                tasks.addLast(new Transaction(true, message, txId));
            }
        }
    }

    public void commitPersistentTx(Tx txId) throws JMSException {
        LinkedList transacted;
        HashMap hashMap = this.transactedTasks;
        synchronized (hashMap) {
            transacted = (LinkedList)this.transactedTasks.remove(txId);
        }
        LinkedList linkedList = transacted;
        synchronized (linkedList) {
            Iterator iter = transacted.iterator();
            while (iter.hasNext()) {
                Transaction task = (Transaction)iter.next();
                task.commit();
            }
        }
        this.txLog.commitTx(txId);
    }

    public Tx createPersistentTx() throws JMSException {
        Tx txId = this.txLog.createTx();
        HashMap hashMap = this.transactedTasks;
        synchronized (hashMap) {
            this.transactedTasks.put(txId, new LinkedList());
        }
        return txId;
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void remove(MessageReference messageRef, Tx txId) throws JMSException {
        SpyMessage message = messageRef.getMessage();
        if (txId == null) {
            this.messageLog.remove(message, txId);
        } else {
            LinkedList tasks;
            HashMap hashMap = this.transactedTasks;
            synchronized (hashMap) {
                tasks = (LinkedList)this.transactedTasks.get(txId);
            }
            if (tasks == null) {
                throw new JMSException("Transaction is not active 6.");
            }
            LinkedList linkedList = tasks;
            synchronized (linkedList) {
                tasks.addLast(new Transaction(false, message, txId));
            }
        }
    }

    public void rollbackPersistentTx(Tx txId) throws JMSException {
        LinkedList transacted;
        HashMap hashMap = this.transactedTasks;
        synchronized (hashMap) {
            transacted = (LinkedList)this.transactedTasks.remove(txId);
        }
        LinkedList linkedList = transacted;
        synchronized (linkedList) {
            Iterator iter = transacted.iterator();
            while (iter.hasNext()) {
                Transaction task = (Transaction)iter.next();
                task.rollback();
            }
        }
        this.txLog.rollbackTx(txId);
    }

    public void closeQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
    }

    class Transaction {
        private SpyMessage message;
        private Tx txId;
        private boolean add;

        public Transaction(boolean add, SpyMessage message, Tx txId) {
            this.add = add;
            this.message = message;
            this.txId = txId;
        }

        public void commit() throws JMSException {
            if (!this.add) {
                PersistenceManager.this.messageLog.remove(this.message, this.txId);
            }
        }

        public void rollback() throws JMSException {
            if (this.add) {
                PersistenceManager.this.messageLog.remove(this.message, this.txId);
            }
        }
    }
}

