/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.jms.JMSException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.pm.CacheStore;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.jdbc2.PersistenceManagerMBean;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerService;

public class PersistenceManager
extends ServiceMBeanSupport
implements PersistenceManagerMBean,
org.jboss.mq.pm.PersistenceManager,
CacheStore {
    private long nextTransactionId = 0L;
    private TxManager txManager;
    private DataSource datasource;
    private MessageCache messageCache;
    private TransactionManager tm;
    String SELECT_ALL_UNCOMMITED_TXS = "SELECT TXID FROM JMS_TRANSACTIONS";
    String DELETE_ALL_MESSAGE_WITH_TX = "DELETE FROM JMS_MESSAGES WHERE TXID=?";
    String DELETE_TX = "DELETE FROM JMS_TRANSACTIONS WHERE TXID = ?";
    String DELETE_MARKED_MESSAGES = "DELETE FROM JMS_MESSAGES WHERE TXID=? AND TXOP=?";
    String INSERT_TX = "INSERT INTO JMS_TRANSACTIONS (TXID) values(?)";
    String SELECT_MAX_TX = "SELECT MAX(TXID) FROM JMS_MESSAGES";
    String SELECT_MESSAGES_IN_DEST = "SELECT MESSAGEID, MESSAGEBLOB FROM JMS_MESSAGES WHERE DESTINATION=?";
    String SELECT_MESSAGE = "SELECT MESSAGEID, MESSAGEBLOB FROM JMS_MESSAGES WHERE MESSAGEID=? AND DESTINATION=?";
    String INSERT_MESSAGE = "INSERT INTO JMS_MESSAGES (MESSAGEID, DESTINATION, MESSAGEBLOB, TXID, TXOP) VALUES(?,?,?,?,?)";
    String MARK_MESSAGE = "UPDATE JMS_MESSAGES SET (TXID, TXOP) VALUES(?,?) WHERE MESSAGEID=? AND DESTINATION=?";
    String DELETE_MESSAGE = "DELETE FROM JMS_MESSAGES WHERE MESSAGEID=? AND DESTINATION=?";
    String CREATE_MESSAGE_TABLE = "CREATE TABLE JMS_MESSAGES ( MESSAGEID INTEGER NOT NULL, DESTINATION VARCHAR(32) NOT NULL, TXID INTEGER, TXOP CHAR(1),MESSAGEBLOB OBJECT, PRIMARY KEY (MESSAGEID, DESTINATION) )";
    String CREATE_TX_TABLE = "CREATE TABLE JMS_TRANSACTIONS ( TXID INTEGER )";
    static final int OBJECT_BLOB = 0;
    static final int BYTES_BLOB = 1;
    static final int BINARYSTREAM_BLOB = 2;
    static final int BLOB_BLOB = 3;
    int blobType = 0;
    boolean createTables;
    private ObjectName messageCacheName;
    private ObjectName dataSourceName;
    private Properties sqlProperties = new Properties();

    public PersistenceManager() throws JMSException {
        this.txManager = new TxManager(this);
    }

    /*
     * Loose catch block
     */
    public synchronized void resolveAllUncommitedTXs() throws JMSException {
        TransactionManagerStrategy tms;
        block33: {
            ResultSet rs;
            Statement stmt;
            Connection c;
            block30: {
                block34: {
                    block35: {
                        tms = new TransactionManagerStrategy();
                        tms.startTX();
                        c = null;
                        stmt = null;
                        rs = null;
                        c = this.datasource.getConnection();
                        if (!this.createTables) break block34;
                        stmt = c.prepareStatement(this.CREATE_MESSAGE_TABLE);
                        stmt.executeUpdate();
                        Object var7_5 = null;
                        try {
                            stmt.close();
                        }
                        catch (Throwable ignore) {}
                        break block35;
                        {
                            catch (SQLException e) {
                                this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_MESSAGE_TABLE + ", got : " + e));
                                var7_5 = null;
                                try {
                                    stmt.close();
                                }
                                catch (Throwable ignore) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_6 = null;
                            try {
                                stmt.close();
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    stmt = c.prepareStatement(this.CREATE_TX_TABLE);
                    stmt.executeUpdate();
                    Object var10_16 = null;
                    try {
                        stmt.close();
                    }
                    catch (Throwable ignore) {}
                    break block34;
                    {
                        catch (SQLException e) {
                            this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_TX_TABLE + ", got : " + e));
                            var10_16 = null;
                            try {
                                stmt.close();
                            }
                            catch (Throwable ignore) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_17 = null;
                        try {
                            stmt.close();
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                stmt = c.prepareStatement(this.DELETE_ALL_MESSAGE_WITH_TX);
                Collection unresolvedTXs = this.findAllUncommitedTXs(c);
                Iterator i = unresolvedTXs.iterator();
                while (i.hasNext()) {
                    long txid = (Long)i.next();
                    stmt.setLong(1, txid);
                    stmt.executeUpdate();
                }
                stmt.close();
                this.removeMarkedMessages(c, null, "T");
                stmt = c.prepareStatement(this.SELECT_MAX_TX);
                rs = stmt.executeQuery();
                if (!rs.next()) break block30;
                this.nextTransactionId = rs.getLong(1) + 1L;
            }
            Object var13_21 = null;
            try {
                rs.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
                break block33;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
                break block33;
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not resolve uncommited transactions.  Message recovery may not be accurate", e);
                }
            }
            catch (Throwable throwable) {
                Object var13_22 = null;
                try {
                    rs.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                throw throwable;
            }
        }
        tms.endTX();
    }

    public Collection findAllUncommitedTXs(Connection con) throws SQLException {
        LinkedList<Long> items = new LinkedList<Long>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(this.SELECT_ALL_UNCOMMITED_TXS);
            rs = stmt.executeQuery();
            while (rs.next()) {
                long id = rs.getLong(1);
                items.add(new Long(id));
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                rs.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            rs.close();
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            stmt.close();
        }
        catch (Throwable ignore) {}
        return items;
    }

    /*
     * Loose catch block
     */
    public synchronized void restoreQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        TransactionManagerStrategy tms;
        block20: {
            if (jmsDest == null) {
                throw new IllegalArgumentException("Must supply non null JMSDestination to restoreQueue");
            }
            if (dest == null) {
                throw new IllegalArgumentException("Must supply non null SpyDestination to restoreQueue");
            }
            tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            c = this.datasource.getConnection();
            stmt = c.prepareStatement(this.SELECT_MESSAGES_IN_DEST);
            stmt.setString(1, dest.toString());
            rs = stmt.executeQuery();
            int counter = 0;
            while (rs.next()) {
                SpyMessage message = this.extractMessage(rs);
                if (dest instanceof SpyTopic) {
                    message.header.durableSubscriberID = ((SpyTopic)dest).getDurableSubscriptionID();
                }
                MessageReference mr = this.messageCache.add(message);
                mr.setStored(((SpyDestination)message.getJMSDestination()).toString());
                jmsDest.restoreMessage(mr);
                ++counter;
            }
            this.log.debug((Object)("Restored " + counter + " message(s) to: " + dest));
            Object var11_12 = null;
            try {
                rs.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
                break block20;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
                break block20;
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not restore messages to destination : " + dest.toString(), e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not restore messages to destination : " + dest.toString(), e);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    rs.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                throw throwable;
            }
        }
        tms.endTX();
    }

    SpyMessage extractMessage(ResultSet rs) throws SQLException, IOException {
        try {
            long messageid = rs.getLong(1);
            SpyMessage message = null;
            if (this.blobType == 0) {
                message = (SpyMessage)rs.getObject(2);
            } else if (this.blobType == 1) {
                byte[] st = rs.getBytes(2);
                ByteArrayInputStream baip = new ByteArrayInputStream(st);
                ObjectInputStream ois = new ObjectInputStream(baip);
                message = SpyMessage.readMessage(ois);
            } else if (this.blobType == 2) {
                ObjectInputStream ois = new ObjectInputStream(rs.getBinaryStream(2));
                message = SpyMessage.readMessage(ois);
            } else if (this.blobType == 3) {
                ObjectInputStream ois = new ObjectInputStream(rs.getBlob(2).getBinaryStream());
                message = SpyMessage.readMessage(ois);
            }
            message.header.messageId = messageid;
            return message;
        }
        catch (StreamCorruptedException e) {
            throw new IOException("Could not load the message: " + e);
        }
    }

    /*
     * Loose catch block
     */
    public void commitPersistentTx(Tx txId) throws JMSException {
        TransactionManagerStrategy tms;
        block7: {
            tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            c = this.datasource.getConnection();
            this.removeMarkedMessages(c, txId, "D");
            this.removeTXRecord(c, txId.longValue());
            Object var6_4 = null;
            try {
                c.close();
                break block7;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
                break block7;
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not commit tx: " + txId, e);
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                throw throwable;
            }
        }
        tms.endTX();
    }

    public void removeMarkedMessages(Connection c, Tx txid, String mark) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.DELETE_MARKED_MESSAGES);
            if (txid != null) {
                stmt.setLong(1, txid.longValue());
            } else {
                stmt.setNull(1, -5);
            }
            stmt.setString(2, mark);
            stmt.executeUpdate();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                stmt.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (Throwable e) {}
    }

    public void removeTXRecord(Connection c, long txid) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.DELETE_TX);
            stmt.setLong(1, txid);
            stmt.executeUpdate();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                stmt.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (Throwable e) {}
    }

    /*
     * Loose catch block
     */
    public void rollbackPersistentTx(Tx txId) throws JMSException {
        TransactionManagerStrategy tms;
        block7: {
            tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            c = this.datasource.getConnection();
            this.removeMarkedMessages(c, txId, "A");
            this.removeTXRecord(c, txId.longValue());
            Object var6_4 = null;
            try {
                c.close();
                break block7;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
                break block7;
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not rollback tx: " + txId, e);
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                throw throwable;
            }
        }
        tms.endTX();
    }

    /*
     * Loose catch block
     */
    public Tx createPersistentTx() throws JMSException {
        TransactionManagerStrategy tms;
        Tx id;
        block11: {
            id = new Tx(this.nextTransactionId++);
            tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Statement stmt = null;
            c = this.datasource.getConnection();
            stmt = c.prepareStatement(this.INSERT_TX);
            stmt.setLong(1, id.longValue());
            stmt.executeUpdate();
            Object var7_5 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
                break block11;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
                break block11;
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not crate tx: " + id, e);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                throw throwable;
            }
        }
        tms.endTX();
        return id;
    }

    /*
     * Loose catch block
     */
    public void add(MessageReference messageRef, Tx txId) throws JMSException {
        TransactionManagerStrategy tms;
        block14: {
            Statement stmt;
            Connection c;
            block12: {
                tms = new TransactionManagerStrategy();
                tms.startTX();
                c = null;
                stmt = null;
                c = this.datasource.getConnection();
                if (messageRef.persistData != null) {
                    this.markMessage(c, messageRef.messageId, (String)messageRef.persistData, txId, "A");
                    break block12;
                }
                SpyMessage message = messageRef.getMessage();
                this.add(c, message, txId, "A");
                messageRef.setStored(((SpyDestination)message.getJMSDestination()).toString());
            }
            Object var9_8 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
                break block14;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
                break block14;
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef.messageId, e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef.messageId, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                throw throwable;
            }
        }
        tms.endTX();
    }

    public void add(Connection c, SpyMessage message, Tx txId, String mark) throws SQLException, IOException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.INSERT_MESSAGE);
            stmt.setLong(1, message.header.messageId);
            stmt.setString(2, ((SpyDestination)message.getJMSDestination()).toString());
            if (this.blobType == 0) {
                stmt.setObject(3, message);
            } else if (this.blobType == 1) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                SpyMessage.writeMessage(message, oos);
                oos.flush();
                byte[] messageAsBytes = baos.toByteArray();
                stmt.setBytes(3, messageAsBytes);
            } else if (this.blobType == 2) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                SpyMessage.writeMessage(message, oos);
                oos.flush();
                byte[] messageAsBytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(messageAsBytes);
                stmt.setBinaryStream(3, (InputStream)bais, messageAsBytes.length);
            } else if (this.blobType == 3) {
                throw new RuntimeException("BLOB_TYPE: BLOB_BLOB is not yet implemented.");
            }
            if (txId != null) {
                stmt.setLong(4, txId.longValue());
            } else {
                stmt.setNull(4, -5);
            }
            stmt.setString(5, mark);
            stmt.executeUpdate();
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (Throwable ignore) {}
    }

    public void markMessage(Connection c, long messageid, String destination, Tx txId, String mark) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.MARK_MESSAGE);
            if (txId == null) {
                stmt.setNull(1, -5);
            } else {
                stmt.setLong(1, txId.longValue());
            }
            stmt.setString(2, mark);
            stmt.setLong(3, messageid);
            stmt.setString(4, destination);
            stmt.executeUpdate();
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (Throwable ignore) {}
    }

    /*
     * Loose catch block
     */
    public void remove(MessageReference messageRef, Tx txId) throws JMSException {
        TransactionManagerStrategy tms;
        block15: {
            tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Statement stmt = null;
            c = this.datasource.getConnection();
            if (txId == null) {
                stmt = c.prepareStatement(this.DELETE_MESSAGE);
                stmt.setLong(1, messageRef.messageId);
                stmt.setString(2, (String)messageRef.persistData);
                int rc = stmt.executeUpdate();
                if (rc != 1) {
                    throw new SpyJMSException("Could not delete the message from the database: delete affected " + rc + " rows");
                }
                messageRef.setStored(null);
            } else {
                stmt = c.prepareStatement(this.MARK_MESSAGE);
                stmt.setLong(1, txId.longValue());
                stmt.setString(2, "D");
                stmt.setLong(3, messageRef.messageId);
                stmt.setString(4, (String)messageRef.persistData);
                int rc = stmt.executeUpdate();
                if (rc != 1) {
                    throw new SpyJMSException("Could not mark the message as deleted in the database: update affected " + rc + " rows");
                }
            }
            Object var8_9 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
                break block15;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
                break block15;
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not remove message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                throw throwable;
            }
        }
        tms.endTX();
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void closeQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpyMessage loadFromStorage(MessageReference messageRef) throws JMSException {
        block28: {
            block27: {
                block26: {
                    block19: {
                        block25: {
                            block24: {
                                block23: {
                                    block18: {
                                        tms = new TransactionManagerStrategy();
                                        tms.startTX();
                                        c = null;
                                        stmt = null;
                                        rs = null;
                                        try {
                                            try {
                                                c = this.datasource.getConnection();
                                                stmt = c.prepareStatement(this.SELECT_MESSAGE);
                                                stmt.setLong(1, messageRef.messageId);
                                                stmt.setString(2, (String)messageRef.persistData);
                                                rs = stmt.executeQuery();
                                                if (rs.next()) {
                                                    var6_6 = this.extractMessage(rs);
                                                    var9_8 = null;
                                                    break block18;
                                                }
                                                var7_14 = null;
                                                break block19;
                                            }
                                            catch (IOException e) {
                                                tms.setRollbackOnly();
                                                throw new SpyJMSException("Could not load message : " + messageRef, e);
                                            }
                                            catch (SQLException e) {
                                                tms.setRollbackOnly();
                                                throw new SpyJMSException("Could not load message : " + messageRef, e);
                                            }
                                        }
                                        catch (Throwable var8_16) {
                                            var9_10 = null;
                                            try {
                                                rs.close();
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                            try {
                                                stmt.close();
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                            try {
                                                c.close();
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                            tms.endTX();
                                            throw var8_16;
                                        }
                                    }
                                    ** try [egrp 2[TRYBLOCK] [3 : 192->202)] { 
lbl52:
                                    // 1 sources

                                    rs.close();
                                    break block23;
lbl54:
                                    // 1 sources

                                    catch (Throwable ignore) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [4 : 204->214)] { 
lbl58:
                                // 1 sources

                                stmt.close();
                                break block24;
lbl60:
                                // 1 sources

                                catch (Throwable ignore) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 4[TRYBLOCK] [5 : 216->225)] { 
lbl64:
                            // 1 sources

                            c.close();
                            break block25;
lbl66:
                            // 1 sources

                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        tms.endTX();
                        return var6_6;
                    }
                    var9_9 = null;
                    ** try [egrp 2[TRYBLOCK] [3 : 192->202)] { 
lbl74:
                    // 1 sources

                    rs.close();
                    break block26;
lbl76:
                    // 1 sources

                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [4 : 204->214)] { 
lbl80:
                // 1 sources

                stmt.close();
                break block27;
lbl82:
                // 1 sources

                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            ** try [egrp 4[TRYBLOCK] [5 : 216->225)] { 
lbl86:
            // 1 sources

            c.close();
            break block28;
lbl88:
            // 1 sources

            catch (Throwable ignore) {
                // empty catch block
            }
        }
        tms.endTX();
        return var7_14;
    }

    /*
     * Loose catch block
     */
    public void removeFromStorage(MessageReference messageRef) throws JMSException {
        TransactionManagerStrategy tms;
        block12: {
            if (messageRef.getHeaders().jmsDeliveryMode == 2) {
                return;
            }
            tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Statement stmt = null;
            c = this.datasource.getConnection();
            stmt = c.prepareStatement(this.DELETE_MESSAGE);
            stmt.setLong(1, messageRef.messageId);
            stmt.setString(2, (String)messageRef.persistData);
            stmt.executeUpdate();
            messageRef.setStored(null);
            Object var7_5 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
                break block12;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
                break block12;
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not remove message: " + messageRef.messageId, e);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                throw throwable;
            }
        }
        tms.endTX();
    }

    /*
     * Loose catch block
     */
    public void saveToStorage(MessageReference messageRef, SpyMessage message) throws JMSException {
        TransactionManagerStrategy tms;
        block9: {
            if (messageRef.persistData != null) {
                messageRef.setStored(messageRef.persistData);
                return;
            }
            tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Object stmt = null;
            c = this.datasource.getConnection();
            this.add(c, message, null, "T");
            messageRef.setStored(((SpyDestination)message.getJMSDestination()).toString());
            Object var9_6 = null;
            try {
                c.close();
                break block9;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
                break block9;
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef.messageId, e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef.messageId, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                throw throwable;
            }
        }
        tms.endTX();
    }

    public void startService() throws Exception {
        this.SELECT_ALL_UNCOMMITED_TXS = this.sqlProperties.getProperty("SELECT_ALL_UNCOMMITED_TXS", this.SELECT_ALL_UNCOMMITED_TXS);
        this.DELETE_ALL_MESSAGE_WITH_TX = this.sqlProperties.getProperty("DELETE_ALL_MESSAGE_WITH_TX", this.DELETE_ALL_MESSAGE_WITH_TX);
        this.DELETE_TX = this.sqlProperties.getProperty("DELETE_TX", this.DELETE_TX);
        this.DELETE_MARKED_MESSAGES = this.sqlProperties.getProperty("DELETE_MARKED_MESSAGES", this.DELETE_MARKED_MESSAGES);
        this.INSERT_TX = this.sqlProperties.getProperty("INSERT_TX", this.INSERT_TX);
        this.SELECT_MAX_TX = this.sqlProperties.getProperty("SELECT_MAX_TX", this.SELECT_MAX_TX);
        this.SELECT_MESSAGES_IN_DEST = this.sqlProperties.getProperty("SELECT_MESSAGES_IN_DEST", this.SELECT_MESSAGES_IN_DEST);
        this.SELECT_MESSAGE = this.sqlProperties.getProperty("SELECT_MESSAGE", this.SELECT_MESSAGE);
        this.INSERT_MESSAGE = this.sqlProperties.getProperty("INSERT_MESSAGE", this.INSERT_MESSAGE);
        this.MARK_MESSAGE = this.sqlProperties.getProperty("MARK_MESSAGE", this.MARK_MESSAGE);
        this.DELETE_MESSAGE = this.sqlProperties.getProperty("DELETE_MESSAGE", this.DELETE_MESSAGE);
        this.CREATE_MESSAGE_TABLE = this.sqlProperties.getProperty("CREATE_MESSAGE_TABLE", this.CREATE_MESSAGE_TABLE);
        this.CREATE_TX_TABLE = this.sqlProperties.getProperty("CREATE_TX_TABLE", this.CREATE_TX_TABLE);
        this.createTables = this.sqlProperties.getProperty("CREATE_TABLES_ON_STARTUP", "true").equals("true");
        String s = this.sqlProperties.getProperty("BLOB_TYPE", "OBJECT_BLOB");
        if (s.equals("OBJECT_BLOB")) {
            this.blobType = 0;
        } else if (s.equals("BYTES_BLOB")) {
            this.blobType = 1;
        } else if (s.equals("BINARYSTREAM_BLOB")) {
            this.blobType = 2;
        } else if (s.equals("BLOB_BLOB")) {
            this.blobType = 3;
        }
        String dsName = (String)this.getServer().getAttribute(this.dataSourceName, "JndiName");
        InitialContext ctx = new InitialContext();
        this.datasource = (DataSource)ctx.lookup("java:/" + dsName);
        this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
        this.messageCache = (MessageCache)this.getServer().getAttribute(this.messageCacheName, "Instance");
        this.log.debug((Object)"Resolving uncommited TXS");
        this.resolveAllUncommitedTXs();
    }

    public Object getInstance() {
        return this;
    }

    public ObjectName getMessageCache() {
        return this.messageCacheName;
    }

    public void setMessageCache(ObjectName messageCache) {
        this.messageCacheName = messageCache;
    }

    public ObjectName getDataSource() {
        return this.dataSourceName;
    }

    public void setDataSource(ObjectName dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public MessageCache getMessageCacheInstance() {
        return this.messageCache;
    }

    public String getSqlProperties() {
        try {
            ByteArrayOutputStream boa = new ByteArrayOutputStream();
            this.sqlProperties.store(boa, "");
            return new String(boa.toByteArray());
        }
        catch (IOException shouldnothappen) {
            return "";
        }
    }

    public void setSqlProperties(String value) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
            this.sqlProperties = new Properties();
            this.sqlProperties.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class TransactionManagerStrategy {
        Transaction threadTx;
        Transaction newTransaction;

        TransactionManagerStrategy() {
        }

        void startTX() throws JMSException {
            try {
                this.threadTx = PersistenceManager.this.tm.suspend();
                PersistenceManager.this.tm.begin();
                this.newTransaction = PersistenceManager.this.tm.getTransaction();
            }
            catch (Exception e) {
                try {
                    if (this.threadTx != null) {
                        PersistenceManager.this.tm.resume(this.threadTx);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SpyJMSException("Could not start a transaction with the transaction manager.", e);
            }
        }

        void setRollbackOnly() throws JMSException {
            try {
                this.newTransaction.setRollbackOnly();
            }
            catch (Exception e) {
                throw new SpyJMSException("Could not start a mark the transaction for rollback .", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void endTX() throws JMSException {
            try {
                try {
                    if (this.newTransaction.getStatus() == 1) {
                        this.newTransaction.rollback();
                    } else {
                        this.newTransaction.commit();
                    }
                }
                catch (Exception e) {
                    throw new SpyJMSException("Could not start a transaction with the transaction manager.", e);
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    if (this.threadTx == null) throw throwable;
                    PersistenceManager.this.tm.resume(this.threadTx);
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ignore) {}
            if (this.threadTx == null) return;
            PersistenceManager.this.tm.resume(this.threadTx);
            return;
        }
    }
}

