/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.security.SecurityManagerMBean;
import org.jboss.mq.security.SecurityMetadata;
import org.jboss.mq.security.ServerSecurityInterceptor;
import org.jboss.mq.security.SessionIDGenerator;
import org.jboss.mq.server.JMSServerInterceptor;
import org.jboss.mq.server.jmx.InterceptorMBeanSupport;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.w3c.dom.Element;

public class SecurityManager
extends InterceptorMBeanSupport
implements SecurityManagerMBean {
    private ObjectName name;
    String securityDomainName = "java:/jaas/jbossmq";
    Context securityCtx;
    HashMap authCache = new HashMap(32);
    HashMap securityConf = new HashMap(32);
    ServerSecurityInterceptor interceptor;
    SubjectSecurityManager sec;
    SessionIDGenerator idGenerator;
    static /* synthetic */ Class class$java$security$acl$Group;
    static /* synthetic */ Class class$java$security$Principal;

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.name = name == null ? SecurityManagerMBean.OBJECT_NAME : name;
        return this.name;
    }

    public JMSServerInterceptor getInvoker() {
        return this.interceptor;
    }

    public String printAuthCache() {
        return this.authCache.toString();
    }

    public void addDestination(String destName, Element conf) throws Exception {
        SecurityMetadata m = new SecurityMetadata(conf);
        this.securityConf.put(destName, m);
    }

    public void addDestination(String destName, String conf) throws Exception {
        SecurityMetadata m = new SecurityMetadata(conf);
        this.securityConf.put(destName, m);
    }

    public void removeDestination(String destName) throws Exception {
        this.securityConf.remove(destName);
    }

    public SecurityMetadata getSecurityMetadata(String destName) {
        SecurityMetadata m = (SecurityMetadata)this.securityConf.get(destName);
        if (m == null) {
            this.log.warn((Object)("No SecurityMetadadata was available for " + destName + " adding default security conf"));
            m = new SecurityMetadata();
            this.securityConf.put(destName, m);
        }
        return m;
    }

    public void startService() throws Exception {
        try {
            InitialContext iniCtx = new InitialContext();
            this.sec = (SubjectSecurityManager)iniCtx.lookup(this.securityDomainName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.interceptor = new ServerSecurityInterceptor(this);
        this.idGenerator = new SessionIDGenerator();
        super.startService();
    }

    public void stopService() throws Exception {
    }

    public String authenticate(String user, String password) throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (this.sec instanceof SubjectSecurityManager) {
            SubjectSecurityManager securityMgr = this.sec;
            SimplePrincipal principal = new SimplePrincipal(user);
            char[] passwordChars = null;
            if (password != null) {
                passwordChars = password.toCharArray();
            }
            if (securityMgr.isValid((Principal)principal, (Object)passwordChars)) {
                if (trace) {
                    this.log.trace((Object)("Username: " + user + " is authenticated"));
                }
                Subject subject = securityMgr.getActiveSubject();
                String sessionId = this.generateId(subject);
                this.addId(sessionId, subject, (Principal)principal);
                return sessionId;
            }
            if (trace) {
                this.log.trace((Object)("User: " + user + " is NOT authenticated"));
            }
            throw new JMSSecurityException("User: " + user + " is NOT authenticated");
        }
        throw new IllegalStateException("SecurityManager only works with a SubjectSecurityManager");
    }

    public boolean authorize(ConnectionToken token, Set rolePrincipals) throws JMSException {
        Group group;
        boolean trace = this.log.isTraceEnabled();
        boolean hasRole = false;
        SubjectInfo info = (SubjectInfo)this.authCache.get(token.getSessionId());
        if (info == null) {
            throw new JMSSecurityException("User session is not valid");
        }
        if (trace) {
            this.log.trace((Object)("Checking authorize on subjectInfo: " + info.toString() + " for rolePrincipals " + rolePrincipals.toString()));
        }
        if ((group = info.roles) != null) {
            Iterator iter = rolePrincipals.iterator();
            while (!hasRole && iter.hasNext()) {
                Principal role = (Principal)iter.next();
                hasRole = group.isMember(role);
            }
        }
        return hasRole;
    }

    public void logout(ConnectionToken token) {
        if (token == null) {
            return;
        }
        this.removeId(token.getSessionId());
    }

    private void addId(String id, Subject subject, Principal callerPrincipal) {
        boolean trace = this.log.isTraceEnabled();
        SubjectInfo info = new SubjectInfo();
        info.subject = subject;
        info.principal = callerPrincipal;
        Set subjectGroups = subject.getPrincipals(class$java$security$acl$Group == null ? (class$java$security$acl$Group = SecurityManager.class$("java.security.acl.Group")) : class$java$security$acl$Group);
        Iterator iter = subjectGroups.iterator();
        while (iter.hasNext()) {
            Group grp = (Group)iter.next();
            String name = grp.getName();
            if (name.equals("CallerPrincipal")) {
                Enumeration members = grp.members();
                if (!members.hasMoreElements()) continue;
                info.principal = (Principal)members.nextElement();
                continue;
            }
            if (!name.equals("Roles")) continue;
            if (trace) {
                this.log.trace((Object)("Adding group : " + grp.getClass() + " " + grp.toString()));
            }
            info.roles = grp;
        }
        if (callerPrincipal == null && info.principal == null) {
            Set subjectPrincipals = subject.getPrincipals(class$java$security$Principal == null ? (class$java$security$Principal = SecurityManager.class$("java.security.Principal")) : class$java$security$Principal);
            iter = subjectPrincipals.iterator();
            while (iter.hasNext()) {
                Principal p = (Principal)iter.next();
                if (p instanceof Group) continue;
                info.principal = p;
            }
        }
        HashMap hashMap = this.authCache;
        synchronized (hashMap) {
            this.authCache.put(id, info);
        }
    }

    private void removeId(String id) {
        HashMap hashMap = this.authCache;
        synchronized (hashMap) {
            this.authCache.remove(id);
        }
    }

    private String generateId(Subject subject) throws JMSException {
        try {
            return this.idGenerator.nextSessionId();
        }
        catch (Exception ex) {
            this.log.error((Object)"Could not generate a secure sessionID", (Throwable)ex);
            throw new JMSSecurityException("Could not generate a secure sessionID");
        }
    }

    public JMSServerInterceptor getInterceptor() {
        return this.interceptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SubjectInfo {
        Subject subject;
        Principal principal;
        Group roles;

        SubjectInfo() {
        }

        public String toString() {
            return "SubjectInfo {subject=" + this.subject + ";principal=" + this.principal + ";roles=" + this.roles.toString();
        }
    }
}

