/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.server.JMSServerInterceptorSupport;

public class DelayInterceptor
extends JMSServerInterceptorSupport {
    public boolean delayEnabled = false;
    public long delayTime = 50L;

    public ThreadGroup getThreadGroup() {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().getThreadGroup();
    }

    public String getID() throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().getID();
    }

    public TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().getTemporaryTopic(dc);
    }

    public TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().getTemporaryQueue(dc);
    }

    public void connectionClosing(ConnectionToken dc) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().connectionClosing(dc);
    }

    public void checkID(String ID) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().checkID(ID);
    }

    public void addMessage(ConnectionToken dc, SpyMessage message) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().addMessage(dc, message);
    }

    public Queue createQueue(ConnectionToken dc, String dest) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().createQueue(dc, dest);
    }

    public Topic createTopic(ConnectionToken dc, String dest) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().createTopic(dc, dest);
    }

    public void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().deleteTemporaryDestination(dc, dest);
    }

    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().transact(dc, t);
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().acknowledge(dc, item);
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().browse(dc, dest, selector);
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().receive(dc, subscriberId, wait);
    }

    public void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().setEnabled(dc, enabled);
    }

    public void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().unsubscribe(dc, subscriptionId);
    }

    public void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().destroySubscription(dc, id);
    }

    public String checkUser(String userName, String password) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().checkUser(userName, password);
    }

    public String authenticate(String userName, String password) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().authenticate(userName, password);
    }

    public void subscribe(ConnectionToken dc, Subscription s) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().subscribe(dc, s);
    }

    public void ping(ConnectionToken dc, long clientTime) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.getNext().ping(dc, clientTime);
    }

    public SpyTopic getDurableTopic(DurableSubscriptionID sub) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().getDurableTopic(sub);
    }

    public Subscription getSubscription(ConnectionToken dc, int subscriberId) throws JMSException {
        if (this.delayEnabled) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.getNext().getSubscription(dc, subscriberId);
    }

    public boolean isDelayEnabled() {
        return this.delayEnabled;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public void setDelayEnabled(boolean delayEnabled) {
        this.delayEnabled = delayEnabled;
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }
}

