/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.JMSException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageReference;
import org.jboss.mq.server.PersistentQueue;

public class JMSQueue
extends JMSDestination {
    public BasicQueue queue;

    public JMSQueue(SpyDestination dest, ClientConsumer temporary, JMSDestinationManager server) throws JMSException {
        super(dest, temporary, server);
        if (this.temporaryDestination == null) {
            this.queue = new PersistentQueue(server, dest);
            server.getPersistenceManager().restoreQueue(this, dest);
        } else {
            this.queue = new BasicQueue(server, this.destination.toString());
        }
    }

    public void clientConsumerStopped(ClientConsumer clientConsumer) {
        this.queue.clientConsumerStopped(clientConsumer);
    }

    public void addSubscriber(Subscription sub) {
    }

    public void removeSubscriber(Subscription sub) {
        this.queue.removeSubscriber(sub);
    }

    public void nackMessages(Subscription sub) {
        this.queue.nackMessages(sub);
    }

    public void addReceiver(Subscription sub) {
        this.queue.addReceiver(sub);
    }

    public void removeReceiver(Subscription sub) {
        this.queue.removeReceiver(sub);
    }

    public void restoreMessage(MessageReference messageRef) {
        try {
            SpyMessage spyMessage = messageRef.getMessage();
            JMSQueue jMSQueue = this;
            synchronized (jMSQueue) {
                this.messageIdCounter = Math.max(this.messageIdCounter, spyMessage.header.messageId + 1L);
            }
            this.queue.restoreMessage(messageRef);
        }
        catch (JMSException e) {
            this.cat.error((Object)"Could not restore message:", (Throwable)e);
        }
    }

    public SpyMessage[] browse(String selector) throws JMSException {
        return this.queue.browse(selector);
    }

    public String toString() {
        return "JMSDestination:" + this.destination;
    }

    public void acknowledge(AcknowledgementRequest req, Subscription sub, Tx txId) throws JMSException {
        this.queue.acknowledge(req, txId);
    }

    public void addMessage(SpyMessage mes, Tx txId) throws JMSException {
        JMSQueue jMSQueue = this;
        synchronized (jMSQueue) {
            mes.header.messageId = this.messageIdCounter++;
            MessageReference message = this.server.getMessageCache().add(mes);
            this.queue.addMessage(message, txId);
        }
    }

    public SpyMessage receive(Subscription sub, boolean wait) throws JMSException {
        return this.queue.receive(sub, wait);
    }

    public boolean isInUse() {
        return this.queue.isInUse();
    }

    public void close() throws JMSException {
        this.server.getPersistenceManager().closeQueue(this, this.getSpyDestination());
    }

    public void removeAllMessages() throws JMSException {
        this.queue.removeAllMessages();
    }
}

