/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import javax.jms.JMSException;
import javax.management.MBeanRegistration;
import javax.management.ObjectName;
import org.jboss.mq.SpyBytesMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.CacheStore;
import org.jboss.mq.server.MessageCacheMBean;
import org.jboss.mq.server.MessageReference;
import org.jboss.system.ServiceMBeanSupport;

public class MessageCache
extends ServiceMBeanSupport
implements MessageCacheMBean,
MBeanRegistration,
Runnable {
    private LRUCache lruCache = new LRUCache();
    private long messageCounter = 0L;
    int cacheHits = 0;
    int cacheMisses = 0;
    CacheStore cacheStore;
    ObjectName cacheStoreObjectName;
    private Thread referenceSoftner;
    private long highMemoryMark = 0xFA0000L;
    private long maxMemoryMark = 32768000L;
    public static final long ONE_MEGABYTE = 1024000L;
    int softRefCacheSize = 0;
    int totalCacheSize = 0;
    ReferenceQueue referenceQueue = new ReferenceQueue();

    public MessageCache getInstance() {
        return this;
    }

    public MessageReference add(SpyMessage message) throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"add lock aquire");
        }
        MessageReference mh = null;
        MessageCache messageCache = this;
        synchronized (messageCache) {
            mh = new MessageReference();
            mh.init(this, this.messageCounter++, message);
            this.lruCache.addMostRecent(mh);
            ++this.totalCacheSize;
            this.validateSoftReferenceDepth();
            if (trace) {
                this.log.trace((Object)"add lock release");
            }
        }
        return mh;
    }

    public void remove(MessageReference mr) throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"remove lock aquire");
        }
        MessageCache messageCache = this;
        synchronized (messageCache) {
            mr.clear();
            if (mr.hardReference != null) {
                this.lruCache.remove(mr);
            }
            --this.totalCacheSize;
            if (trace) {
                this.log.trace((Object)"remove lock release");
            }
        }
    }

    public void run() {
        try {
            while (true) {
                Reference r;
                if ((r = this.referenceQueue.remove(1000L)) == null) {
                    continue;
                }
                --this.softRefCacheSize;
                while ((r = this.referenceQueue.poll()) != null) {
                    --this.softRefCacheSize;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("soft reference cache size is now: " + this.softRefCacheSize));
                }
                this.validateSoftReferenceDepth();
            }
        }
        catch (JMSException e) {
            this.log.error((Object)"Message Cache Thread Stopped: ", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.debug((Object)"Thread exiting.");
    }

    public void validateSoftReferenceDepth() throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"run lock aquire");
        }
        MessageCache messageCache = this;
        synchronized (messageCache) {
            int chnageCount = 0;
            long currentMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (currentMem > this.highMemoryMark) {
                float severity = (float)(currentMem - this.highMemoryMark) / (float)(this.maxMemoryMark - this.highMemoryMark);
                severity = Math.min(severity, 1.0f);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Memory usage serverity=" + severity));
                }
                int totoalMessageInMem = this.getHardRefCacheSize() + this.getSoftRefCacheSize();
                int howManyShouldBeSoft = (int)((float)totoalMessageInMem * severity);
                chnageCount = howManyShouldBeSoft - this.getSoftRefCacheSize();
            }
            if (chnageCount > 1) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Converting " + chnageCount + " hard ref to to soft refs"));
                }
                Node leastRecent = this.lruCache.getLeastRecent();
                int i = 0;
                while (i < chnageCount && leastRecent != null) {
                    MessageReference mr = (MessageReference)leastRecent.data;
                    mr.makeSoft();
                    this.lruCache.remove(mr);
                    leastRecent = this.lruCache.getLeastRecent();
                    ++i;
                }
            }
            if (trace) {
                this.log.trace((Object)"run lock release");
            }
        }
    }

    void messageReferenceUsedEvent(MessageReference mh, boolean wasHard) {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"messageReferenceUsedEvent lock aquire");
        }
        MessageCache messageCache = this;
        synchronized (messageCache) {
            if (wasHard) {
                this.lruCache.makeMostRecent(mh);
            } else {
                this.lruCache.addMostRecent(mh);
            }
            if (trace) {
                this.log.trace((Object)"messageReferenceUsedEvent lock released");
            }
        }
    }

    SpyMessage loadFromStorage(MessageReference mh) throws JMSException {
        return this.cacheStore.loadFromStorage(mh);
    }

    void saveToStorage(MessageReference mh, SpyMessage message) throws JMSException {
        this.cacheStore.saveToStorage(mh, message);
    }

    void removeFromStorage(MessageReference mh) throws JMSException {
        this.cacheStore.removeFromStorage(mh);
    }

    protected void startService() throws Exception {
        this.cacheStore = (CacheStore)this.getServer().getAttribute(this.cacheStoreObjectName, "Instance");
        if (this.getState() == 3) {
            throw new Exception("Cannot be initialized from the current state");
        }
        this.referenceSoftner = new Thread((Runnable)this, "JBossMQ Cache Reference Softner");
        this.referenceSoftner.setDaemon(true);
        this.referenceSoftner.start();
    }

    public synchronized void stopService() {
        if (this.getState() != 3) {
            return;
        }
        this.referenceSoftner.interrupt();
        this.referenceSoftner = null;
    }

    public int getHardRefCacheSize() {
        MessageCache messageCache = this;
        synchronized (messageCache) {
            int n = this.lruCache.size();
            return n;
        }
    }

    public int getSoftRefCacheSize() {
        return this.softRefCacheSize;
    }

    public int getTotalCacheSize() {
        return this.totalCacheSize;
    }

    public int getCacheMisses() {
        return this.cacheMisses;
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public long getHighMemoryMark() {
        return this.highMemoryMark / 1024000L;
    }

    public void setHighMemoryMark(long highMemoryMark) {
        this.highMemoryMark = highMemoryMark * 1024000L;
    }

    public long getMaxMemoryMark() {
        return this.maxMemoryMark / 1024000L;
    }

    public long getCurrentMemoryUsage() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024000L;
    }

    public void setMaxMemoryMark(long maxMemoryMark) {
        this.maxMemoryMark = maxMemoryMark * 1024000L;
    }

    public String getName() {
        return "MessageCache";
    }

    public void testBigLoad() throws Exception {
        MessageCache cache = new MessageCache();
        File tempDir = new File("Temp-" + System.currentTimeMillis());
        tempDir.mkdirs();
        cache.setHighMemoryMark(40L);
        cache.setMaxMemoryMark(60L);
        cache.start();
        LinkedList<MessageReference> ll = new LinkedList<MessageReference>();
        int TEST_SIZE = 5000;
        Random rand = new Random(System.currentTimeMillis());
        this.log.info((Object)"Adding the messages");
        int i = 0;
        while (i < TEST_SIZE) {
            SpyBytesMessage bm = new SpyBytesMessage();
            bm.writeBytes(new byte[102400]);
            MessageReference mr = cache.add(bm);
            ll.add(mr);
            int pick = rand.nextInt(i + 1);
            mr = (MessageReference)ll.get(pick);
            mr.getMessage();
            ++i;
        }
        this.log.info((Object)("Used Mem=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())));
        this.log.info((Object)("Messages with Hard Refs=" + cache.getHardRefCacheSize()));
        this.log.info((Object)("Messages with Soft Refs=" + cache.getSoftRefCacheSize()));
        this.log.info((Object)"Removing the messages");
        Iterator iter = ll.iterator();
        int i2 = 0;
        while (i2 < TEST_SIZE) {
            MessageReference mr = (MessageReference)iter.next();
            iter.remove();
            cache.remove(mr);
            ++i2;
        }
        this.log.info((Object)"Stopping");
        cache.stop();
        tempDir.delete();
        this.log.info((Object)("Cache Hits=" + cache.getCacheHits()));
        this.log.info((Object)("Cache Misses=" + cache.getCacheMisses()));
    }

    public void setCacheStore(ObjectName cacheStore) {
        this.cacheStoreObjectName = cacheStore;
    }

    class Node {
        Node moreRecent = null;
        Node lessRecent = null;
        Object data = null;

        Node() {
        }
    }

    class LRUCache {
        int currentSize = 0;
        HashMap map = new HashMap();
        Node mostRecent = null;
        Node leastRecent = null;

        LRUCache() {
        }

        public void addMostRecent(Object o) {
            Node newNode = new Node();
            newNode.data = o;
            Node oldNode = this.map.put(o, newNode);
            if (oldNode != null) {
                this.map.put(o, oldNode);
                throw new RuntimeException("Can't add object '" + o + "' to LRUCache that is already in cache.");
            }
            if (this.mostRecent == null) {
                this.mostRecent = newNode;
                this.leastRecent = newNode;
            } else {
                newNode.lessRecent = this.mostRecent;
                this.mostRecent.moreRecent = newNode;
                this.mostRecent = newNode;
            }
            ++this.currentSize;
        }

        public void addLeastRecent(Object o) {
            Node newNode = new Node();
            newNode.data = o;
            Node oldNode = this.map.put(o, newNode);
            if (oldNode != null) {
                this.map.put(o, oldNode);
                throw new RuntimeException("Can't add object '" + o + "' to LRUCache that is already in cache.");
            }
            if (this.leastRecent == null) {
                this.mostRecent = newNode;
                this.leastRecent = newNode;
            } else {
                newNode.moreRecent = this.leastRecent;
                this.leastRecent.lessRecent = newNode;
                this.leastRecent = newNode;
            }
            ++this.currentSize;
        }

        public void remove(Object o) {
            Node node = (Node)this.map.remove(o);
            if (node == null) {
                throw new RuntimeException("Can't remove object '" + o + "' that is not in cache.");
            }
            Node more = node.moreRecent;
            Node less = node.lessRecent;
            if (more == null) {
                this.mostRecent = less;
                if (this.mostRecent != null) {
                    this.mostRecent.moreRecent = null;
                }
            } else {
                more.lessRecent = less;
            }
            if (less == null) {
                this.leastRecent = more;
                if (this.leastRecent != null) {
                    this.leastRecent.lessRecent = null;
                }
            } else {
                less.moreRecent = more;
            }
            --this.currentSize;
        }

        public void makeMostRecent(Object o) {
            Node node = (Node)this.map.get(o);
            if (node == null) {
                throw new RuntimeException("Can't make most recent object '" + o + "' that is not in cache.");
            }
            Node more = node.moreRecent;
            Node less = node.lessRecent;
            if (more == null) {
                return;
            }
            more.lessRecent = less;
            if (less == null) {
                this.leastRecent = more;
            } else {
                less.moreRecent = more;
            }
            node.lessRecent = this.mostRecent;
            node.moreRecent = null;
            this.mostRecent.moreRecent = node;
            this.mostRecent = node;
        }

        public int size() {
            return this.currentSize;
        }

        public Node getMostRecent() {
            return this.mostRecent;
        }

        public Node getLeastRecent() {
            return this.leastRecent;
        }
    }
}

