/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.mq.pm.PersistenceManager;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSServerInterceptor;
import org.jboss.mq.server.jmx.DestinationManagerMBean;
import org.jboss.mq.server.jmx.InterceptorMBeanSupport;
import org.jboss.mq.sm.StateManager;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.util.jmx.MBeanProxy;

public class DestinationManager
extends InterceptorMBeanSupport
implements DestinationManagerMBean {
    public String jndiBindLocation = "java:/JBossMQServer";
    private ServiceControllerMBean serviceController;
    private ObjectName mqService;
    private JMSDestinationManager jmsServer;
    private ObjectName persistenceManager;
    private ObjectName stateManager;
    private ObjectName mManagementProxy;
    static /* synthetic */ Class class$org$jboss$system$ServiceControllerMBean;

    public ObjectName getPersistenceManager() {
        return this.persistenceManager;
    }

    public void setPersistenceManager(ObjectName objectName) {
        this.persistenceManager = objectName;
    }

    public ObjectName getStateManager() {
        return this.stateManager;
    }

    public void setStateManager(ObjectName objectName) {
        this.stateManager = objectName;
    }

    public void createQueue(String name) throws Exception {
        this.createDestination("org.jboss.mq.server.jmx.Queue", this.getQueueObjectName(name), null);
    }

    public void createTopic(String name) throws Exception {
        this.createDestination("org.jboss.mq.server.jmx.Topic", this.getTopicObjectName(name), null);
    }

    public void createQueue(String name, String jndiLocation) throws Exception {
        this.createDestination("org.jboss.mq.server.jmx.Queue", this.getQueueObjectName(name), jndiLocation);
    }

    public void createTopic(String name, String jndiLocation) throws Exception {
        this.createDestination("org.jboss.mq.server.jmx.Topic", this.getTopicObjectName(name), jndiLocation);
    }

    protected void createDestination(String type, ObjectName name, String jndiLocation) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to create destination: " + name + "; type=" + type));
        }
        this.server.createMBean(type, name);
        this.server.setAttribute(name, new Attribute("DestinationManager", this.mqService));
        if (jndiLocation != null) {
            this.server.setAttribute(name, new Attribute("JNDIName", jndiLocation));
        }
        ArrayList<ObjectName> depends = new ArrayList<ObjectName>();
        depends.add(this.serviceName);
        this.serviceController.create(name, depends);
        this.serviceController.start(name);
    }

    public void destroyQueue(String name) throws Exception {
        this.destroyDestination(this.getQueueObjectName(name));
    }

    public void destroyTopic(String name) throws Exception {
        this.destroyDestination(this.getTopicObjectName(name));
    }

    protected void destroyDestination(ObjectName name) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to destroy destination: " + name));
        }
        this.serviceController.stop(name);
        this.server.invoke(name, "removeAllMessages", new Object[0], new String[0]);
        this.serviceController.destroy(name);
        this.serviceController.remove(name);
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.mqService = name;
        return this.mqService;
    }

    protected void stopService() {
        this.jmsServer.stopServer();
    }

    private ObjectName getTopicObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(this.mqService.getDomain() + ".destination:service=Topic,name=" + name);
    }

    private ObjectName getQueueObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(this.mqService.getDomain() + ".destination:service=Queue,name=" + name);
    }

    public JMSServerInterceptor getInterceptor() {
        return this.jmsServer;
    }

    protected void createService() throws Exception {
        super.createService();
        this.jmsServer = new JMSDestinationManager();
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxy.create((Class)(class$org$jboss$system$ServiceControllerMBean == null ? (class$org$jboss$system$ServiceControllerMBean = DestinationManager.class$("org.jboss.system.ServiceControllerMBean")) : class$org$jboss$system$ServiceControllerMBean), (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        PersistenceManager pm = (PersistenceManager)this.server.getAttribute(this.persistenceManager, "Instance");
        this.jmsServer.setPersistenceManager(pm);
        StateManager sm = (StateManager)this.server.getAttribute(this.stateManager, "Instance");
        this.jmsServer.setStateManager(sm);
        this.jmsServer.startServer();
        super.startService();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

