/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.sm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.sm.AbstractStateManagerMBean;
import org.jboss.mq.sm.StateManager;
import org.jboss.system.ServiceMBeanSupport;

public abstract class AbstractStateManager
extends ServiceMBeanSupport
implements StateManager,
AbstractStateManagerMBean {
    private final Set loggedOnClientIds = new HashSet();

    public void setDurableSubscription(JMSDestinationManager server, DurableSubscriptionID sub, SpyTopic topic) throws JMSException {
        DurableSubscription subscription;
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("Checking durable subscription: " + sub + ", on topic: " + topic));
        }
        if ((subscription = this.getDurableSubscription(sub)) == null) {
            if (debug) {
                this.log.debug((Object)"The subscription was not previously registered.");
            }
            if (topic == null) {
                return;
            }
            JMSTopic dest = (JMSTopic)server.getJMSDestination(topic);
            dest.createDurableSubscription(sub);
            subscription = new DurableSubscription(sub.getClientID(), sub.getSubscriptionName(), topic.getName(), sub.getSelector());
            this.saveDurableSubscription(subscription);
        } else {
            if (debug) {
                this.log.debug((Object)"The subscription was previously registered.");
            }
            String newSelector = sub.getSelector();
            String oldSelector = subscription.getSelector();
            boolean selectorChanged = false;
            if (newSelector == null && oldSelector != null || newSelector != null && !newSelector.equals(oldSelector)) {
                selectorChanged = true;
            }
            if (topic == null) {
                if (debug) {
                    this.log.debug((Object)"Removing subscription.");
                }
                SpyTopic prevTopic = new SpyTopic(subscription.getTopic());
                JMSTopic dest = (JMSTopic)server.getJMSDestination(prevTopic);
                dest.destroyDurableSubscription(sub);
                this.removeDurableSubscription(subscription);
            } else if (!subscription.getTopic().equals(topic.getName()) || selectorChanged) {
                if (debug) {
                    this.log.debug((Object)"But the topic or selector was different, changing the subscription.");
                }
                SpyTopic prevTopic = new SpyTopic(subscription.getTopic());
                JMSTopic dest = (JMSTopic)server.getJMSDestination(prevTopic);
                dest.destroyDurableSubscription(sub);
                dest = (JMSTopic)server.getJMSDestination(topic);
                dest.createDurableSubscription(sub);
                subscription.setTopic(topic.getName());
                subscription.setSelector(sub.getSelector());
                this.saveDurableSubscription(subscription);
            }
        }
    }

    public SpyTopic getDurableTopic(DurableSubscriptionID sub) throws JMSException {
        DurableSubscription subscription = this.getDurableSubscription(sub);
        if (subscription == null) {
            throw new JMSException("No durable subscription found for subscription: " + sub.getSubscriptionName());
        }
        return new SpyTopic(subscription.getTopic());
    }

    public String checkUser(String login, String passwd) throws JMSException {
        String clientId = this.getPreconfClientId(login, passwd);
        if (clientId != null) {
            Set set = this.loggedOnClientIds;
            synchronized (set) {
                if (this.loggedOnClientIds.contains(clientId)) {
                    throw new JMSSecurityException("The login id has an assigned client id. That client id is already connected to the server!");
                }
                this.loggedOnClientIds.add(clientId);
            }
        }
        return clientId;
    }

    public void addLoggedOnClientId(String ID) throws JMSException {
        Set set = this.loggedOnClientIds;
        synchronized (set) {
            if (this.loggedOnClientIds.contains(ID)) {
                throw new InvalidClientIDException("This loggedOnClientIds is already registered !");
            }
        }
        this.checkLoggedOnClientId(ID);
        Set set2 = this.loggedOnClientIds;
        synchronized (set2) {
            this.loggedOnClientIds.add(ID);
        }
    }

    public void removeLoggedOnClientId(String ID) {
        Set set = this.loggedOnClientIds;
        synchronized (set) {
            this.loggedOnClientIds.remove(ID);
        }
    }

    public abstract Collection getDurableSubscriptionIdsForTopic(SpyTopic var1) throws JMSException;

    protected abstract String getPreconfClientId(String var1, String var2) throws JMSException;

    protected abstract void checkLoggedOnClientId(String var1) throws JMSException;

    protected abstract DurableSubscription getDurableSubscription(DurableSubscriptionID var1) throws JMSException;

    protected abstract void saveDurableSubscription(DurableSubscription var1) throws JMSException;

    protected abstract void removeDurableSubscription(DurableSubscription var1) throws JMSException;

    public abstract StateManager getInstance();

    protected class DurableSubscription {
        String clientID;
        String name;
        String topic;
        String selector;

        public DurableSubscription() {
        }

        public DurableSubscription(String clientID, String name, String topic, String selector) {
            this.clientID = clientID;
            this.name = name;
            this.topic = topic;
            this.selector = selector;
        }

        public String getClientID() {
            return this.clientID;
        }

        public String getName() {
            return this.name;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public String getSelector() {
            return this.selector;
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }
    }
}

