/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.InitialContext;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.StatefulSessionPersistenceManager;
import org.jboss.ejb.plugins.HAPersistentManager;
import org.jboss.ejb.plugins.SessionObjectInputStream;
import org.jboss.ejb.plugins.SessionObjectOutputStream;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.hasessionstate.interfaces.HASessionState;
import org.jboss.ha.hasessionstate.interfaces.PackagedSession;
import org.jboss.metadata.ClusterConfigMetaData;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.id.UID;

public class StatefulHASessionPersistenceManager
extends ServiceMBeanSupport
implements StatefulSessionPersistenceManager,
HASessionState.HASessionStateListener,
HAPersistentManager {
    private StatefulSessionContainer con;
    private HASessionState sessionState = null;
    private String localNodeName = null;
    private String appName = null;
    private static String DEFAULT_HASESSIONSTATE_JNDI_NAME = "/HASessionState/Default";

    public void setContainer(Container c) {
        this.con = (StatefulSessionContainer)c;
    }

    protected void createService() throws Exception {
        String sessionStateName = "/HASessionState/Default";
        ClusterConfigMetaData config = this.con.getBeanMetaData().getClusterConfigMetaData();
        if (config != null) {
            sessionStateName = config.getHaSessionStateName();
        }
        InitialContext ctx = new InitialContext();
        try {
            this.sessionState = (HASessionState)ctx.lookup(sessionStateName);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
        this.localNodeName = this.sessionState.getNodeName();
        this.appName = this.con.getBeanMetaData().getJndiName();
        this.sessionState.subscribe(this.appName, (HASessionState.HASessionStateListener)this);
    }

    protected void stopService() {
        this.sessionState.unsubscribe(this.appName, (HASessionState.HASessionStateListener)this);
    }

    public void createSession(Method m, Object[] args, StatefulSessionEnterpriseContext ctx) throws Exception {
        ctx.setId((Object)this.nextId());
        try {
            Method createMethod = this.con.getBeanClass().getMethod("ejbCreate", m.getParameterTypes());
            createMethod.invoke(ctx.getInstance(), args);
            this.sessionState.createSession(this.appName, ctx.getId());
        }
        catch (IllegalAccessException e) {
            ctx.setId(null);
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            ctx.setId(null);
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        }
        this.con.getInstanceCache().insert((EnterpriseContext)ctx);
        if (this.con.getContainerInvoker() != null) {
            ctx.setEJBObject((EJBObject)this.con.getContainerInvoker().getStatefulSessionEJBObject(ctx.getId()));
        }
        if (this.con.getLocalHomeClass() != null) {
            ctx.setEJBLocalObject(this.con.getLocalContainerInvoker().getStatefulSessionEJBLocalObject(ctx.getId()));
        }
    }

    public void activateSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
        try {
            PackagedSession state = this.sessionState.getStateWithOwnership(this.appName, ctx.getId());
            if (state == null) {
                throw new EJBException("Could not activate; failed to recover session (session has been probably removed by session-timeout)");
            }
            SessionObjectInputStream in = new SessionObjectInputStream(ctx, (InputStream)new ByteArrayInputStream(state.getState()));
            ctx.setInstance(in.readObject());
            in.close();
            this.removePassivated(ctx.getId());
            ((SessionBean)ctx.getInstance()).ejbActivate();
        }
        catch (ClassNotFoundException e) {
            throw new EJBException("Could not activate", (Exception)e);
        }
        catch (IOException e) {
            throw new EJBException("Could not activate", (Exception)e);
        }
    }

    public void passivateSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
    }

    public void synchroSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
        try {
            ((SessionBean)ctx.getInstance()).ejbPassivate();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SessionObjectOutputStream out = new SessionObjectOutputStream((OutputStream)baos);
            out.writeObject(ctx.getInstance());
            out.close();
            this.sessionState.setState(this.appName, ctx.getId(), baos.toByteArray());
            ((SessionBean)ctx.getInstance()).ejbActivate();
        }
        catch (IOException e) {
            throw new EJBException("Could not passivate", (Exception)e);
        }
    }

    public void removeSession(StatefulSessionEnterpriseContext ctx) throws RemoteException, RemoveException {
        try {
            ((SessionBean)ctx.getInstance()).ejbRemove();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.sessionState.removeSession(this.appName, ctx.getId());
            throw throwable;
        }
        this.sessionState.removeSession(this.appName, ctx.getId());
    }

    public void removePassivated(Object key) {
        this.sessionState.removeSession(this.appName, key);
    }

    protected String nextId() {
        return this.localNodeName + ":" + new UID();
    }

    public void sessionExternallyModified(PackagedSession session) {
        this.log.trace((Object)("Invalidating cache for session: " + session.getKey()));
        this.con.getInstanceCache().remove((Object)session.getKey());
    }

    public void newSessionStateTopology(HAPartition haSubPartition) {
    }
}

