/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.ha;

import java.util.Properties;
import javax.naming.InitialContext;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HARMIServerImpl;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.ha.HAServerIL;
import org.jboss.mq.il.ha.HAServerILServiceMBean;

public class HAServerILService
extends ServerILJMXService
implements HAServerILServiceMBean {
    public static final String DEFAULT_PARTITION = "DefaultPartition";
    protected ServerIL serverILProxy;
    protected HAServerIL serverIL;
    protected HAPartition partition;
    protected HARMIServerImpl harmi;
    protected String partitionName = "DefaultPartition";
    protected String loadBalancePolicy = "org.jboss.ha.framework.interfaces.FirstAvailable";
    protected Class loadBalancePolicyClass;
    static /* synthetic */ Class class$org$jboss$mq$il$ServerIL;

    public String getName() {
        return "JBossMQ-HAServerIL";
    }

    public ServerIL getServerIL() {
        return this.serverILProxy;
    }

    public Properties getClientConnectionProperties() {
        Properties rc = super.getClientConnectionProperties();
        rc.setProperty("ClientILService", "org.jboss.mq.il.ha.HAClientILService");
        return rc;
    }

    public void startService() throws Exception {
        super.startService();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.log.info((Object)("Using " + this.loadBalancePolicy + " for jms connection load balancing"));
        this.loadBalancePolicyClass = cl.loadClass(this.loadBalancePolicy);
        this.serverIL = new HAServerIL(this.lookupJMSServer());
        this.partition = (HAPartition)new InitialContext().lookup("/HAPartition/" + this.partitionName);
        this.harmi = new HARMIServerImpl(this.partition, this.getConnectionFactoryJNDIRef(), class$org$jboss$mq$il$ServerIL == null ? (class$org$jboss$mq$il$ServerIL = HAServerILService.class$("org.jboss.mq.il.ServerIL")) : class$org$jboss$mq$il$ServerIL, (Object)this.serverIL);
        this.serverILProxy = (ServerIL)this.harmi.createHAStub((LoadBalancePolicy)this.loadBalancePolicyClass.newInstance());
        this.serverIL.setHaServerILProxy(this.serverILProxy);
        this.bindJNDIReferences();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HAServerILProxy=" + this.serverILProxy));
        }
    }

    public void stopService() {
        try {
            this.unbindJNDIReferences();
            this.harmi.destroy();
            super.stopService();
        }
        catch (Exception ex) {
            this.log.error((Object)"Error stopping HAServerIL", (Throwable)ex);
            throw new RuntimeException("Error stopping HAServerIL");
        }
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public String getLoadBalancePolicy() {
        return this.loadBalancePolicy;
    }

    public void setLoadBalancePolicy(String loadBalancePolicy) {
        this.loadBalancePolicy = loadBalancePolicy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

