/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.XMLLoginConfigMBean;
import org.jboss.system.ServiceMBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLLoginConfig
extends Configuration
implements XMLLoginConfigMBean {
    private static final String DEFAULT_APP_CONFIG_NAME = "other";
    private static final AuthPermission REFRESH_PERM = new AuthPermission("refreshPolicy");
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$auth$login$XMLLoginConfig == null ? (class$org$jboss$security$auth$login$XMLLoginConfig = XMLLoginConfig.class$("org.jboss.security.auth.login.XMLLoginConfig")) : class$org$jboss$security$auth$login$XMLLoginConfig));
    private HashMap appConfigs = new HashMap();
    private int state = 0;
    private URL xmlConfig;
    private Configuration parentConfig;
    private boolean validateDTD = true;
    static /* synthetic */ Class class$org$jboss$security$auth$login$XMLLoginConfig;

    public void refresh() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        AppConfigurationEntry[] entry = null;
        AuthenticationInfo authInfo = (AuthenticationInfo)this.appConfigs.get(appName);
        if (authInfo != null) {
            entry = authInfo.copyAppConfigurationEntry();
        } else {
            if (this.parentConfig != null) {
                entry = this.parentConfig.getAppConfigurationEntry(appName);
            }
            if (entry == null) {
                authInfo = (AuthenticationInfo)this.appConfigs.get(DEFAULT_APP_CONFIG_NAME);
            }
            if (authInfo != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("getAppConfigurationEntry, authInfo=" + authInfo));
                }
                entry = authInfo.copyAppConfigurationEntry();
            }
        }
        return entry;
    }

    public URL getConfigURL() {
        return this.xmlConfig;
    }

    public void setConfigURL(URL xmlConfig) {
        this.xmlConfig = xmlConfig;
    }

    public void setConfigResource(String resourceName) throws IOException {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        this.xmlConfig = tcl.getResource(resourceName);
        if (this.xmlConfig == null) {
            throw new IOException("Failed to find resource: " + resourceName);
        }
    }

    public boolean getValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateDTD(boolean flag) {
        this.validateDTD = flag;
    }

    public Configuration getConfiguration(Configuration prevConfig) {
        this.parentConfig = prevConfig;
        return this;
    }

    public void addAppConfig(String appName, AppConfigurationEntry[] entries) {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setAppConfigurationEntry(entries);
        this.appConfigs.put(appName, authInfo);
    }

    public void removeAppConfig(String appName) {
        this.appConfigs.remove(appName);
    }

    public String displayAppConfig(String appName) {
        StringBuffer buffer = new StringBuffer("<h2>" + appName + " LoginConfiguration</h2>\n");
        AppConfigurationEntry[] config = this.getAppConfigurationEntry(appName);
        if (config == null) {
            buffer.append("No Entry\n");
        } else {
            int c = 0;
            while (c < config.length) {
                AppConfigurationEntry entry = config[c];
                buffer.append("LoginModule Class: " + entry.getLoginModuleName());
                buffer.append("\n<br>ControlFlag: " + entry.getControlFlag());
                buffer.append("\n<br>Options:<ul>");
                Map<String, ?> options = entry.getOptions();
                Iterator<Map.Entry<String, ?>> iter = options.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, ?> e = iter.next();
                    buffer.append("<li>");
                    buffer.append("name=" + e.getKey());
                    buffer.append(", value=" + e.getValue());
                    buffer.append("</li>\n");
                }
                buffer.append("</ul>\n");
                ++c;
            }
        }
        return buffer.toString();
    }

    public void create() throws Exception {
    }

    public String getName() {
        return "XMLLoginConfig";
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return ServiceMBean.states[this.state];
    }

    public void start() throws Exception {
        if (this.getState() != 0 && this.getState() != 4) {
            return;
        }
        this.state = 2;
        this.loadConfig(this.xmlConfig);
        this.state = 3;
    }

    public void stop() {
        this.state = 1;
        this.state = 0;
    }

    public void destroy() {
        this.appConfigs.clear();
    }

    private void loadConfig(URL xmlConfig) throws Exception {
        log.debug((Object)("Loading xmlConfig=" + xmlConfig));
        Document doc = this.loadURL(xmlConfig);
        Element root = doc.getDocumentElement();
        NodeList apps = root.getElementsByTagName("application-policy");
        int n = 0;
        while (n < apps.getLength()) {
            Element appPolicy = (Element)apps.item(n);
            String appName = appPolicy.getAttribute("name");
            log.trace((Object)("Parsing application-policy=" + appName));
            try {
                AuthenticationInfo authInfo = this.parseAuthentication(appPolicy);
                if (authInfo != null) {
                    this.appConfigs.put(appName, authInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n;
        }
    }

    private Document loadURL(URL xmlConfig) throws Exception {
        InputStream is = xmlConfig.openStream();
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + xmlConfig);
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(this.validateDTD);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        LocalResolver resolver = new LocalResolver(log);
        docBuilder.setEntityResolver(resolver);
        Document doc = docBuilder.parse(is);
        return doc;
    }

    private AuthenticationInfo parseAuthentication(Element policy) throws Exception {
        NodeList authentication = policy.getElementsByTagName("authentication");
        if (authentication.getLength() == 0) {
            return null;
        }
        Element auth = (Element)authentication.item(0);
        NodeList modules = auth.getElementsByTagName("login-module");
        ArrayList tmp = new ArrayList();
        int n = 0;
        while (n < modules.getLength()) {
            Element module = (Element)modules.item(n);
            this.parseModule(module, tmp);
            ++n;
        }
        AppConfigurationEntry[] entries = new AppConfigurationEntry[tmp.size()];
        tmp.toArray(entries);
        AuthenticationInfo info = new AuthenticationInfo();
        info.setAppConfigurationEntry(entries);
        return info;
    }

    private void parseModule(Element module, ArrayList entries) throws Exception {
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        String className = module.getAttribute("code");
        String flag = module.getAttribute("flag");
        if (flag != null) {
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
        }
        NodeList opts = module.getElementsByTagName("module-option");
        HashMap<String, String> options = new HashMap<String, String>();
        int n = 0;
        while (n < opts.getLength()) {
            Element opt = (Element)opts.item(n);
            String name = opt.getAttribute("name");
            String value = XMLLoginConfig.getContent(opt, "");
            options.put(name, value);
            ++n;
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(className, controlFlag, options);
        entries.add(entry);
    }

    private static String getContent(Element element, String defaultContent) {
        NodeList children = element.getChildNodes();
        String content = defaultContent;
        if (children.getLength() > 0) {
            content = "";
            int n = 0;
            while (n < children.getLength()) {
                content = children.item(n).getNodeType() == 3 || children.item(n).getNodeType() == 4 ? content + children.item(n).getNodeValue() : content + children.item(n).getFirstChild();
                ++n;
            }
            return content.trim();
        }
        return content;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalResolver
    implements EntityResolver {
        private static final String LOGIN_CIONFIG_PUBLIC_ID = "-//JBoss//DTD JBOSS Security Config 3.0//EN";
        private static final String LOGIN_CIONFIG_DTD_NAME = "/org/jboss/metadata/security_config.dtd";
        private Logger log;

        LocalResolver(Logger log) {
            this.log = log;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            InputSource is = null;
            if (publicId.equals(LOGIN_CIONFIG_PUBLIC_ID)) {
                try {
                    InputStream dtdStream = this.getClass().getResourceAsStream(LOGIN_CIONFIG_DTD_NAME);
                    is = new InputSource(dtdStream);
                }
                catch (Exception ex) {
                    this.log.warn((Object)("Failed to resolve DTD publicId: " + publicId));
                }
            }
            return is;
        }
    }
}

