/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class LdapLoginModule
extends UsernamePasswordLoginModule {
    private static final String USE_OBJECT_CREDENTIAL_OPT = "useObjectCredential";
    private static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
    private static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT = "userRolesCtxDNAttributeName";
    private static final String UID_ATTRIBUTE_ID_OPT = "uidAttributeID";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String MATCH_ON_USER_DN_OPT = "matchOnUserDN";
    private transient SimpleGroup userRoles = new SimpleGroup("Roles");

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] roleSets = new Group[]{this.userRoles};
        return roleSets;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid = false;
        if (inputPassword != null) {
            if (inputPassword.length() == 0) {
                boolean allowEmptyPasswords = true;
                String flag = (String)this.options.get("allowEmptyPasswords");
                if (flag != null) {
                    allowEmptyPasswords = Boolean.valueOf(flag);
                }
                if (!allowEmptyPasswords) {
                    this.log.trace((Object)"Rejecting empty password due to allowEmptyPasswords");
                    return false;
                }
            }
            try {
                String username = this.getUsername();
                this.createLdapInitContext(username, inputPassword);
                isValid = true;
            }
            catch (NamingException e) {
                this.log.error((Object)"Failed to validate password", (Throwable)e);
            }
        }
        return isValid;
    }

    private void createLdapInitContext(String username, Object credential) throws NamingException {
        String principalDNSuffix;
        String principalDNPrefix;
        String authType;
        Properties env = new Properties();
        Iterator iter = this.options.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            env.put(entry.getKey(), entry.getValue());
        }
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = (String)this.options.get("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "389" : "636");
        }
        if ((principalDNPrefix = (String)this.options.get(PRINCIPAL_DN_PREFIX_OPT)) == null) {
            principalDNPrefix = "";
        }
        if ((principalDNSuffix = (String)this.options.get(PRINCIPAL_DN_SUFFIX_OPT)) == null) {
            principalDNSuffix = "";
        }
        String matchType = (String)this.options.get(MATCH_ON_USER_DN_OPT);
        boolean matchOnUserDN = Boolean.valueOf(matchType);
        String userDN = principalDNPrefix + username + principalDNSuffix;
        env.setProperty("java.naming.provider.url", providerURL);
        env.setProperty("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", credential);
        this.log.trace((Object)("Logging into LDAP server, env=" + env));
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        this.log.trace((Object)("Logged into LDAP server, " + ctx));
        String rolesCtxDN = (String)this.options.get(ROLES_CTX_DN_OPT);
        String userRolesCtxDNAttributeName = (String)this.options.get(USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT);
        if (userRolesCtxDNAttributeName != null) {
            String[] returnAttribute = new String[]{userRolesCtxDNAttributeName};
            try {
                Attributes result = ctx.getAttributes(userDN, returnAttribute);
                if (result.get(userRolesCtxDNAttributeName) != null) {
                    rolesCtxDN = result.get(userRolesCtxDNAttributeName).get().toString();
                    this.log.trace((Object)("Found user roles context DN: " + rolesCtxDN));
                }
            }
            catch (NamingException e) {
                this.log.debug((Object)"Failed to query userRolesCtxDNAttributeName", (Throwable)e);
            }
        }
        if (rolesCtxDN != null) {
            String roleAttrName;
            String uidAttrName = (String)this.options.get(UID_ATTRIBUTE_ID_OPT);
            if (uidAttrName == null) {
                uidAttrName = "uid";
            }
            if ((roleAttrName = (String)this.options.get(ROLE_ATTRIBUTE_ID_OPT)) == null) {
                roleAttrName = "roles";
            }
            BasicAttributes matchAttrs = new BasicAttributes(true);
            if (matchOnUserDN) {
                matchAttrs.put(uidAttrName, userDN);
            } else {
                matchAttrs.put(uidAttrName, username);
            }
            String[] roleAttr = new String[]{roleAttrName};
            try {
                NamingEnumeration<SearchResult> answer = ctx.search(rolesCtxDN, (Attributes)matchAttrs, roleAttr);
                while (answer.hasMore()) {
                    SearchResult sr = answer.next();
                    Attributes attrs = sr.getAttributes();
                    Attribute roles = attrs.get(roleAttrName);
                    int r = 0;
                    while (r < roles.size()) {
                        Object value = roles.get(r);
                        String roleName = value.toString();
                        this.userRoles.addMember(new SimplePrincipal(roleName));
                        ++r;
                    }
                }
            }
            catch (NamingException e) {
                this.log.trace((Object)"Failed to locate roles", (Throwable)e);
            }
        }
        ctx.close();
    }
}

