/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.srp.SRPParameters;
import org.jboss.security.srp.SRPRemoteServerInterface;
import org.jboss.security.srp.SRPServerListener;
import org.jboss.security.srp.SRPServerSession;
import org.jboss.security.srp.SRPSessionKey;
import org.jboss.security.srp.SRPVerifierStore;

public class SRPRemoteServer
extends UnicastRemoteObject
implements SRPRemoteServerInterface {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$srp$SRPRemoteServer == null ? (class$org$jboss$security$srp$SRPRemoteServer = SRPRemoteServer.class$("org.jboss.security.srp.SRPRemoteServer")) : class$org$jboss$security$srp$SRPRemoteServer));
    private static int userSessionCount = 0;
    private Map sessionMap = Collections.synchronizedMap(new HashMap());
    private SRPVerifierStore verifierStore;
    private SRPServerListener listener;
    private boolean requireAuxChallenge;
    static /* synthetic */ Class class$org$jboss$security$srp$SRPRemoteServer;

    public SRPRemoteServer(SRPVerifierStore verifierStore) throws RemoteException {
        this.setVerifierStore(verifierStore);
    }

    public SRPRemoteServer(SRPVerifierStore verifierStore, int port) throws RemoteException {
        super(port);
        this.setVerifierStore(verifierStore);
    }

    public SRPRemoteServer(SRPVerifierStore verifierStore, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this.setVerifierStore(verifierStore);
    }

    public void setVerifierStore(SRPVerifierStore verifierStore) {
        this.verifierStore = verifierStore;
        log.info((Object)("setVerifierStore, " + verifierStore));
    }

    public void addSRPServerListener(SRPServerListener listener) {
        this.listener = listener;
    }

    public void removeSRPServerListener(SRPServerListener listener) {
        if (this.listener == listener) {
            this.listener = null;
        }
    }

    public boolean getRequireAuxChallenge() {
        return this.requireAuxChallenge;
    }

    public void setRequireAuxChallenge(boolean flag) {
        this.requireAuxChallenge = flag;
    }

    public SRPParameters getSRPParameters(String username) throws KeyException, RemoteException {
        Object[] params = this.getSRPParameters(username, false);
        SRPParameters srpParams = (SRPParameters)params[0];
        return srpParams;
    }

    public Object[] getSRPParameters(String username, boolean multipleSessions) throws KeyException, RemoteException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("getSRPParameters, " + username));
        }
        SRPParameters params = null;
        SRPVerifierStore.VerifierInfo info = null;
        try {
            info = this.verifierStore.getUserVerifier(username);
            if (info == null) {
                throw new KeyException("Unknown username: " + username);
            }
            params = new SRPParameters(info.N, info.g, info.salt);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Params: " + params));
                byte[] hn = Util.newDigest().digest(params.N);
                log.trace((Object)("H(N): " + Util.tob64(hn)));
                byte[] hg = Util.newDigest().digest(params.g);
                log.trace((Object)("H(g): " + Util.tob64(hg)));
            }
            if (params.cipherAlgorithm != null) {
                Cipher cipher = Cipher.getInstance(params.cipherAlgorithm);
                int size = cipher.getBlockSize();
                params.cipherIV = new byte[size];
                Util.nextBytes(params.cipherIV);
            }
        }
        catch (IOException e) {
            throw new RemoteException("Error during user info retrieval", e);
        }
        catch (KeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new RemoteException("Failed to init cipherIV", e);
        }
        catch (Throwable t) {
            log.error((Object)"Unexpected exception in getSRPParameters", t);
            throw new RemoteException("Unexpected exception in getSRPParameters", t);
        }
        Integer sessionID = SRPSessionKey.NO_SESSION_ID;
        if (multipleSessions) {
            sessionID = SRPRemoteServer.nextSessionID();
        }
        Object[] sessionInfo = new Object[]{params, sessionID};
        SRPSessionKey key = new SRPSessionKey(username, sessionID);
        SRPServerSession session = new SRPServerSession(username, info.verifier, params);
        this.sessionMap.put(key, session);
        if (trace) {
            log.trace((Object)("getSRPParameters, completed " + key));
        }
        return sessionInfo;
    }

    public byte[] init(String username, byte[] A) throws SecurityException, NoSuchAlgorithmException, RemoteException {
        return this.init(username, A, 0);
    }

    public byte[] init(String username, byte[] A, int sessionID) throws SecurityException, NoSuchAlgorithmException, RemoteException {
        SRPServerSession session;
        SRPSessionKey key = new SRPSessionKey(username, sessionID);
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("init, " + key));
        }
        if ((session = (SRPServerSession)this.sessionMap.get(key)) == null) {
            throw new SecurityException("Failed to find active session for username: " + username);
        }
        byte[] B = session.exponential();
        session.buildSessionKey(A);
        if (trace) {
            log.trace((Object)("init, completed " + key));
        }
        return B;
    }

    public byte[] verify(String username, byte[] M1) throws SecurityException, RemoteException {
        return this.verify(username, M1, null, 0);
    }

    public byte[] verify(String username, byte[] M1, int sessionID) throws SecurityException, RemoteException {
        return this.verify(username, M1, null, sessionID);
    }

    public byte[] verify(String username, byte[] M1, Object auxChallenge) throws SecurityException, RemoteException {
        return this.verify(username, M1, auxChallenge, 0);
    }

    public byte[] verify(String username, byte[] M1, Object auxChallenge, int sessionID) throws SecurityException, RemoteException {
        SRPServerSession session;
        SRPSessionKey key = new SRPSessionKey(username, sessionID);
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("verify, " + key));
        }
        if ((session = (SRPServerSession)this.sessionMap.get(key)) == null) {
            throw new SecurityException("Failed to find active session for username: " + username);
        }
        if (!session.verify(M1)) {
            throw new SecurityException("Failed to verify M1");
        }
        if (auxChallenge != null) {
            if (auxChallenge instanceof SealedObject) {
                if (trace) {
                    log.trace((Object)"Decrypting sealed object");
                }
                SRPParameters params = session.getParameters();
                Object challenge = null;
                try {
                    challenge = Util.accessSealedObject(params.cipherAlgorithm, session.getSessionKey(), params.cipherIV, auxChallenge);
                }
                catch (GeneralSecurityException e) {
                    throw new RemoteException("Failed to access SealedObject", e);
                }
                auxChallenge = challenge;
            }
            if (trace) {
                log.trace((Object)"Verifing aux challenge");
            }
            this.verifierStore.verifyUserChallenge(username, auxChallenge);
        } else if (this.requireAuxChallenge) {
            throw new RemoteException("A non-null auxChallenge is required for verification");
        }
        if (this.listener != null) {
            this.listener.verifiedUser(key, session);
        }
        if (trace) {
            log.trace((Object)("verify, completed " + key));
        }
        return session.getServerResponse();
    }

    public void close(String username) throws SecurityException, RemoteException {
        this.close(username, 0);
    }

    public void close(String username, int sessionID) throws SecurityException, RemoteException {
        SRPServerSession session;
        SRPSessionKey key = new SRPSessionKey(username, sessionID);
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("close, " + key));
        }
        if ((session = (SRPServerSession)this.sessionMap.get(key)) == null) {
            throw new SecurityException("Failed to find active session for username: " + username);
        }
        if (this.listener != null) {
            this.listener.closedUserSession(key);
        }
        if (trace) {
            log.trace((Object)("close, completed " + key));
        }
    }

    private static synchronized Integer nextSessionID() {
        return new Integer(userSessionCount++);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

