/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.srp.SRPConf;
import org.jboss.security.srp.SRPVerifierStore;

public class SerialObjectStore
implements SRPVerifierStore {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$srp$SerialObjectStore == null ? (class$org$jboss$security$srp$SerialObjectStore = SerialObjectStore.class$("org.jboss.security.srp.SerialObjectStore")) : class$org$jboss$security$srp$SerialObjectStore));
    private Map infoMap;
    private BigInteger g;
    private BigInteger N;
    static /* synthetic */ Class class$org$jboss$security$srp$SerialObjectStore;

    public SerialObjectStore() throws IOException {
        this(null);
    }

    public SerialObjectStore(File storeFile) throws IOException {
        if (storeFile == null) {
            storeFile = new File("SerialObjectStore.ser");
        }
        if (storeFile.exists()) {
            FileInputStream fis = new FileInputStream(storeFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            try {
                this.infoMap = (Map)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            ois.close();
            fis.close();
        } else {
            this.infoMap = Collections.synchronizedMap(new HashMap());
        }
        try {
            Util.init();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IOException("Failed to initialzed security utils: " + e.getMessage());
        }
        this.N = SRPConf.getDefaultParams().N();
        this.g = SRPConf.getDefaultParams().g();
        log.trace((Object)("N: " + Util.tob64(this.N.toByteArray())));
        log.trace((Object)("g: " + Util.tob64(this.g.toByteArray())));
        byte[] hn = Util.newDigest().digest(this.N.toByteArray());
        log.trace((Object)("H(N): " + Util.tob64(hn)));
        byte[] hg = Util.newDigest().digest(this.g.toByteArray());
        log.trace((Object)("H(g): " + Util.tob64(hg)));
    }

    public SRPVerifierStore.VerifierInfo getUserVerifier(String username) throws KeyException, IOException {
        SRPVerifierStore.VerifierInfo info = null;
        if (this.infoMap != null) {
            info = (SRPVerifierStore.VerifierInfo)this.infoMap.get(username);
        }
        if (info == null) {
            throw new KeyException("username: " + username + " not found");
        }
        return info;
    }

    public void setUserVerifier(String username, SRPVerifierStore.VerifierInfo info) {
        this.infoMap.put(username, info);
    }

    public void verifyUserChallenge(String username, Object auxChallenge) throws SecurityException {
        throw new SecurityException("verifyUserChallenge not supported");
    }

    public void save(File storeFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(storeFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        Map map = this.infoMap;
        synchronized (map) {
            oos.writeObject(this.infoMap);
        }
        oos.close();
        fos.close();
    }

    public void addUser(String username, String password) {
        log.trace((Object)("addUser, username='" + username + "', password='" + password + "'"));
        SRPVerifierStore.VerifierInfo info = new SRPVerifierStore.VerifierInfo();
        info.username = username;
        String rs = "123456";
        info.salt = rs.getBytes();
        try {
            char[] pass = password.toCharArray();
            info.verifier = Util.calculateVerifier(username, pass, info.salt, this.N, this.g);
            info.g = this.g.toByteArray();
            info.N = this.N.toByteArray();
            if (log.isTraceEnabled()) {
                log.trace((Object)("N: " + Util.tob64(info.N)));
                log.trace((Object)("g: " + Util.tob64(info.g)));
                log.trace((Object)("s: " + Util.tob64(info.salt)));
                byte[] xb = Util.calculatePasswordHash(username, pass, info.salt);
                log.trace((Object)("x: " + Util.tob64(xb)));
                log.trace((Object)("v: " + Util.tob64(info.verifier)));
                byte[] hn = Util.newDigest().digest(info.N);
                log.trace((Object)("H(N): " + Util.tob64(hn)));
                byte[] hg = Util.newDigest().digest(info.g);
                log.trace((Object)("H(g): " + Util.tob64(hg)));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to calculate verifier", t);
            return;
        }
        this.setUserVerifier(username, info);
    }

    public void delUser(String username) {
        this.infoMap.remove(username);
    }

    public static void main(String[] args) throws IOException {
        File storeFile = new File("SerialObjectStore.ser");
        SerialObjectStore store = new SerialObjectStore();
        int a = 0;
        while (a < args.length) {
            if (args[a].startsWith("-a")) {
                store.addUser(args[a + 1], args[a + 2]);
            } else if (args[a].startsWith("-d")) {
                store.delUser(args[a + 1]);
            }
            ++a;
        }
        store.save(storeFile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

