/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ensemble;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jgroups.ensemble.Hot_Callbacks;
import org.jgroups.ensemble.Hot_Endpoint;
import org.jgroups.ensemble.Hot_Error;
import org.jgroups.ensemble.Hot_GroupContext;
import org.jgroups.ensemble.Hot_IO_Controller;
import org.jgroups.ensemble.Hot_JoinOps;
import org.jgroups.ensemble.Hot_Message;
import org.jgroups.ensemble.Hot_Mutex;
import org.jgroups.ensemble.Hot_ViewID;
import org.jgroups.ensemble.Hot_ViewState;

public class Hot_Ensemble
implements Runnable {
    public final int HOT_ENS_MSG_SEND_UNSPECIFIED_VIEW = 0;
    public final int HOT_ENS_MSG_SEND_NEXT_VIEW = 1;
    public final int HOT_ENS_MSG_SEND_CURRENT_VIEW = 2;
    private Hot_Mutex WriteMutex;
    private Hot_Mutex CriticalMutex;
    private boolean outboardValid = false;
    private Hot_IO_Controller hioc;
    private Process ensOutboardProcess = null;
    private Socket ensOutboardSocket = null;
    private static boolean debug;
    private boolean running = true;

    public void destroyOutboard() {
        if (this.ensOutboardProcess != null) {
            this.ensOutboardProcess.destroy();
            this.ensOutboardProcess = null;
            this.outboardValid = false;
        }
    }

    public Hot_Ensemble() {
        int port = 0;
        ServerSocket s = null;
        while (port == 0) {
            port = (int)(Math.random() * 3000.0 + 5000.0);
            try {
                s = new ServerSocket(port);
            }
            catch (Exception e) {
                System.out.println("cant use port: " + port);
                port = 0;
            }
        }
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init(port);
    }

    public Hot_Ensemble(int port) {
        try {
            this.ensOutboardSocket = new Socket(InetAddress.getLocalHost(), port);
            this.hioc = new Hot_IO_Controller(new BufferedInputStream(this.ensOutboardSocket.getInputStream()), this.ensOutboardSocket.getOutputStream());
            this.outboardValid = true;
            System.out.println("outboard: outboard found on port " + port);
            this.initCritical();
            this.initWriteCritical();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(-1);
        }
    }

    private void init(int port) {
        String outboard = "outboard -tcp_channel -tcp_port " + Integer.toString(port);
        if (!this.outboardValid) {
            try {
                this.ensOutboardProcess = Runtime.getRuntime().exec(outboard);
                try {
                    System.out.println("Waiting for the outboard process to start");
                    Thread.sleep(2500L);
                }
                catch (InterruptedException e) {
                    System.out.println(e);
                    System.out.println("Sleep");
                }
                this.ensOutboardSocket = new Socket(InetAddress.getLocalHost(), port);
                this.hioc = new Hot_IO_Controller(new BufferedInputStream(this.ensOutboardSocket.getInputStream()), this.ensOutboardSocket.getOutputStream());
                this.outboardValid = true;
                System.out.println("outboard: outboard started on port " + port);
            }
            catch (SecurityException e) {
                System.out.println(e);
                System.out.println("Security exception, can't run inside web browser.");
                System.exit(2);
            }
            catch (IOException e) {
                System.err.println("Hot_Ensemble.init(" + port + "): outboard could not be started !");
                System.exit(3);
            }
            this.initCritical();
            this.initWriteCritical();
        }
        debug = false;
    }

    public void stopEnsThread() {
        this.running = false;
    }

    public void setDebug(boolean b) {
        debug = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hot_Error join(Hot_JoinOps jops, Hot_GroupContext[] gctx) {
        if (!this.outboardValid) {
            return new Hot_Error(55, "Outboard process is not valid!");
        }
        Hot_Ensemble.trace("Hot_Ensemble::join begin");
        Hot_Error err = null;
        int[] cs = new int[]{0};
        Hot_GroupContext gc = null;
        Hot_Mutex hot_Mutex = this.WriteMutex;
        synchronized (hot_Mutex) {
            Hot_Mutex hot_Mutex2 = this.CriticalMutex;
            synchronized (hot_Mutex2) {
                gc = Hot_GroupContext.alloc();
                gc.joining = true;
                gc.leaving = false;
                gc.conf = jops.conf;
                gc.env = jops.env;
                gctx[0] = gc;
            }
            this.hioc.write_groupID(cs, gc.id);
            this.hioc.getClass();
            this.hioc.write_dnType(cs, 0);
            this.hioc.write_uint(cs, jops.heartbeat_rate);
            this.hioc.write_string(cs, jops.transports);
            this.hioc.write_string(cs, jops.protocol);
            this.hioc.write_string(cs, jops.group_name);
            this.hioc.write_string(cs, jops.properties);
            this.hioc.write_bool(cs, jops.use_properties);
            this.hioc.write_bool(cs, jops.groupd);
            this.hioc.write_string(cs, jops.params);
            this.hioc.write_bool(cs, jops.client);
            this.hioc.write_bool(cs, jops.debug);
            this.hioc.write_checksum(cs[0]);
            err = this.hioc.check_write_errors();
        }
        Hot_Ensemble.trace("Hot_Ensemble::join end");
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hot_Error leave(Hot_GroupContext gc) {
        if (!this.outboardValid) {
            return new Hot_Error(55, "Outboard process is not valid!");
        }
        Hot_Error err = null;
        int[] cs = new int[]{0};
        Hot_Mutex hot_Mutex = this.WriteMutex;
        synchronized (hot_Mutex) {
            Hot_Mutex hot_Mutex2 = this.CriticalMutex;
            synchronized (hot_Mutex2) {
                if (gc.leaving) {
                    Hot_Ensemble.panic("hot_ens_leave: this member is already leaving");
                }
                gc.leaving = true;
            }
            this.hioc.write_groupID(cs, gc.id);
            this.hioc.write_dnType(cs, this.hioc.DN_LEAVE);
            this.hioc.write_checksum(cs[0]);
            err = this.hioc.check_write_errors();
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hot_Error cast(Hot_GroupContext gc, Hot_Message orig_msg, int[] send_view) {
        if (!this.outboardValid) {
            return new Hot_Error(55, "Outboard process is not valid!");
        }
        Hot_Message msg = new Hot_Message();
        byte[] m = orig_msg.getBytes();
        int len = m.length;
        int pad = 4 - len % 4;
        if (pad > 0 && pad < 4) {
            byte[] new_array = new byte[len + pad];
            System.arraycopy(m, 0, new_array, 0, len);
            msg.setBytes(new_array);
        } else {
            msg.setBytes(orig_msg.getBytes());
        }
        Hot_Ensemble.trace("Hot_Ensemble::cast begin");
        Hot_Error err = null;
        int[] cs = new int[]{0};
        Hot_Mutex hot_Mutex = this.WriteMutex;
        synchronized (hot_Mutex) {
            Hot_Mutex hot_Mutex2 = this.CriticalMutex;
            synchronized (hot_Mutex2) {
                if (gc.leaving) {
                    Hot_Ensemble.panic("hot_ens_leave: member is leaving");
                }
                if (send_view != null) {
                    send_view[0] = gc.group_blocked ? 1 : 2;
                }
            }
            this.hioc.write_groupID(cs, gc.id);
            this.hioc.getClass();
            this.hioc.write_dnType(cs, 1);
            this.hioc.write_actual_buffer(cs, msg.getBytes());
            this.hioc.write_checksum(cs[0]);
            err = this.hioc.check_write_errors();
        }
        Hot_Ensemble.trace("Hot_Ensemble::cast end");
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hot_Error send(Hot_GroupContext gc, Hot_Endpoint dest, Hot_Message orig_msg, int[] send_view) {
        if (!this.outboardValid) {
            return new Hot_Error(55, "Outboard process is not valid!");
        }
        Hot_Message msg = new Hot_Message();
        byte[] m = orig_msg.getBytes();
        int len = m.length;
        int pad = 4 - len % 4;
        if (pad > 0 && pad < 4) {
            byte[] new_array = new byte[len + pad];
            System.arraycopy(m, 0, new_array, 0, len);
            msg.setBytes(new_array);
        } else {
            msg.setBytes(orig_msg.getBytes());
        }
        Hot_Error err = null;
        int[] cs = new int[]{0};
        Hot_Mutex hot_Mutex = this.WriteMutex;
        synchronized (hot_Mutex) {
            Hot_Mutex hot_Mutex2 = this.CriticalMutex;
            synchronized (hot_Mutex2) {
                if (gc.leaving) {
                    Hot_Ensemble.panic("hot_ens_Send: member is leaving");
                }
                if (send_view != null) {
                    send_view[0] = gc.group_blocked ? 1 : 2;
                }
            }
            this.hioc.write_groupID(cs, gc.id);
            this.hioc.getClass();
            this.hioc.write_dnType(cs, 2);
            this.hioc.write_endpID(cs, dest);
            this.hioc.write_actual_buffer(cs, msg.getBytes());
            this.hioc.write_checksum(cs[0]);
            err = this.hioc.check_write_errors();
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hot_Error suspect(Hot_GroupContext gc, Hot_Endpoint[] suspects) {
        if (!this.outboardValid) {
            return new Hot_Error(55, "Outboard process is not valid!");
        }
        Hot_Error err = null;
        int[] cs = new int[]{0};
        Hot_Mutex hot_Mutex = this.WriteMutex;
        synchronized (hot_Mutex) {
            Hot_Mutex hot_Mutex2 = this.CriticalMutex;
            synchronized (hot_Mutex2) {
                if (gc.leaving) {
                    Hot_Ensemble.panic("hot_ens_Suspect: member is leaving");
                }
            }
            this.hioc.write_groupID(cs, gc.id);
            this.hioc.getClass();
            this.hioc.write_dnType(cs, 3);
            this.hioc.write_endpList(cs, suspects);
            this.hioc.write_checksum(cs[0]);
            err = this.hioc.check_write_errors();
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hot_Error changeProtocol(Hot_GroupContext gc, String protocol) {
        if (!this.outboardValid) {
            return new Hot_Error(55, "Outboard process is not valid!");
        }
        if (protocol == null) {
            Hot_Ensemble.panic("changeProtocol: don't send me null garbage!!");
        }
        Hot_Error err = null;
        int[] cs = new int[]{0};
        Hot_Mutex hot_Mutex = this.WriteMutex;
        synchronized (hot_Mutex) {
            Hot_Mutex hot_Mutex2 = this.CriticalMutex;
            synchronized (hot_Mutex2) {
                if (gc.leaving) {
                    Hot_Ensemble.panic("hot_ens_ChangeProtocol: member is leaving");
                }
            }
            this.hioc.write_groupID(cs, gc.id);
            this.hioc.getClass();
            this.hioc.write_dnType(cs, 4);
            this.hioc.write_string(cs, protocol);
            this.hioc.write_checksum(cs[0]);
            err = this.hioc.check_write_errors();
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hot_Error changeProperties(Hot_GroupContext gc, String properties) {
        if (!this.outboardValid) {
            return new Hot_Error(55, "Outboard process is not valid!");
        }
        if (properties == null) {
            Hot_Ensemble.panic("changeProperties: don't send me null garbage!!");
        }
        Hot_Error err = null;
        int[] cs = new int[]{0};
        Hot_Mutex hot_Mutex = this.WriteMutex;
        synchronized (hot_Mutex) {
            Hot_Mutex hot_Mutex2 = this.CriticalMutex;
            synchronized (hot_Mutex2) {
                if (gc.leaving) {
                    Hot_Ensemble.panic("changeProperties: member is leaving");
                }
            }
            this.hioc.write_groupID(cs, gc.id);
            this.hioc.getClass();
            this.hioc.write_dnType(cs, 5);
            this.hioc.write_string(cs, properties);
            this.hioc.write_checksum(cs[0]);
            err = this.hioc.check_write_errors();
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hot_Error requestNewView(Hot_GroupContext gc) {
        if (!this.outboardValid) {
            return new Hot_Error(55, "Outboard process is not valid!");
        }
        Hot_Error err = null;
        int[] cs = new int[]{0};
        Hot_Mutex hot_Mutex = this.WriteMutex;
        synchronized (hot_Mutex) {
            Hot_Mutex hot_Mutex2 = this.CriticalMutex;
            synchronized (hot_Mutex2) {
                if (gc.leaving) {
                    Hot_Ensemble.panic("requestNewView: member is leaving");
                }
            }
            this.hioc.write_groupID(cs, gc.id);
            this.hioc.write_dnType(cs, this.hioc.DN_PROMPT);
            this.hioc.write_checksum(cs[0]);
            err = this.hioc.check_write_errors();
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cb_View(int groupID, int[] cs) {
        Hot_ViewState hvs = new Hot_ViewState();
        Hot_Ensemble.trace("Hot_Ensemble: VIEW");
        String[] pString = new String[1];
        this.hioc.read_string(cs, pString);
        hvs.version = pString[0];
        Hot_Ensemble.trace("\t version: " + hvs.version);
        this.hioc.read_string(cs, pString);
        hvs.group_name = pString[0];
        Hot_Ensemble.trace("\t group_name: " + hvs.group_name);
        int[] pInt = new int[1];
        hvs.members = this.hioc.read_endpList(cs, pInt);
        hvs.nmembers = pInt[0];
        Hot_Ensemble.trace("\t nmembers: " + hvs.nmembers);
        this.hioc.read_uint(cs, pInt);
        hvs.rank = pInt[0];
        Hot_Ensemble.trace("\t rank: " + hvs.rank);
        this.hioc.read_string(cs, pString);
        hvs.protocol = pString[0];
        Hot_Ensemble.trace("\t protocol: " + hvs.protocol);
        boolean[] pBool = new boolean[1];
        this.hioc.read_bool(cs, pBool);
        hvs.groupd = pBool[0];
        Hot_Ensemble.trace("\t groupd: " + hvs.groupd);
        hvs.view_id = new Hot_ViewID();
        this.hioc.read_uint(cs, pInt);
        hvs.view_id.ltime = pInt[0];
        Hot_Ensemble.trace("\t view_id.ltime: " + hvs.view_id.ltime);
        hvs.view_id.coord = new Hot_Endpoint();
        this.hioc.read_endpID(cs, hvs.view_id.coord);
        Hot_Ensemble.trace("\t view_id.coord: " + hvs.view_id.coord);
        this.hioc.read_string(cs, pString);
        hvs.params = pString[0];
        Hot_Ensemble.trace("\t params: " + hvs.params);
        this.hioc.read_bool(cs, pBool);
        hvs.xfer_view = pBool[0];
        Hot_Ensemble.trace("\t xfer_view: " + hvs.xfer_view);
        this.hioc.read_bool(cs, pBool);
        hvs.primary = pBool[0];
        hvs.clients = this.hioc.read_boolList(cs);
        this.hioc.read_checksum(cs[0]);
        if (this.hioc.check_read_errors() != null) {
            Hot_Ensemble.panic("HOT: read failed inside cb_View");
        }
        Hot_GroupContext gc = null;
        Object env = null;
        Hot_Callbacks hcb = null;
        Hot_Mutex hot_Mutex = this.CriticalMutex;
        synchronized (hot_Mutex) {
            gc = Hot_GroupContext.lookup(groupID);
            env = gc.env;
            hcb = gc.conf;
            gc.group_blocked = false;
        }
        hcb.acceptedView(gc, env, hvs);
        hot_Mutex = this.CriticalMutex;
        synchronized (hot_Mutex) {
            gc.joining = false;
        }
        Hot_Ensemble.trace("Hot_Ensemble: END VIEW");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cb_Cast(int groupID, int[] cs) {
        Hot_Endpoint hep = new Hot_Endpoint();
        this.hioc.read_endpID(cs, hep);
        Hot_Message hmsg = new Hot_Message();
        this.hioc.read_buffer(cs, hmsg);
        this.hioc.read_checksum(cs[0]);
        if (this.hioc.check_read_errors() != null) {
            Hot_Ensemble.panic("HOT: read failed in cb_Cast");
        }
        Hot_GroupContext gc = null;
        Object env = null;
        Hot_Callbacks hcb = null;
        Hot_Mutex hot_Mutex = this.CriticalMutex;
        synchronized (hot_Mutex) {
            gc = Hot_GroupContext.lookup(groupID);
            env = gc.env;
            hcb = gc.conf;
        }
        hcb.receiveCast(gc, env, hep, hmsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cb_Send(int groupID, int[] cs) {
        Hot_Endpoint hep = new Hot_Endpoint();
        this.hioc.read_endpID(cs, hep);
        Hot_Message hmsg = new Hot_Message();
        this.hioc.read_buffer(cs, hmsg);
        this.hioc.read_checksum(cs[0]);
        if (this.hioc.check_read_errors() != null) {
            Hot_Ensemble.panic("HOT: read failed inside cb_Send");
        }
        Hot_GroupContext gc = null;
        Object env = null;
        Hot_Callbacks hcb = null;
        Hot_Mutex hot_Mutex = this.CriticalMutex;
        synchronized (hot_Mutex) {
            gc = Hot_GroupContext.lookup(groupID);
            env = gc.env;
            hcb = gc.conf;
        }
        hcb.receiveSend(gc, env, hep, hmsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cb_Heartbeat(int groupID, int[] cs) {
        int[] pInt = new int[]{0};
        this.hioc.read_uint(cs, pInt);
        this.hioc.read_checksum(cs[0]);
        if (this.hioc.check_read_errors() != null) {
            Hot_Ensemble.panic("HOT: read failed inside cb_Heartbeat");
        }
        Hot_GroupContext gc = null;
        Object env = null;
        Hot_Callbacks hcb = null;
        Hot_Mutex hot_Mutex = this.CriticalMutex;
        synchronized (hot_Mutex) {
            gc = Hot_GroupContext.lookup(groupID);
            env = gc.env;
            hcb = gc.conf;
        }
        hcb.heartbeat(gc, env, pInt[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cb_Block(int groupID, int[] cs) {
        this.hioc.read_checksum(cs[0]);
        if (this.hioc.check_read_errors() != null) {
            Hot_Ensemble.panic("HOT: read failed inside cb_Block");
        }
        Hot_GroupContext gc = null;
        Object env = null;
        Hot_Callbacks hcb = null;
        Hot_Mutex hot_Mutex = this.CriticalMutex;
        synchronized (hot_Mutex) {
            gc = Hot_GroupContext.lookup(groupID);
            env = gc.env;
            hcb = gc.conf;
            gc.group_blocked = true;
        }
        hcb.block(gc, env);
        hot_Mutex = this.WriteMutex;
        synchronized (hot_Mutex) {
            this.hioc.write_groupID(cs, gc.id);
            this.hioc.write_dnType(cs, this.hioc.DN_BLOCK_ON);
            this.hioc.write_checksum(cs[0]);
            if (this.hioc.check_write_errors() != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cb_Exit(int groupID, int[] cs) {
        this.hioc.read_checksum(cs[0]);
        if (this.hioc.check_read_errors() != null) {
            Hot_Ensemble.panic("HOT: read failed inside cb_Exit");
        }
        Hot_GroupContext gc = null;
        Object env = null;
        Hot_Callbacks hcb = null;
        Hot_Mutex hot_Mutex = this.CriticalMutex;
        synchronized (hot_Mutex) {
            gc = Hot_GroupContext.lookup(groupID);
            if (!gc.leaving) {
                Hot_Ensemble.panic("hot_ens_Exit_cbd: mbr state is not leaving");
            }
            env = gc.env;
            hcb = gc.conf;
        }
        hcb.exit(gc, env);
        hot_Mutex = this.CriticalMutex;
        synchronized (hot_Mutex) {
            Hot_GroupContext.release(gc);
        }
    }

    public void run() {
        Hot_Ensemble.trace("Hot_Ensemble::run() started");
        int[] cs = new int[1];
        int[] groupID = new int[1];
        int[] cbType = new int[1];
        block10: while (this.running) {
            try {
                cs[0] = 0;
                Hot_Ensemble.trace("Hot_Ensemble::run() before first read...");
                this.hioc.read_groupID(cs, groupID);
                Hot_Ensemble.trace("CALLBACK: group ID: " + groupID[0]);
                this.hioc.read_cbType(cs, cbType);
                Hot_Ensemble.trace("CALLBACK: cb type: " + cbType[0]);
                if (cbType[0] > 5 || cbType[0] < 0) {
                    Hot_Ensemble.panic("HOT: bad callback type: " + cbType[0]);
                }
                switch (cbType[0]) {
                    case 0: {
                        this.cb_View(groupID[0], cs);
                        continue block10;
                    }
                    case 1: {
                        this.cb_Cast(groupID[0], cs);
                        continue block10;
                    }
                    case 2: {
                        this.cb_Send(groupID[0], cs);
                        continue block10;
                    }
                    case 3: {
                        this.cb_Heartbeat(groupID[0], cs);
                        continue block10;
                    }
                    case 4: {
                        this.cb_Block(groupID[0], cs);
                        continue block10;
                    }
                    case 5: {
                        this.cb_Exit(groupID[0], cs);
                        continue block10;
                    }
                }
                Hot_Ensemble.panic("HOT: really shouldn't be here...");
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    public static void panic(String s) {
        System.out.println("HOT Panic!: " + s);
        System.exit(45);
    }

    private void initCritical() {
        this.CriticalMutex = new Hot_Mutex();
    }

    private void initWriteCritical() {
        this.WriteMutex = new Hot_Mutex();
    }

    public static void trace(String s) {
        if (debug) {
            System.err.println(s);
        }
    }
}

