/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import javax.net.ServerSocketFactory;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;
import org.jboss.net.sockets.DefaultSocketFactory;
import org.jboss.net.sockets.QueuedClientSocketFactory;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.server.MainMBean;
import org.jnp.server.NamingServer;

public class Main
implements Runnable,
MainMBean {
    protected NamingServer theServer;
    protected MarshalledObject serverStub;
    protected ServerSocket serverSocket;
    protected RMIClientSocketFactory clientSocketFactory;
    protected RMIServerSocketFactory serverSocketFactory;
    protected ServerSocketFactory jnpServerSocketFactory;
    protected String clientSocketFactoryName = null;
    protected String serverSocketFactoryName = null;
    protected String jnpServerSocketFactoryName = null;
    protected InetAddress bindAddress;
    protected int backlog = 50;
    protected long maxConcurrentClientConnections = 0L;
    protected int port = 1099;
    protected int rmiPort = 0;
    protected Category log;

    public static void main(String[] args) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource("log4j.properties");
        if (url == null) {
            System.err.println("Failed to find log4j.properties");
        } else {
            PropertyConfigurator.configure((URL)url);
        }
        new Main().start();
    }

    public Main() {
        this("org.jboss.naming.Naming");
    }

    public Main(String categoryName) {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream is = loader.getResourceAsStream("jnp.properties");
            System.getProperties().load(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPort(Integer.getInteger("jnp.port", this.getPort()));
        this.setRmiPort(Integer.getInteger("jnp.rmiPort", this.getRmiPort()));
        this.log = Category.getInstance((String)categoryName);
    }

    public Naming getServer() {
        return this.theServer;
    }

    public void setRmiPort(int p) {
        this.rmiPort = p;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public int getPort() {
        return this.port;
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(host);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog <= 0) {
            backlog = 50;
        }
        this.backlog = backlog;
    }

    public long getMaxConcurrentClientConnections() {
        return this.maxConcurrentClientConnections;
    }

    public void setMaxConcurrentClientConnections(long max) {
        this.maxConcurrentClientConnections = max;
    }

    public String getClientSocketFactory() {
        return this.clientSocketFactoryName;
    }

    public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.clientSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.clientSocketFactoryName);
        this.clientSocketFactory = (RMIClientSocketFactory)clazz.newInstance();
    }

    public String getServerSocketFactory() {
        return this.serverSocketFactoryName;
    }

    public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.serverSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.serverSocketFactoryName);
        this.serverSocketFactory = (RMIServerSocketFactory)clazz.newInstance();
    }

    public void setJNPServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.jnpServerSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.jnpServerSocketFactoryName);
        this.jnpServerSocketFactory = (ServerSocketFactory)clazz.newInstance();
    }

    public void start() throws Exception {
        this.log.info((Object)"Starting jnp server");
        if (this.theServer == null) {
            this.theServer = new NamingServer();
            NamingContext.setLocal(this.theServer);
        }
        if (this.port >= 0) {
            this.initJnpInvoker();
        }
    }

    public void stop() {
        try {
            this.log.info((Object)"Stopping");
            if (this.serverSocket != null) {
                UnicastRemoteObject.unexportObject(this.theServer, false);
                ServerSocket s = this.serverSocket;
                this.serverSocket = null;
                s.close();
            }
            this.log.info((Object)"Stopped");
        }
        catch (Exception e) {
            this.log.error((Object)"Exception during shutdown", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        block13: {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException e) {
                if (this.serverSocket == null) {
                    return;
                }
                this.log.error((Object)"Naming stopped", (Throwable)e);
                this.log.info((Object)"Restarting naming");
                try {
                    this.start();
                }
                catch (Exception ex) {
                    this.log.error((Object)"Restart failed", (Throwable)ex);
                    return;
                }
            }
            this.listen();
            ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
            out.writeObject(this.serverStub);
            Object var5_6 = null;
            try {
                socket.close();
            }
            catch (IOException e) {}
            break block13;
            {
                catch (IOException ex) {
                    this.log.error((Object)"Error writing response", (Throwable)ex);
                    Object var5_7 = null;
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void listen() {
        Thread t = new Thread((Runnable)this, "JNP Server");
        t.start();
    }

    protected void initJnpInvoker() throws IOException {
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = new DefaultSocketFactory(this.backlog);
        }
        if (this.clientSocketFactory == null && this.maxConcurrentClientConnections > 0L) {
            this.clientSocketFactory = new QueuedClientSocketFactory(this.maxConcurrentClientConnections);
        }
        Remote stub = UnicastRemoteObject.exportObject(this.theServer, this.rmiPort, this.clientSocketFactory, this.serverSocketFactory);
        this.log.debug((Object)("NamingServer stub: " + stub));
        this.serverStub = new MarshalledObject<Remote>(stub);
        try {
            if (this.jnpServerSocketFactory == null) {
                this.jnpServerSocketFactory = ServerSocketFactory.getDefault();
            }
            this.serverSocket = this.jnpServerSocketFactory.createServerSocket(this.port, this.backlog, this.bindAddress);
            if (this.port == 0) {
                this.port = this.serverSocket.getLocalPort();
            }
            String msg = "Started jnpPort=" + this.port + ", rmiPort=" + this.rmiPort + ", backlog=" + this.backlog + ", bindAddress=" + this.bindAddress + ", Client SocketFactory=" + this.clientSocketFactory + ", Server SocketFactory=" + this.serverSocketFactory;
            this.log.info((Object)msg);
            this.listen();
        }
        catch (IOException e) {
            this.log.error((Object)("Could not start on port " + this.port), (Throwable)e);
        }
    }
}

