/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.io.ByteArrayOutputStream;

public class BitArray {
    private byte[] a;
    private int b;
    private static final int c = 8;
    private static final byte[][] d = new byte[][]{{48, 48, 48, 48}, {48, 48, 48, 49}, {48, 48, 49, 48}, {48, 48, 49, 49}, {48, 49, 48, 48}, {48, 49, 48, 49}, {48, 49, 49, 48}, {48, 49, 49, 49}, {49, 48, 48, 48}, {49, 48, 48, 49}, {49, 48, 49, 48}, {49, 48, 49, 49}, {49, 49, 48, 48}, {49, 49, 48, 49}, {49, 49, 49, 48}, {49, 49, 49, 49}};
    private static final int e = 8;

    public BitArray(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        this.b = n;
        this.a = new byte[(n + 8 - 1) / 8];
    }

    public BitArray(int n, byte[] byArray) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        if (byArray.length * 8 < n) {
            throw new IllegalArgumentException("Byte array too short to represent bit array of given length");
        }
        this.b = n;
        int n2 = (n + 8 - 1) / 8;
        int n3 = n2 * 8 - n;
        byte by = (byte)(255 << n3);
        this.a = new byte[n2];
        System.arraycopy(byArray, 0, this.a, 0, n2);
        this.a[this.a.length - 1] = (byte)(this.a[this.a.length - 1] & by);
    }

    private BitArray(BitArray bitArray) {
        this.b = bitArray.b;
        this.a = (byte[])bitArray.a.clone();
    }

    public BitArray(boolean[] blArray) {
        this.b = blArray.length;
        this.a = new byte[(this.b + 7) / 8];
        int n = 0;
        while (n < this.b) {
            this.set(n, blArray[n]);
            ++n;
        }
    }

    public Object clone() {
        return new BitArray(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof BitArray)) {
            return false;
        }
        BitArray bitArray = (BitArray)object;
        if (bitArray.b != this.b) {
            return false;
        }
        int n = 0;
        while (n < this.a.length) {
            if (this.a[n] != bitArray.a[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean get(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.b) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
        }
        return (this.a[BitArray.b(n)] & BitArray.a(n)) != 0;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.a.length) {
            n = 31 * n + this.a[n2];
            ++n2;
        }
        return n ^ this.b;
    }

    public int length() {
        return this.b;
    }

    private static int a(int n) {
        return 1 << 7 - n % 8;
    }

    public void set(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.b) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
        }
        int n2 = BitArray.b(n);
        int n3 = BitArray.a(n);
        if (bl) {
            int n4 = n2;
            this.a[n4] = (byte)(this.a[n4] | n3);
        } else {
            int n5 = n2;
            this.a[n5] = (byte)(this.a[n5] & ~n3);
        }
    }

    private static int b(int n) {
        return n / 8;
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.b];
        int n = 0;
        while (n < this.b) {
            blArray[n] = this.get(n);
            ++n;
        }
        return blArray;
    }

    public byte[] toByteArray() {
        return (byte[])this.a.clone();
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < this.a.length - 1) {
            byteArrayOutputStream.write(d[this.a[n] >> 4 & 0xF], 0, 4);
            byteArrayOutputStream.write(d[this.a[n] & 0xF], 0, 4);
            if (n % 8 == 7) {
                byteArrayOutputStream.write(10);
            } else {
                byteArrayOutputStream.write(32);
            }
            ++n;
        }
        int n2 = 8 * (this.a.length - 1);
        while (n2 < this.b) {
            byteArrayOutputStream.write(this.get(n2) ? 49 : 48);
            ++n2;
        }
        return new String(byteArrayOutputStream.toByteArray());
    }
}

