/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Map;
import net.sourceforge.jtds.jdbc.Columns;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.TdsResultSetMetaData;

public abstract class AbstractResultSet
implements ResultSet {
    public static final String cvsVersion = "$Id: AbstractResultSet.java,v 1.2 2002/10/22 11:22:51 alin_sinpalean Exp $";
    public static final int DEFAULT_FETCH_SIZE = 100;
    protected int fetchSize = 100;
    protected SQLWarningChain warningChain = null;
    ResultSetMetaData metaData = null;
    private static NumberFormat f = NumberFormat.getInstance();

    public abstract Context getContext();

    public abstract PacketRowResult currentRow() throws SQLException;

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = new TdsResultSetMetaData(this.getContext().getColumnInfo());
        }
        return this.metaData;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getLong(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public int getInt(int n) throws SQLException {
        return (int)this.getLong(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.currentRow().getBigDecimal(n, n2);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.currentRow().getBoolean(n);
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getLong(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.currentRow().getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        Date date = null;
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp != null) {
            date = new Date(((java.util.Date)timestamp).getTime());
        }
        return date;
    }

    public double getDouble(int n) throws SQLException {
        return this.currentRow().getDouble(n);
    }

    public long getLong(int n) throws SQLException {
        return this.currentRow().getLong(n);
    }

    public Object getObject(int n) throws SQLException {
        if (this.currentRow() == null) {
            throw new SQLException("No current row in the result set.");
        }
        return this.currentRow().getObject(n);
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            StringBuffer stringBuffer = new StringBuffer(2 * byArray.length);
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = byArray[n2] & 0xFF;
                int n4 = n3 / 16;
                stringBuffer.append(n4 < 10 ? (char)(48 + n4) : (char)(65 + n4 - 10));
                n4 = n3 % 16;
                stringBuffer.append(n4 < 10 ? (char)(48 + n4) : (char)(65 + n4 - 10));
                ++n2;
            }
            return stringBuffer.toString();
        }
        return object.toString();
    }

    public Time getTime(int n) throws SQLException {
        Time time = null;
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp != null) {
            time = new Time(((java.util.Date)timestamp).getTime());
        }
        return time;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.currentRow().getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.currentRow().getBigDecimal(this.findColumn(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Ref getRef(int n) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Clob getClob(int n) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Array getArray(int n) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.currentRow().getTimestamp(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public int findColumn(String string) throws SQLException {
        Columns columns = this.getContext().getColumnInfo();
        int n = 1;
        while (n <= columns.fakeColumnCount()) {
            if (columns.getName(n).equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        throw new SQLException("No such column " + string);
    }

    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public boolean wasNull() throws SQLException {
        return this.currentRow().wasNull();
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)new Boolean(bl));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (object instanceof BigDecimal) {
            f.setMaximumFractionDigits(n2);
            this.updateObject(n, (Object)((BigDecimal)object).setScale(n2));
        } else if (object instanceof Number) {
            f.setMaximumFractionDigits(n2);
            this.updateObject(n, (Object)f.format(object));
        } else {
            this.updateObject(n, object);
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.currentRow().setElementAt(n, object);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public abstract Statement getStatement() throws SQLException;

    public abstract void moveToCurrentRow() throws SQLException;

    public abstract void moveToInsertRow() throws SQLException;

    public abstract void cancelRowUpdates() throws SQLException;

    public abstract void refreshRow() throws SQLException;

    public abstract void deleteRow() throws SQLException;

    public abstract void updateRow() throws SQLException;

    public abstract void insertRow() throws SQLException;

    public abstract boolean rowDeleted() throws SQLException;

    public abstract boolean rowInserted() throws SQLException;

    public abstract boolean rowUpdated() throws SQLException;

    public abstract int getConcurrency() throws SQLException;

    public abstract int getType() throws SQLException;

    public abstract int getFetchSize() throws SQLException;

    public abstract void setFetchSize(int var1) throws SQLException;

    public abstract int getFetchDirection() throws SQLException;

    public abstract void setFetchDirection(int var1) throws SQLException;

    public abstract boolean previous() throws SQLException;

    public abstract boolean relative(int var1) throws SQLException;

    public abstract boolean absolute(int var1) throws SQLException;

    public abstract int getRow() throws SQLException;

    public abstract boolean last() throws SQLException;

    public abstract boolean first() throws SQLException;

    public abstract void afterLast() throws SQLException;

    public abstract void beforeFirst() throws SQLException;

    public abstract boolean isLast() throws SQLException;

    public abstract boolean isFirst() throws SQLException;

    public abstract boolean isAfterLast() throws SQLException;

    public abstract boolean isBeforeFirst() throws SQLException;

    public abstract String getCursorName() throws SQLException;

    public abstract void clearWarnings() throws SQLException;

    public abstract SQLWarning getWarnings() throws SQLException;

    public abstract void close() throws SQLException;

    public abstract boolean next() throws SQLException;
}

