/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.AbstractResultSet;
import net.sourceforge.jtds.jdbc.Columns;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsResultSet;
import net.sourceforge.jtds.jdbc.TdsStatement;

public class CursorResultSet
extends AbstractResultSet {
    public static final int SQL_ROW_SUCCESS = 0;
    public static final int SQL_ROW_DELETED = 1;
    public static final int SQL_ROW_UPDATED = 2;
    public static final int SQL_ROW_NOROW = 3;
    public static final int SQL_ROW_ADDED = 4;
    public static final int SQL_ROW_ERROR = 5;
    private static final int POS_BEFORE_FIRST = -1;
    private static final int POS_AFTER_LAST = -2;
    private static final int POS_LAST = -3;
    private int pos = -1;
    private String cursorName;
    private String sql;
    private TdsStatement stmt;
    private TdsConnection conn;
    private int direction = 1000;
    private boolean open = false;
    private Context context;
    private static int count = 0;
    private PacketRowResult current;

    private void loadContext() throws SQLException {
        if (this.current == null) {
            this.internalFetch("FETCH PRIOR FROM " + this.cursorName);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public CursorResultSet(TdsStatement tdsStatement, String string, int n) throws SQLException {
        this.stmt = tdsStatement;
        this.conn = (TdsConnection)tdsStatement.getConnection();
        this.sql = string;
        this.direction = n == 1002 ? 1000 : n;
        this.warningChain = new SQLWarningChain();
        this.createCursor();
        this.loadContext();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        this.direction = n;
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.pos == -1;
    }

    public boolean isAfterLast() throws SQLException {
        return this.pos == -2;
    }

    public boolean isFirst() throws SQLException {
        return this.pos == 1;
    }

    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException("Method isLast() not yet implemented.");
    }

    public int getRow() throws SQLException {
        return this.pos;
    }

    public int getFetchDirection() throws SQLException {
        return this.direction;
    }

    public int getFetchSize() throws SQLException {
        return 1;
    }

    public int getType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    public void close() throws SQLException {
        if (this.open) {
            Object object = this.conn.mainTdsMonitor;
            synchronized (object) {
                Tds tds = this.conn.allocateTds(true);
                this.stmt.internalExecute("CLOSE " + this.cursorName, tds, this.warningChain);
                this.stmt.internalExecute("DEALLOCATE " + this.cursorName, tds, this.warningChain);
                this.open = false;
                try {
                    this.conn.freeTds(tds);
                }
                catch (TdsException tdsException) {
                    throw new SQLException(tdsException.getMessage());
                }
            }
        }
        this.stmt = null;
        this.conn = null;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain.getWarnings();
    }

    public boolean next() throws SQLException {
        if (this.direction == 1001) {
            --this.pos;
            if (this.internalFetch("FETCH PRIOR FROM " + this.cursorName)) {
                return true;
            }
            this.pos = -1;
            return false;
        }
        ++this.pos;
        if (this.internalFetch("FETCH NEXT FROM " + this.cursorName)) {
            return true;
        }
        this.pos = -2;
        return false;
    }

    private boolean internalFetch(String string) throws SQLException {
        TdsResultSet tdsResultSet = null;
        Object object = this.conn.mainTdsMonitor;
        synchronized (object) {
            Tds tds = this.conn.allocateTds(true);
            if (!this.stmt.internalExecute(string, tds, this.warningChain)) {
                throw new SQLException("No ResultSet was produced.");
            }
            tdsResultSet = (TdsResultSet)this.stmt.getResultSet();
            if (this.context == null) {
                this.context = tdsResultSet.getContext();
            }
            this.current = tdsResultSet.next() ? tdsResultSet.currentRow() : null;
            this.warningChain.addWarning(tdsResultSet.getWarnings());
            tdsResultSet.close();
            try {
                this.conn.freeTds(tds);
            }
            catch (TdsException tdsException) {
                throw new SQLException(tdsException.getMessage());
            }
        }
        this.context.getColumnInfo().setFakeColumnCount(this.context.getColumnInfo().realColumnCount() - 1);
        return this.current != null;
    }

    public void clearWarnings() throws SQLException {
        this.warningChain.clearWarnings();
    }

    public void beforeFirst() throws SQLException {
        if (this.pos != -1) {
            this.pos = -1;
            this.internalFetch("FETCH FIRST FROM " + this.cursorName);
            this.internalFetch("FETCH PRIOR FROM " + this.cursorName);
        }
    }

    public void afterLast() throws SQLException {
        if (this.pos != -2) {
            this.pos = -2;
            this.internalFetch("FETCH LAST FROM " + this.cursorName);
            this.internalFetch("FETCH NEXT FROM " + this.cursorName);
        }
    }

    public boolean first() throws SQLException {
        this.pos = 1;
        return this.internalFetch("FETCH FIRST FROM " + this.cursorName);
    }

    public boolean last() throws SQLException {
        this.pos = -3;
        return this.internalFetch("FETCH LAST FROM " + this.cursorName);
    }

    public boolean absolute(int n) throws SQLException {
        this.pos = n;
        return this.internalFetch("FETCH ABSOLUTE " + n + " FROM " + this.cursorName);
    }

    public boolean relative(int n) throws SQLException {
        if (this.direction == 1001) {
            n = -n;
        }
        this.pos += n;
        return this.internalFetch("FETCH RELATIVE " + n + " FROM " + this.cursorName);
    }

    public boolean previous() throws SQLException {
        if (this.direction == 1001) {
            ++this.pos;
            if (this.internalFetch("FETCH NEXT FROM " + this.cursorName)) {
                return true;
            }
            this.pos = -2;
            return false;
        }
        --this.pos;
        if (this.internalFetch("FETCH PRIOR FROM " + this.cursorName)) {
            return true;
        }
        this.pos = -1;
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return this.getRowStat() == 2;
    }

    private int getRowStat() throws SQLException {
        return (int)this.current.getLong(this.getColumnInfo().realColumnCount());
    }

    public boolean rowInserted() throws SQLException {
        return this.getRowStat() == 4;
    }

    public boolean rowDeleted() throws SQLException {
        return this.getRowStat() == 1;
    }

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("Method cancelRowUpdates() not yet implemented.");
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("Method moveToInsertRow() not yet implemented.");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("Method moveToCurrentRow() not yet implemented.");
    }

    private void createCursor() throws SQLException {
        this.cursorName = CursorResultSet.getNewCursorName();
        StringBuffer stringBuffer = new StringBuffer(this.sql.length() + 50);
        if (this.conn.getTdsVer() >= 70) {
            stringBuffer.append("DECLARE ").append(this.cursorName).append(" CURSOR ");
            if (this.stmt.getResultSetType() == 1003 && this.stmt.getResultSetConcurrency() == 1007) {
                stringBuffer.append("FAST_FORWARD ");
            } else {
                if (this.stmt.getResultSetType() == 1003) {
                    stringBuffer.append("FORWARD_ONLY ");
                } else if (this.stmt.getResultSetType() == 1004) {
                    stringBuffer.append("SCROLL STATIC ");
                } else if (this.stmt.getResultSetType() == 1005) {
                    stringBuffer.append("SCROLL KEYSET ");
                }
                if (this.stmt.getResultSetConcurrency() == 1007) {
                    stringBuffer.append("READ_ONLY ");
                } else {
                    stringBuffer.append("OPTIMISTIC ");
                }
            }
            stringBuffer.append("FOR ").append(this.sql);
        } else {
            stringBuffer.append("DECLARE ").append(this.cursorName);
            if (this.stmt.getResultSetType() != 1005) {
                stringBuffer.append(" INSENSITIVE");
            }
            if (this.stmt.getResultSetType() != 1003) {
                stringBuffer.append(" SCROLL");
            }
            stringBuffer.append(" CURSOR FOR ").append(this.sql).append(" FOR ");
            if (this.stmt.getResultSetConcurrency() == 1007) {
                stringBuffer.append("READ ONLY");
            } else {
                stringBuffer.append("UPDATE");
            }
        }
        Object object = this.conn.mainTdsMonitor;
        synchronized (object) {
            Tds tds = this.conn.allocateTds(true);
            this.stmt.internalExecute(stringBuffer.toString(), tds, this.warningChain);
            this.stmt.internalExecute("OPEN " + this.cursorName, tds, this.warningChain);
            try {
                this.conn.freeTds(tds);
            }
            catch (TdsException tdsException) {
                throw new SQLException(tdsException.getMessage());
            }
        }
        this.open = true;
    }

    private static synchronized String getNewCursorName() {
        return "cursor_" + ++count;
    }

    public PacketRowResult currentRow() {
        return this.current;
    }

    public void insertRow() {
        throw new UnsupportedOperationException("Method moveToInsertRow() not yet implemented.");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    private Columns getColumnInfo() {
        return this.getContext().getColumnInfo();
    }
}

