/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.ParameterUtils;
import net.sourceforge.jtds.jdbc.PreparedStatementHelper;
import net.sourceforge.jtds.jdbc.Procedure;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsStatement;

public class PreparedStatement_base
extends TdsStatement
implements PreparedStatementHelper,
PreparedStatement {
    public static final String cvsVersion = "$Id: PreparedStatement_base.java,v 1.3 2002/10/18 15:21:07 alin_sinpalean Exp $";
    String rawQueryString = null;
    ParameterListItem[] parameterList = null;
    static Map typemap = null;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public PreparedStatement_base(TdsConnection tdsConnection, String string) throws SQLException {
        this(tdsConnection, string, 1003, 1007);
    }

    public PreparedStatement_base(TdsConnection tdsConnection, String string, int n, int n2) throws SQLException {
        super(tdsConnection, n, n2);
        this.rawQueryString = tdsConnection.nativeSQL(string);
        int n3 = ParameterUtils.countParameters(this.rawQueryString);
        this.parameterList = new ParameterListItem[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.parameterList[n4] = new ParameterListItem();
            ++n4;
        }
    }

    protected void NotImplemented() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void clearParameters() throws SQLException {
        int n = 0;
        while (n < this.parameterList.length) {
            this.parameterList[n].clear();
            ++n;
        }
    }

    public boolean execute() throws SQLException {
        Tds tds = this.getTds(false);
        return this.execute(tds);
    }

    public boolean execute(Tds tds) throws SQLException {
        Procedure procedure = null;
        boolean bl = false;
        ParameterUtils.verifyThatParametersAreSet(this.parameterList);
        procedure = this.findCompatibleStoredProcedure(tds, this.rawQueryString);
        if (procedure == null) {
            procedure = new Procedure(this.rawQueryString, tds.getUniqueProcedureName(), this.parameterList, tds);
            this.submitProcedure(tds, procedure);
            tds.procedureCache.put(this.rawQueryString, procedure);
            if (!this.getConnection().getAutoCommit()) {
                tds.proceduresOfTra.add(procedure);
            }
        }
        bl = this.internalExecuteCall(procedure.getProcedureName(), procedure.getParameterList(), this.parameterList, tds, this.warningChain);
        return bl;
    }

    private Procedure findCompatibleStoredProcedure(Tds tds, String string) {
        return (Procedure)tds.procedureCache.get(string);
    }

    private void submitProcedure(Tds tds, Procedure procedure) throws SQLException {
        String string = procedure.getPreparedSqlString();
        tds.submitProcedure(string, this.warningChain);
    }

    public ResultSet executeQuery() throws SQLException {
        Tds tds = this.getTds(false);
        if (!this.execute(tds)) {
            this.skipToEnd();
            this.releaseTds();
            throw new SQLException("Was expecting a result set");
        }
        return this.results;
    }

    public int executeUpdate() throws SQLException {
        Tds tds = this.getTds(false);
        if (this.execute(tds)) {
            this.skipToEnd();
            this.releaseTds();
            throw new SQLException("executeUpdate can't return a result set");
        }
        int n = this.getUpdateCount();
        this.releaseTds();
        return n;
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.NotImplemented();
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setParam(n, bigDecimal, 3, -1);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3;
        if (n2 == 0) {
            this.setBytes(n, null);
        }
        byte[] byArray = new byte[n2];
        try {
            n3 = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException("setBinaryStream: IO-Exception occured reading Stream" + iOException.toString());
            throw sQLException;
        }
        if (n3 != n2) {
            throw new SQLException("SetBinaryStream parameterized Length: " + Integer.toString(n2) + " got length: " + Integer.toString(n3));
        }
        try {
            n3 = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException("setBinaryStream: IO-Exception occured reading Stream" + iOException.toString());
            throw sQLException;
        }
        if (n3 != -1) {
            throw new SQLException("SetBinaryStream parameterized Length: " + Integer.toString(n2) + " got more than that ");
        }
        this.setBytes(n, byArray);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setParam(n, new Boolean(bl), -7, -1);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setParam(n, new Integer(by), 5, -1);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length <= 255 || byArray.length <= 8000 && ((TdsConnection)this.getConnection()).getTdsVer() == 70) {
            this.setParam(n, byArray, -3, -1);
        } else {
            this.setParam(n, byArray, -4, -1);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setParam(n, date, 91, -1);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.setParam(n, new Double(d), 8, -1);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setParam(n, new Float(f), 7, -1);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setParam(n, new Integer(n2), 4, -1);
    }

    public void setLong(int n, long l) throws SQLException {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            this.setParam(n, new Integer((int)l), 4, -1);
        } else {
            this.setParam(n, new Long(l), 2, 0);
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setParam(n, null, n2, -1);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.setNull(n, 12);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Integer) {
            this.setInt(n, ((Number)object).intValue());
        } else if (object instanceof Long) {
            this.setLong(n, ((Number)object).longValue());
        } else if (object instanceof Byte) {
            this.setByte(n, ((Number)object).byteValue());
        } else if (object instanceof Short) {
            this.setShort(n, ((Number)object).shortValue());
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Double) {
            this.setDouble(n, ((Number)object).doubleValue());
        } else if (object instanceof Float) {
            this.setFloat(n, ((Number)object).floatValue());
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof java.util.Date) {
            this.setTimestamp(n, new Timestamp(((java.util.Date)object).getTime()));
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE)) {
                this.setBytes(n, (byte[])object);
            } else {
                throw new SQLException("Not implemented");
            }
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    protected void setParam(int n, Object object, int n2, int n3) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid Parameter index " + n + ".  JDBC indexes start at 1.");
        }
        if (n > this.parameterList.length) {
            throw new SQLException("Invalid Parameter index " + n + ".  This statement only has " + this.parameterList.length + " parameters");
        }
        this.parameterList[--n].type = n2;
        this.parameterList[n].isSet = true;
        this.parameterList[n].value = object;
        this.parameterList[n].maxLength = n3;
    }

    protected static Map getTypemap() {
        if (typemap != null) {
            return typemap;
        }
        HashMap<Class, Integer> hashMap = new HashMap<Class, Integer>(15);
        hashMap.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PreparedStatement_base.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new Integer(2));
        hashMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PreparedStatement_base.class$("java.lang.Boolean")) : class$java$lang$Boolean, new Integer(-7));
        hashMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = PreparedStatement_base.class$("java.lang.Byte")) : class$java$lang$Byte, new Integer(-6));
        hashMap.put(array$B == null ? (array$B = PreparedStatement_base.class$("[B")) : array$B, new Integer(-3));
        hashMap.put(class$java$sql$Date == null ? (class$java$sql$Date = PreparedStatement_base.class$("java.sql.Date")) : class$java$sql$Date, new Integer(91));
        hashMap.put(class$java$lang$Double == null ? (class$java$lang$Double = PreparedStatement_base.class$("java.lang.Double")) : class$java$lang$Double, new Integer(8));
        hashMap.put(Float.TYPE, new Integer(7));
        hashMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = PreparedStatement_base.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(4));
        hashMap.put(class$java$lang$Long == null ? (class$java$lang$Long = PreparedStatement_base.class$("java.lang.Long")) : class$java$lang$Long, new Integer(2));
        hashMap.put(class$java$lang$Short == null ? (class$java$lang$Short = PreparedStatement_base.class$("java.lang.Short")) : class$java$lang$Short, new Integer(5));
        hashMap.put(class$java$lang$String == null ? (class$java$lang$String = PreparedStatement_base.class$("java.lang.String")) : class$java$lang$String, new Integer(12));
        hashMap.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PreparedStatement_base.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new Integer(93));
        typemap = hashMap;
        return typemap;
    }

    protected static int getType(Object object) throws SQLException {
        if (object == null) {
            throw new SQLException("You must specify a type for a null parameter");
        }
        Map map = PreparedStatement_base.getTypemap();
        Object v = map.get(object.getClass());
        if (v == null) {
            throw new SQLException("Support for this type is not implemented");
        }
        return (Integer)v;
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setParam(n, object, n2, n3);
            return;
        }
        switch (n2) {
            case 1: 
            case 12: {
                this.setString(n, (String)object);
                break;
            }
            case 7: {
                this.setFloat(n, ((Float)object).floatValue());
                break;
            }
            case 8: {
                this.setDouble(n, (Double)object);
                break;
            }
            case 4: {
                this.setInt(n, (Integer)object);
                break;
            }
            case -5: {
                this.setLong(n, (Long)object);
                break;
            }
            default: {
                this.setParam(n, object, n2, n3);
            }
        }
    }

    public void setShort(int n, short s) throws SQLException {
        this.setParam(n, new Integer(s), 5, -1);
    }

    public void setString(int n, String string) throws SQLException {
        this.setParam(n, string, 12, string == null ? -1 : string.length());
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setParam(n, time, 92, -1);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setParam(n, timestamp, 93, -1);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void addBatch() throws SQLException {
        this.NotImplemented();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.NotImplemented();
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.NotImplemented();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.NotImplemented();
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.NotImplemented();
    }

    public void setArray(int n, Array array) throws SQLException {
        this.NotImplemented();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.NotImplemented();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.NotImplemented();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

