/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import net.sourceforge.jtds.jdbc.CallableStatement_base;
import net.sourceforge.jtds.jdbc.DatabaseMetaData;
import net.sourceforge.jtds.jdbc.PreparedStatement_base;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsInstance;
import net.sourceforge.jtds.jdbc.TdsStatement;

public class TdsConnection
implements Connection {
    private String host = null;
    private int serverType = -1;
    private int port = -1;
    private int tdsVer = -1;
    private String database = null;
    private Properties initialProps = null;
    private final Vector tdsPool = new Vector();
    private final Vector allStatements = new Vector();
    private DatabaseMetaData databaseMetaData = null;
    private boolean autoCommit = true;
    private int transactionIsolationLevel = 2;
    private boolean isClosed = false;
    private SQLWarningChain warningChain;
    private boolean haveMainTds = false;
    final Object mainTdsMonitor = new Object();
    public static final String cvsVersion = "$Id: TdsConnection.java,v 1.3 2002/10/17 14:59:59 alin_sinpalean Exp $";

    public TdsConnection(Properties properties) throws SQLException, TdsException {
        this.host = properties.getProperty("HOST");
        this.serverType = Integer.parseInt(properties.getProperty("SERVERTYPE"));
        this.port = Integer.parseInt(properties.getProperty("PORT"));
        this.database = properties.getProperty("DBNAME");
        String string = properties.getProperty("USER");
        String string2 = properties.getProperty("PASSWORD");
        this.initialProps = properties;
        this.warningChain = new SQLWarningChain();
        if (string == null) {
            string = properties.getProperty("USER".toLowerCase());
            if (string == null) {
                throw new SQLException("Need a username.");
            }
            ((Hashtable)properties).put("USER", string);
        }
        if (string2 == null) {
            string2 = properties.getProperty("PASSWORD".toLowerCase());
            if (string2 == null) {
                throw new SQLException("Need a password.");
            }
            ((Hashtable)properties).put("PASSWORD", string2);
        }
        Tds tds = this.allocateTds(false);
        this.tdsVer = tds.getTdsVer();
        this.database = tds.getDatabase();
        this.freeTds(tds);
    }

    protected int getTdsVer() throws SQLException {
        this.checkClosed();
        return this.tdsVer;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        this.autoCommit = bl;
        this.changeSettings();
    }

    private void changeSettings() throws SQLException {
        int n = 0;
        while (n < this.allStatements.size()) {
            ((TdsStatement)this.allStatements.elementAt(n)).changeSettings(this.autoCommit, this.transactionIsolationLevel);
            ++n;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
    }

    public synchronized void setCatalog(String string) throws SQLException {
        if (this.database.equals(string)) {
            return;
        }
        int n = 0;
        while (n < this.tdsPool.size()) {
            Tds tds;
            Tds tds2 = tds = ((TdsInstance)this.tdsPool.get((int)n)).tds;
            synchronized (tds2) {
                Object object;
                TdsStatement tdsStatement = tds.statement;
                Object object2 = object = tdsStatement == null ? tds : tdsStatement;
                synchronized (object2) {
                    if (tdsStatement != null) {
                        tdsStatement.skipToEnd();
                    }
                    tds.changeDB(string);
                }
            }
            ++n;
        }
        this.database = string;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkClosed();
        this.transactionIsolationLevel = n;
        this.changeSettings();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.NotImplemented();
    }

    public String getUrl() throws SQLException {
        this.checkClosed();
        return "jdbc:jtds:" + (this.serverType == 2 ? "sybase" : "sqlserver") + "://" + this.host + ":" + this.port + "/" + this.database;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public synchronized java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = DatabaseMetaData.getInstance(this, ((TdsInstance)this.tdsPool.get((int)0)).tds);
        }
        return this.databaseMetaData;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return false;
    }

    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.database;
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.transactionIsolationLevel;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain.getWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    public synchronized void markAsClosed(Statement statement) {
        this.allStatements.removeElement(statement);
    }

    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        TdsStatement tdsStatement = new TdsStatement(this);
        this.allStatements.addElement(tdsStatement);
        return tdsStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public String nativeSQL(String string) throws SQLException {
        return Tds.toNativeSql(string, this.serverType);
    }

    public synchronized void commit() throws SQLException {
        this.commitOrRollback(true);
    }

    public synchronized void rollback() throws SQLException {
        this.commitOrRollback(false);
    }

    public synchronized void close() throws SQLException {
        SQLException sQLException = null;
        int n = this.allStatements.size() - 1;
        while (n >= 0) {
            try {
                ((Statement)this.allStatements.elementAt(n)).close();
            }
            catch (SQLException sQLException2) {
                sQLException2.setNextException(sQLException);
                sQLException = sQLException2;
            }
            --n;
        }
        this.allStatements.clear();
        n = 0;
        while (n < this.tdsPool.size()) {
            try {
                Tds tds;
                Tds tds2 = tds = ((TdsInstance)this.tdsPool.elementAt((int)n)).tds;
                synchronized (tds2) {
                    if (!this.autoCommit) {
                        tds.rollback();
                    }
                    tds.close();
                }
            }
            catch (SQLException sQLException3) {
                sQLException.setNextException(sQLException3);
            }
            ++n;
        }
        this.tdsPool.clear();
        this.clearWarnings();
        this.isClosed = true;
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warningChain.clearWarnings();
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        TdsStatement tdsStatement = new TdsStatement(this, n, n2);
        this.allStatements.addElement(tdsStatement);
        return tdsStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        PreparedStatement_base preparedStatement_base = new PreparedStatement_base(this, string, n, n2);
        this.allStatements.addElement(preparedStatement_base);
        return preparedStatement_base;
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        CallableStatement_base callableStatement_base = new CallableStatement_base(this, string, n, n2);
        this.allStatements.addElement(callableStatement_base);
        return callableStatement_base;
    }

    private void NotImplemented() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection closed");
        }
    }

    synchronized Tds allocateTds(boolean bl) throws SQLException {
        Tds tds;
        try {
            Object object;
            Object object2;
            int n;
            if (bl && this.haveMainTds) {
                n = 0;
            } else {
                n = this.findAnAvailableTds();
                if (n == -1) {
                    object2 = new Tds(this, this.initialProps);
                    object = new TdsInstance((Tds)object2);
                    this.tdsPool.addElement(object);
                    n = this.findAnAvailableTds();
                }
                if (n == -1) {
                    throw new TdsException("Internal Error. Couldn't get Tds instance.");
                }
                if (bl) {
                    object2 = this.tdsPool.remove(n);
                    this.tdsPool.insertElementAt(object2, 0);
                    this.haveMainTds = true;
                }
            }
            object2 = (TdsInstance)this.tdsPool.elementAt(n);
            if (bl) {
                object = ((TdsInstance)object2).tds;
                synchronized (object) {
                }
            }
            if (((TdsInstance)object2).inUse) {
                throw new TdsException("Internal Error. Tds " + n + " is already allocated.");
            }
            ((TdsInstance)object2).inUse = true;
            tds = ((TdsInstance)object2).tds;
            tds.changeSettings(this.autoCommit, this.transactionIsolationLevel);
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        return tds;
    }

    private int findAnAvailableTds() {
        int n = this.haveMainTds ? 1 : 0;
        int n2 = this.tdsPool.size() - 1;
        while (n2 >= n && ((TdsInstance)this.tdsPool.elementAt((int)n2)).inUse) {
            --n2;
        }
        return n2 == 0 && this.haveMainTds ? -1 : n2;
    }

    void freeTds(Tds tds) throws TdsException {
        TdsInstance tdsInstance;
        int n = this.tdsPool.size();
        do {
            tdsInstance = (TdsInstance)this.tdsPool.elementAt(--n);
        } while (n >= 0 && tds != tdsInstance.tds);
        if (n < 0 || !tdsInstance.inUse) {
            throw new TdsException("Tried to free a tds that wasn't in use.");
        }
        tdsInstance.inUse = false;
        tdsInstance.tds.setStatement(null);
    }

    private void commitOrRollback(boolean bl) throws SQLException {
        SQLException sQLException = null;
        int n = 0;
        while (n < this.allStatements.size()) {
            TdsStatement tdsStatement = (TdsStatement)this.allStatements.elementAt(n);
            try {
                tdsStatement.skipToEnd();
                tdsStatement.releaseTds();
            }
            catch (SQLException sQLException2) {
                sQLException2.setNextException(sQLException);
                sQLException = sQLException2;
            }
            ++n;
        }
        n = 0;
        while (n < this.tdsPool.size()) {
            try {
                if (bl) {
                    ((TdsInstance)this.tdsPool.elementAt((int)n)).tds.commit();
                } else {
                    ((TdsInstance)this.tdsPool.elementAt((int)n)).tds.rollback();
                }
            }
            catch (SQLException sQLException3) {
                sQLException = sQLException3;
            }
            ++n;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setHoldability(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

