/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.Columns;

public class TdsResultSetMetaData
implements ResultSetMetaData {
    public static final String cvsVersion = "$Id: TdsResultSetMetaData.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";
    public static final int columnNoNulls = 0;
    public static final int columnNullable = 1;
    public static final int columnNullableUnknown = 2;
    private Columns columnsInfo;

    public TdsResultSetMetaData(Columns columns) {
        this.columnsInfo = columns;
    }

    public String getCatalogName(int n) throws SQLException {
        String string = this.columnsInfo.getCatalog(n);
        return string == null ? "" : string;
    }

    public int getColumnCount() throws SQLException {
        return this.columnsInfo.fakeColumnCount();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return this.columnsInfo.getDisplaySize(n);
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.columnsInfo.getLabel(n);
    }

    public String getColumnName(int n) throws SQLException {
        return this.columnsInfo.getName(n);
    }

    public int getColumnType(int n) throws SQLException {
        switch (this.columnsInfo.getNativeType(n)) {
            case -17: 
            case 36: 
            case 99: 
            case 103: {
                return 1111;
            }
        }
        return this.columnsInfo.getJdbcType(n);
    }

    public String getColumnTypeName(int n) throws SQLException {
        if (this.columnsInfo.isAutoIncrement(n).booleanValue()) {
            return this.getCleanTypeName(n) + " identity";
        }
        return this.getCleanTypeName(n);
    }

    private String getCleanTypeName(int n) throws SQLException {
        switch (this.columnsInfo.getNativeType(n)) {
            case 31: {
                return "void";
            }
            case 34: {
                return "image";
            }
            case 35: {
                return "text";
            }
            case 36: {
                return "uniqueidentifier";
            }
            case 37: {
                return "varbinary";
            }
            case 39: {
                return "varchar";
            }
            case 45: {
                return "binary";
            }
            case 47: {
                return "char";
            }
            case 48: {
                return "tinyint";
            }
            case 50: 
            case 104: {
                return "bit";
            }
            case 52: {
                return "smallint";
            }
            case 56: {
                return "int";
            }
            case 58: {
                return "smalldatetime";
            }
            case 59: {
                return "real";
            }
            case 60: {
                return "money";
            }
            case 61: {
                return "datetime";
            }
            case 62: {
                return "float";
            }
            case 106: {
                return "decimal";
            }
            case 108: {
                return "numeric";
            }
            case 112: {
                return "smallmoney";
            }
            case -17: {
                return "nchar";
            }
            case 99: {
                return "ntext";
            }
            case 103: {
                return "nvarchar";
            }
            case 122: {
                return "smallmoney";
            }
            case 38: {
                switch (this.columnsInfo.getBufferSize(n)) {
                    case 1: {
                        return "tinyint";
                    }
                    case 2: {
                        return "smallint";
                    }
                    case 4: {
                        return "int";
                    }
                }
                break;
            }
            case 109: {
                switch (this.columnsInfo.getBufferSize(n)) {
                    case 4: {
                        return "real";
                    }
                    case 8: {
                        return "float";
                    }
                }
                break;
            }
            case 110: {
                switch (this.columnsInfo.getBufferSize(n)) {
                    case 4: {
                        return "smallmoney";
                    }
                    case 8: {
                        return "money";
                    }
                }
                break;
            }
            case 111: {
                switch (this.columnsInfo.getBufferSize(n)) {
                    case 4: {
                        return "smalldatetime";
                    }
                    case 8: {
                        return "datetime";
                    }
                }
            }
        }
        throw new SQLException("Unknown native type for column " + n + ": " + this.columnsInfo.getNativeType(n));
    }

    public int getPrecision(int n) throws SQLException {
        return this.columnsInfo.getPrecision(n);
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.columnsInfo.getScale(n);
        return n2 < 0 ? 0 : n2;
    }

    public String getSchemaName(int n) throws SQLException {
        String string = this.columnsInfo.getSchema(n);
        return string == null ? "" : string;
    }

    public String getTableName(int n) throws SQLException {
        String string = this.columnsInfo.getTableName(n);
        return string == null ? "" : string;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return this.columnsInfo.isAutoIncrement(n);
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return this.columnsInfo.isCaseSensitive(n);
    }

    public boolean isCurrency(int n) throws SQLException {
        switch (this.columnsInfo.getNativeType(n)) {
            case 60: 
            case 110: 
            case 112: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public int isNullable(int n) throws SQLException {
        return this.columnsInfo.isNullable(n);
    }

    public boolean isReadOnly(int n) throws SQLException {
        return this.columnsInfo.isReadOnly(n);
    }

    public boolean isSearchable(int n) throws SQLException {
        return this.columnsInfo.getNativeType(n) != 34;
    }

    public boolean isSigned(int n) throws SQLException {
        switch (this.columnsInfo.getNativeType(n)) {
            case 52: 
            case 56: 
            case 59: 
            case 60: 
            case 62: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 122: {
                return true;
            }
            case -17: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 58: 
            case 61: 
            case 99: 
            case 103: 
            case 104: 
            case 111: {
                return false;
            }
            case 38: {
                return this.columnsInfo.getBufferSize(n) > 1;
            }
        }
        throw new SQLException("Unknown column type.");
    }

    public boolean isWritable(int n) throws SQLException {
        return this.columnsInfo.isReadOnly(n) == false;
    }

    public String getColumnClassName(int n) throws SQLException {
        switch (this.columnsInfo.getJdbcType(n)) {
            case -7: {
                return "java.lang.Boolean";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: 
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case 7: {
                return "java.lang.Float";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 91: 
            case 92: 
            case 93: {
                return "java.sql.Timestamp";
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
        }
        return "";
    }
}

