/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.sourceforge.jtds.test.DatabaseTestCase;
import net.sourceforge.jtds.util.Logger;

public class CSUnitTest
extends DatabaseTestCase {
    static PrintStream output = null;
    static /* synthetic */ Class class$net$sourceforge$jtds$test$CSUnitTest;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$ResultSet;

    public CSUnitTest(String string) {
        super(string);
        if (output == null) {
            try {
                output = new PrintStream(new FileOutputStream("nul"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("could not create device nul");
            }
        }
    }

    public static void main(String[] stringArray) {
        Logger.setActive(true);
        if (stringArray.length > 0) {
            output = System.out;
            TestSuite testSuite = new TestSuite();
            int n = 0;
            while (n < stringArray.length) {
                testSuite.addTest((Test)new CSUnitTest(stringArray[n]));
                ++n;
            }
            TestRunner.run((Test)testSuite);
        } else {
            TestRunner.run((Class)(class$net$sourceforge$jtds$test$CSUnitTest == null ? (class$net$sourceforge$jtds$test$CSUnitTest = CSUnitTest.class$("net.sourceforge.jtds.test.CSUnitTest")) : class$net$sourceforge$jtds$test$CSUnitTest));
        }
    }

    public void testMaxRows0003() throws Exception {
        this.dropTable("#t0003");
        Statement statement = this.con.createStatement();
        int n = statement.executeUpdate("create table #t0003                (i  integer not null)       ");
        PreparedStatement preparedStatement = this.con.prepareStatement("insert into #t0003 values (?)");
        n = 0;
        int n2 = 1;
        while (n2 <= 100) {
            preparedStatement.setInt(1, n2);
            n += preparedStatement.executeUpdate();
            ++n2;
        }
        Assert.assertTrue((String)("count: " + n + " rowsToAdd: " + 100), (n == 100 ? 1 : 0) != 0);
        preparedStatement.close();
        preparedStatement = this.con.prepareStatement("select i from #t0003 order by i");
        int n3 = 32;
        preparedStatement.setMaxRows(n3);
        Assert.assertTrue((preparedStatement.getMaxRows() == n3 ? 1 : 0) != 0);
        ResultSet resultSet = preparedStatement.executeQuery();
        n = 0;
        while (resultSet.next()) {
            int n4 = resultSet.getInt("i");
            ++n;
        }
        Assert.assertTrue((n == n3 ? 1 : 0) != 0);
    }

    public void testGetAsciiStream0018() throws Exception {
        int n = 0;
        Statement statement = this.con.createStatement();
        String string = "abcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnop";
        String string2 = "0x0123456789abcdeffedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210";
        this.dropTable("#t0018");
        String string3 = "create table #t0018 (                                   mybinary                   binary(5) not null,        myvarbinary                varbinary(4) not null,     mychar                     char(10) not null,         myvarchar                  varchar(8) not null,       mytext                     text not null,             myimage                    image not null,            mynullbinary               binary(3) null,            mynullvarbinary            varbinary(6) null,         mynullchar                 char(10) null,             mynullvarchar              varchar(40) null,          mynulltext                 text null,                 mynullimage                image null)               ";
        n = statement.executeUpdate(string3);
        string3 = "insert into #t0018(        mybinary,                myvarbinary,             mychar,                  myvarchar,               mytext,                  myimage,                 mynullbinary,            mynullvarbinary,         mynullchar,              mynullvarchar,           mynulltext,              mynullimage             )                        values(                   0xffeeddccbb,            0x78,                    'Z',                     '',                      '" + string + "',     " + " " + string2 + ",      " + " null,                   " + " null,                   " + " null,                   " + " null,                   " + " null,                   " + " null                    " + ")";
        n = statement.executeUpdate(string3);
        string3 = "select * from #t0018";
        ResultSet resultSet = statement.executeQuery(string3);
        if (!resultSet.next()) {
            Assert.assertTrue((String)"should get Result", (boolean)false);
        } else {
            output.println("Getting the results");
            output.println("mybinary is " + resultSet.getObject("mybinary"));
            output.println("myvarbinary is " + resultSet.getObject("myvarbinary"));
            output.println("mychar is " + resultSet.getObject("mychar"));
            output.println("myvarchar is " + resultSet.getObject("myvarchar"));
            output.println("mytext is " + resultSet.getObject("mytext"));
            output.println("myimage is " + resultSet.getObject("myimage"));
            output.println("mynullbinary is " + resultSet.getObject("mynullbinary"));
            output.println("mynullvarbinary is " + resultSet.getObject("mynullvarbinary"));
            output.println("mynullchar is " + resultSet.getObject("mynullchar"));
            output.println("mynullvarchar is " + resultSet.getObject("mynullvarchar"));
            output.println("mynulltext is " + resultSet.getObject("mynulltext"));
            output.println("mynullimage is " + resultSet.getObject("mynullimage"));
        }
    }

    public void testMoneyHandling0019() throws Exception {
        Statement statement = null;
        Object var2_2 = null;
        Object var3_3 = null;
        BigDecimal[] bigDecimalArray = new BigDecimal[]{new BigDecimal("922337203685477.5807"), new BigDecimal("-922337203685477.5807"), new BigDecimal("1.00"), new BigDecimal("0.00"), new BigDecimal("-1.00")};
        BigDecimal[] bigDecimalArray2 = new BigDecimal[]{new BigDecimal("214748.3647"), new BigDecimal("-214748.3648"), new BigDecimal("1.00"), new BigDecimal("0.00"), new BigDecimal("-1.00")};
        if (bigDecimalArray2.length != bigDecimalArray.length) {
            throw new SQLException("Must have same number of elements in money and smallmoney");
        }
        statement = this.con.createStatement();
        this.dropTable("#t0019");
        statement.executeUpdate("create table #t0019 (                       i               integer primary key,     mymoney         money not null,          mysmallmoney    smallmoney not null)   ");
        int n = 0;
        while (n < bigDecimalArray.length) {
            statement.executeUpdate("insert into #t0019 values (" + n + ", " + bigDecimalArray[n] + ",   " + bigDecimalArray2[n] + ")         ");
            ++n;
        }
        ResultSet resultSet = statement.executeQuery("select * from #t0019 order by i");
        n = 0;
        while (resultSet.next()) {
            BigDecimal bigDecimal = (BigDecimal)resultSet.getObject("mymoney");
            BigDecimal bigDecimal2 = (BigDecimal)resultSet.getObject("mysmallmoney");
            bigDecimalArray[n].setScale(2, 1);
            bigDecimalArray2[n].setScale(2, 1);
            Assert.assertTrue((boolean)bigDecimal.equals(bigDecimalArray[n].setScale(2, 1)));
            Assert.assertTrue((boolean)bigDecimal2.equals(bigDecimalArray2[n].setScale(2, 1)));
            output.println(bigDecimal + ", " + bigDecimal2);
            ++n;
        }
    }

    public void testDataTypes0027() throws Exception {
        output.println("Test all the SQLServer datatypes in Statement\nand PreparedStatement using the preferred getXXX()\ninstead of getObject like #t0017.java does.");
        output.println("!!!Note- This test is not fully implemented yet!!!");
        Statement statement = this.con.createStatement();
        statement.execute("set dateformat ymd");
        this.dropTable("#t0027");
        String string = "create table #t0027 (                                   mybinary                   binary(5) not null,        myvarbinary                varbinary(4) not null,     mychar                     char(10) not null,         myvarchar                  varchar(8) not null,       mydatetime                 datetime not null,         mysmalldatetime            smalldatetime not null,    mydecimal10_3              decimal(10,3) not null,    mynumeric5_4               numeric (5,4) not null,    myfloat6                   float(6) not null,         myfloat14                  float(6) not null,         myreal                     real not null,             myint                      int not null,              mysmallint                 smallint not null,         mytinyint                  tinyint not null,          mymoney                    money not null,            mysmallmoney               smallmoney not null,       mybit                      bit not null,              mytimestamp                timestamp not null,        mytext                     text not null,             myimage                    image not null,            mynullbinary               binary(3) null,           mynullvarbinary            varbinary(6) null,        mynullchar                 char(10) null,             mynullvarchar              varchar(40) null,          mynulldatetime             datetime null,             mynullsmalldatetime        smalldatetime null,        mynulldecimal10_3          decimal(10,3) null,        mynullnumeric15_10         numeric(15,10) null,       mynullfloat6               float(6) null,             mynullfloat14              float(14) null,            mynullreal                 real null,                 mynullint                  int null,                  mynullsmallint             smallint null,             mynulltinyint              tinyint null,              mynullmoney                money null,                mynullsmallmoney           smallmoney null,           mynulltext                 text null,                 mynullimage                image null)               ";
        int n = statement.executeUpdate(string);
        string = "insert into #t0027                 (mybinary,                       myvarbinary,                    mychar,                         myvarchar,                      mydatetime,                     mysmalldatetime,                mydecimal10_3,                  mynumeric5_4,                 myfloat6,                       myfloat14,                      myreal,                         myint,                          mysmallint,                     mytinyint,                      mymoney,                        mysmallmoney,                   mybit,                          mytimestamp,                    mytext,                         myimage,                        mynullbinary,                   mynullvarbinary,                mynullchar,                     mynullvarchar,                  mynulldatetime,                 mynullsmalldatetime,            mynulldecimal10_3,              mynullnumeric15_10,             mynullfloat6,                   mynullfloat14,                  mynullreal,                     mynullint,                      mynullsmallint,                 mynulltinyint,                  mynullmoney,                    mynullsmallmoney,               mynulltext,                     mynullimage)                  values                            (0x1213141516,                   0x1718191A,                     '1234567890',                   '12345678',                     '19991015 21:29:59.01',         '19991015 20:45',               1234567.089,                    1.2345,                         65.4321,                        1.123456789,                    987654321.0,                    4097,                           4094,                           200,                            19.95,                          9.97,                           1,                              null,                           'abcdefg',                      0x0AAABB,                       0x123456,                       0xAB,                           'z',                            'zyx',                          '1976-07-04 12:00:00.04',       '2000-02-29 13:46',              1.23,                           7.1234567891,                   987654,                         0,                              -1.1,                           -10,                            126,                            7,                              -19999.00,                      -9.97,                          '1234',                         0x1200340056)              ";
        n = statement.executeUpdate(string);
        string = "select * from #t0027";
        ResultSet resultSet = statement.executeQuery(string);
        Assert.assertTrue((boolean)resultSet.next());
        output.println("mybinary is " + resultSet.getObject("mybinary"));
        output.println("myvarbinary is " + resultSet.getObject("myvarbinary"));
        output.println("mychar is " + resultSet.getString("mychar"));
        output.println("myvarchar is " + resultSet.getString("myvarchar"));
        output.println("mydatetime is " + resultSet.getTimestamp("mydatetime"));
        output.println("mysmalldatetime is " + resultSet.getTimestamp("mysmalldatetime"));
        output.println("mydecimal10_3 is " + resultSet.getObject("mydecimal10_3"));
        output.println("mynumeric5_4 is " + resultSet.getObject("mynumeric5_4"));
        output.println("myfloat6 is " + resultSet.getDouble("myfloat6"));
        output.println("myfloat14 is " + resultSet.getDouble("myfloat14"));
        output.println("myreal is " + resultSet.getDouble("myreal"));
        output.println("myint is " + resultSet.getInt("myint"));
        output.println("mysmallint is " + resultSet.getShort("mysmallint"));
        output.println("mytinyint is " + resultSet.getByte("mytinyint"));
        output.println("mymoney is " + resultSet.getObject("mymoney"));
        output.println("mysmallmoney is " + resultSet.getObject("mysmallmoney"));
        output.println("mybit is " + resultSet.getObject("mybit"));
        output.println("mytimestamp is " + resultSet.getObject("mytimestamp"));
        output.println("mytext is " + resultSet.getObject("mytext"));
        output.println("myimage is " + resultSet.getObject("myimage"));
        output.println("mynullbinary is " + resultSet.getObject("mynullbinary"));
        output.println("mynullvarbinary is " + resultSet.getObject("mynullvarbinary"));
        output.println("mynullchar is " + resultSet.getString("mynullchar"));
        output.println("mynullvarchar is " + resultSet.getString("mynullvarchar"));
        output.println("mynulldatetime is " + resultSet.getTimestamp("mynulldatetime"));
        output.println("mynullsmalldatetime is " + resultSet.getTimestamp("mynullsmalldatetime"));
        output.println("mynulldecimal10_3 is " + resultSet.getObject("mynulldecimal10_3"));
        output.println("mynullnumeric15_10 is " + resultSet.getObject("mynullnumeric15_10"));
        output.println("mynullfloat6 is " + resultSet.getDouble("mynullfloat6"));
        output.println("mynullfloat14 is " + resultSet.getDouble("mynullfloat14"));
        output.println("mynullreal is " + resultSet.getDouble("mynullreal"));
        output.println("mynullint is " + resultSet.getInt("mynullint"));
        output.println("mynullsmallint is " + resultSet.getShort("mynullsmallint"));
        output.println("mynulltinyint is " + resultSet.getByte("mynulltinyint"));
        output.println("mynullmoney is " + resultSet.getObject("mynullmoney"));
        output.println("mynullsmallmoney is " + resultSet.getObject("mynullsmallmoney"));
        output.println("mynulltext is " + resultSet.getObject("mynulltext"));
        output.println("mynullimage is " + resultSet.getObject("mynullimage"));
    }

    public void testCallStoredProcedures0028() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = statement.execute("EXEC sp_who");
        output.println("execute(EXEC sp_who) returned: " + bl);
        int n4 = statement.getUpdateCount();
        while (bl || n4 != -1) {
            if (bl) {
                ++n;
                resultSet = statement.getResultSet();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n5 = resultSetMetaData.getColumnCount();
                output.println("columnCount: " + Integer.toString(n5));
                int n6 = 1;
                while (n6 <= n5) {
                    output.println(Integer.toString(n6) + ": " + resultSetMetaData.getColumnName(n6));
                    ++n6;
                }
                while (resultSet.next()) {
                    ++n2;
                    int n7 = 1;
                    while (n7 <= n5) {
                        output.println(Integer.toString(n7) + ": " + resultSet.getString(n7));
                        ++n7;
                    }
                }
            } else {
                n3 += n4;
                output.println("UpdateCount: " + Integer.toString(n4));
            }
            bl = statement.getMoreResults();
            n4 = statement.getUpdateCount();
        }
        output.println("resultSetCount: " + n);
        output.println("Total rowCount: " + n2);
        output.println("Number of updates: " + n3);
        Assert.assertTrue((n2 >= 1 && n3 == 0 && n == 1 ? 1 : 0) != 0);
    }

    public void testxx0029() throws Exception {
        int n;
        boolean bl;
        Statement statement = this.con.createStatement();
        boolean bl2 = false;
        ResultSet resultSet = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        output.println("before execute DROP PROCEDURE");
        try {
            bl = statement.execute("DROP PROCEDURE #t0029_p1");
            n = statement.getUpdateCount();
            do {
                output.println("DROP PROCEDURE isResultSet: " + bl);
                output.println("DROP PROCEDURE updateCount: " + n);
                bl = statement.getMoreResults();
            } while ((n = statement.getUpdateCount()) != -1 && !bl || bl);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            bl = statement.execute("DROP PROCEDURE #t0029_p2");
            n = statement.getUpdateCount();
            do {
                output.println("DROP PROCEDURE isResultSet: " + bl);
                output.println("DROP PROCEDURE updateCount: " + n);
                bl = statement.getMoreResults();
            } while ((n = statement.getUpdateCount()) != -1 && !bl || bl);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.dropTable("#t0029_t1");
        bl = statement.execute(" create table #t0029_t1                         (t1 datetime not null,                        t2 datetime null,                            t3 smalldatetime not null,                   t4 smalldatetime null,                       t5 text null)                             ");
        n = statement.getUpdateCount();
        do {
            output.println("CREATE TABLE isResultSet: " + bl);
            output.println("CREATE TABLE updateCount: " + n);
            bl = statement.getMoreResults();
        } while ((n = statement.getUpdateCount()) != -1 && !bl || bl);
        bl = statement.execute("CREATE PROCEDURE #t0029_p1 AS                 insert into #t0029_t1 values                 ('1999-01-07', '1998-09-09 15:35:05',        getdate(), '1998-09-09 15:35:00', null)      update #t0029_t1 set t1='1999-01-01'          insert into #t0029_t1 values                 ('1999-01-08', '1998-09-09 15:35:05',        getdate(), '1998-09-09 15:35:00','456')      update #t0029_t1 set t2='1999-01-02'         declare @ptr varbinary(16)                   select @ptr=textptr(t5) from #t0029_t1         where t1='1999-01-08'                      writetext #t0029_t1.t5 @ptr with log '123'  ");
        n = statement.getUpdateCount();
        do {
            output.println("CREATE PROCEDURE isResultSet: " + bl);
            output.println("CREATE PROCEDURE updateCount: " + n);
            bl = statement.getMoreResults();
        } while ((n = statement.getUpdateCount()) != -1 && !bl || bl);
        bl = statement.execute("CREATE PROCEDURE #t0029_p2 AS                 set nocount on  EXEC #t0029_p1                               SELECT * FROM #t0029_t1                     ");
        n = statement.getUpdateCount();
        do {
            output.println("CREATE PROCEDURE isResultSet: " + bl);
            output.println("CREATE PROCEDURE updateCount: " + n);
            bl = statement.getMoreResults();
        } while ((n = statement.getUpdateCount()) != -1 && !bl || bl);
        bl = statement.execute("EXEC  #t0029_p2  ");
        output.println("execute(EXEC #t0029_p2) returned: " + bl);
        n = statement.getUpdateCount();
        while (bl || n != -1) {
            if (bl) {
                ++n2;
                resultSet = statement.getResultSet();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n5 = resultSetMetaData.getColumnCount();
                output.println("columnCount: " + Integer.toString(n5));
                int n6 = 1;
                while (n6 <= n5) {
                    output.println(Integer.toString(n6) + ": " + resultSetMetaData.getColumnName(n6));
                    ++n6;
                }
                while (resultSet.next()) {
                    ++n3;
                    int n7 = 1;
                    while (n7 <= n5) {
                        output.println(Integer.toString(n7) + ": " + resultSet.getString(n7));
                        ++n7;
                    }
                }
            } else {
                n4 += n;
                output.println("UpdateCount: " + Integer.toString(n));
            }
            bl = statement.getMoreResults();
            n = statement.getUpdateCount();
        }
        output.println("resultSetCount: " + n2);
        output.println("Total rowCount: " + n3);
        output.println("Number of updates: " + n4);
        Assert.assertTrue((n2 == 1 && n3 == 2 && n4 == 0 ? 1 : 0) != 0);
    }

    public void testDataTypesByResultSetMetaData0030() throws Exception {
        boolean bl = true;
        Statement statement = this.con.createStatement();
        boolean bl2 = false;
        String string = "select  convert(tinyint, 2),   convert(smallint, 5)  ";
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            bl = false;
        } else {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData.getColumnType(1) != -6) {
                output.println("tinyint column was read as " + resultSetMetaData.getColumnType(1));
                bl = false;
            }
            if (resultSetMetaData.getColumnType(2) != 5) {
                output.println("smallint column was read as " + resultSetMetaData.getColumnType(2));
                bl = false;
            }
            if (resultSet.getInt(1) != 2) {
                output.println("Bogus value read for tinyint");
                bl = false;
            }
            if (resultSet.getInt(2) != 5) {
                output.println("Bogus value read for smallint");
                bl = false;
            }
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testTextColumns0031() throws Exception {
        Statement statement = this.con.createStatement();
        boolean bl = true;
        output.println("Starting test #t0031-  test text columns");
        int n = 0;
        this.dropTable("#t0031");
        n = statement.executeUpdate("create table #t0031                  (t_nullable      text null,        t_notnull       text not null,    i               int not null)  ");
        output.println("Creating table affected " + n + " rows");
        statement.executeUpdate("insert into #t0031 values(null, '',   1)");
        statement.executeUpdate("insert into #t0031 values(null, 'b1', 2)");
        statement.executeUpdate("insert into #t0031 values('',   '',   3)");
        statement.executeUpdate("insert into #t0031 values('',   'b2', 4)");
        statement.executeUpdate("insert into #t0031 values('a1', '',   5)");
        statement.executeUpdate("insert into #t0031 values('a2', 'b3', 6)");
        ResultSet resultSet = statement.executeQuery("select * from #t0031  order by i ");
        if (!resultSet.next()) {
            throw new SQLException("Failed");
        }
        bl = bl && resultSet.getString(1) == null;
        bl = bl && resultSet.getString(2).equals("");
        boolean bl2 = bl = bl && resultSet.getInt(3) == 1;
        if (!resultSet.next()) {
            throw new SQLException("Failed");
        }
        bl = bl && resultSet.getString(1) == null;
        bl = bl && resultSet.getString(2).equals("b1");
        boolean bl3 = bl = bl && resultSet.getInt(3) == 2;
        if (!resultSet.next()) {
            throw new SQLException("Failed");
        }
        bl = bl && resultSet.getString(1).equals("");
        bl = bl && resultSet.getString(2).equals("");
        boolean bl4 = bl = bl && resultSet.getInt(3) == 3;
        if (!resultSet.next()) {
            throw new SQLException("Failed");
        }
        bl = bl && resultSet.getString(1).equals("");
        bl = bl && resultSet.getString(2).equals("b2");
        boolean bl5 = bl = bl && resultSet.getInt(3) == 4;
        if (!resultSet.next()) {
            throw new SQLException("Failed");
        }
        bl = bl && resultSet.getString(1).equals("a1");
        bl = bl && resultSet.getString(2).equals("");
        boolean bl6 = bl = bl && resultSet.getInt(3) == 5;
        if (!resultSet.next()) {
            throw new SQLException("Failed");
        }
        bl = bl && resultSet.getString(1).equals("a2");
        bl = bl && resultSet.getString(2).equals("b3");
        bl = bl && resultSet.getInt(3) == 6;
        Assert.assertTrue((boolean)bl);
    }

    public void testSpHelpSysUsers0032() throws Exception {
        Statement statement = this.con.createStatement();
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        output.println("Starting test #t0032-  test sp_help sysusers");
        boolean bl3 = false;
        boolean bl4 = statement.execute("sp_help sysusers");
        output.println("Executed the statement.  rc is " + bl4);
        do {
            if (bl4) {
                output.println("About to call getResultSet");
                ResultSet resultSet = statement.getResultSet();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                n = 0;
                while (resultSet.next()) {
                    int n2 = 1;
                    while (n2 <= resultSetMetaData.getColumnCount()) {
                        output.print(resultSet.getString(n2) + "\t");
                        ++n2;
                    }
                    output.println("");
                }
                output.println("Done processing the result set");
            } else {
                output.println("About to call getUpdateCount()");
                n = statement.getUpdateCount();
                output.println("Updated " + n + " rows");
            }
            output.println("About to call getMoreResults()");
        } while (!(bl2 = !(bl4 = statement.getMoreResults()) && n == -1));
        Assert.assertTrue((boolean)bl);
    }

    static String longString(char c) {
        String string = "";
        int n = 0;
        while (n < 255) {
            string = string + c;
            ++n;
        }
        return string;
    }

    public void testExceptionByUpdate0033() throws Exception {
        boolean bl;
        Statement statement = this.con.createStatement();
        output.println("Starting test #t0033-  make sure Statement.executeUpdate() throws exception");
        try {
            bl = false;
            statement.executeUpdate("I am sure this is an error");
        }
        catch (SQLException sQLException) {
            output.println("The exception is " + sQLException.getMessage());
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testInsertConflict0049() throws Exception {
        PreparedStatement preparedStatement;
        String string;
        int n;
        Statement statement;
        block2: {
            statement = this.con.createStatement();
            n = 0;
            this.dropTable("#t0049b");
            this.dropTable("#t0049a");
            string = "create table #t0049a(                      a integer identity(1,1) primary key,    b char    not null)";
            n = statement.executeUpdate(string);
            output.println("Creating table affected " + n + " rows");
            string = "create table #t0049b(                      a integer not null,                     c char    not null,                     foreign key (a) references #t0049a(a)) ";
            n = statement.executeUpdate(string);
            output.println("Creating table affected " + n + " rows");
            string = "insert into #t0049b (a, c) values (?, ?)";
            preparedStatement = this.con.prepareStatement(string);
            try {
                preparedStatement.setInt(1, 1);
                preparedStatement.setString(2, "a");
                n = preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith("INSERT statement conflicted")) break block2;
                throw sQLException;
            }
        }
        preparedStatement.close();
        n = statement.executeUpdate("insert into #t0049a (b) values ('a')");
        output.println("insert affected " + n + " rows");
        preparedStatement = this.con.prepareStatement(string);
        preparedStatement.setInt(1, 1);
        preparedStatement.setString(2, "a");
        n = preparedStatement.executeUpdate();
    }

    public void testxx0050() throws Exception {
        PreparedStatement preparedStatement;
        String string;
        int n;
        boolean bl;
        Statement statement;
        block5: {
            block4: {
                statement = this.con.createStatement();
                bl = true;
                n = 0;
                try {
                    statement.executeUpdate("drop procedure p0050");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage().startsWith("Cannot drop the procedure 'p0050', because it does")) break block4;
                    throw sQLException;
                }
            }
            this.dropTable("#t0050b");
            this.dropTable("#t0050a");
            string = "create table #t0050a(                      a integer identity(1,1) primary key,    b char    not null)";
            n = statement.executeUpdate(string);
            output.println("Creating table affected " + n + " rows");
            string = "create table #t0050b(                      a integer not null,                     c char    not null,                     foreign key (a) references #t0050a(a)) ";
            n = statement.executeUpdate(string);
            output.println("Creating table affected " + n + " rows");
            string = "create procedure #p0050 (@a integer, @c char) as    insert into #t0050b (a, c) values (@a, @c)    ";
            n = statement.executeUpdate(string);
            output.println("Creating procedure affected " + n + " rows");
            string = "exec #p0050 ?, ?";
            preparedStatement = this.con.prepareStatement(string);
            try {
                preparedStatement.setInt(1, 1);
                preparedStatement.setString(2, "a");
                n = preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith("INSERT statement conflicted")) break block5;
                throw sQLException;
            }
        }
        preparedStatement.close();
        n = statement.executeUpdate("insert into #t0050a (b) values ('a')");
        output.println("insert affected " + n + " rows");
        preparedStatement = this.con.prepareStatement(string);
        preparedStatement.setInt(1, 1);
        preparedStatement.setString(2, "a");
        n = preparedStatement.executeUpdate();
        Assert.assertTrue((boolean)bl);
    }

    public void testxx0051() throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        Statement statement = this.con.createStatement();
        try {
            String[] stringArray = new String[]{"TABLE"};
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, "%", "t%", stringArray);
            while (resultSet.next()) {
                output.println("Table " + resultSet.getString(3));
                output.println("  catalog " + resultSet.getString(1));
                output.println("  schema  " + resultSet.getString(2));
                output.println("  name    " + resultSet.getString(3));
                output.println("  type    " + resultSet.getString(4));
                output.println("  remarks " + resultSet.getString(5));
            }
        }
        catch (SQLException sQLException) {
            bl = false;
            output.println("Exception caught.  " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testxx0055() throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        Statement statement = this.con.createStatement();
        try {
            String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"};
            String[] stringArray2 = new String[]{"TABLE"};
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, "%", "t%", stringArray2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData.getColumnCount() != 5 && bl) {
                bl = false;
                output.println("Bad column count.  Should be 5, was " + resultSetMetaData.getColumnCount());
            }
            int n = 0;
            while (bl && n < stringArray.length) {
                if (!resultSetMetaData.getColumnName(n + 1).equals(stringArray[n])) {
                    bl = false;
                    output.println("Bad name for column " + (n + 1) + ".  " + "Was " + resultSetMetaData.getColumnName(n + 1) + ", expected " + stringArray[n]);
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            bl = false;
            output.println("Exception caught.  " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testxx0052() throws Exception {
        boolean bl = true;
        byte[] byArray = new byte[]{71, 73, 70, 56, 57, 97, 10, 0, 10, 0, -128, -1, 0, -41, 61, 27, 0, 0, 0, 44, 0, 0, 0, 0, 10, 0, 10, 0, 0, 2, 8, -124, -113, -87, -53, -19, 15, 99, 43, 0, 59};
        int n = 0;
        Statement statement = this.con.createStatement();
        this.dropTable("#t0052");
        try {
            String string = "create table #t0052 (                                   myvarchar                varchar(2000) not null,      myvarbinary              varbinary(2000) not null)   ";
            statement.executeUpdate(string);
            string = "insert into #t0052                 (myvarchar,                      myvarbinary)                  values                           ('This is a test with german umlauts \u00e4\u00f6\u00fc',    0x4749463839610A000A0080FF00D73D1B0000002C000000000A000A00000208848FA9CBED0F632B003B  )";
            statement.executeUpdate(string);
            string = "select * from #t0052";
            ResultSet resultSet = statement.executeQuery(string);
            if (!resultSet.next()) {
                bl = false;
            } else {
                int n2;
                int n3;
                output.println("Testing getAsciiStream()");
                InputStream inputStream = resultSet.getAsciiStream("myvarchar");
                String string2 = "This is a test with german umlauts ???";
                byte[] byArray2 = new byte[string2.length()];
                n = inputStream.read(byArray2);
                if (n == string2.length()) {
                    n3 = 0;
                    while (n3 < string2.length()) {
                        if (string2.charAt(n3) != byArray2[n3]) {
                            bl = false;
                            output.println("Expected " + string2.charAt(n3) + " but was " + byArray2[n3]);
                        }
                        ++n3;
                    }
                } else {
                    bl = false;
                    output.println("Premature end in getAsciiStream(\"myvarchar\") " + n + " instead of " + string2.length());
                }
                inputStream.close();
                inputStream = resultSet.getAsciiStream(2);
                byArray2 = new byte[41];
                n = inputStream.read(byArray2);
                if (n == 41) {
                    n3 = 0;
                    while (n3 < 41) {
                        if (byArray2[n3] != (byArray2[n3] & 0x7F)) {
                            bl = false;
                            output.println("Non ASCII characters in getAsciiStream");
                            break;
                        }
                        ++n3;
                    }
                } else {
                    bl = false;
                    output.println("Premature end in getAsciiStream(1) " + n + " instead of 41");
                }
                inputStream.close();
                output.println("Testing getUnicodeStream()");
                Reader reader = resultSet.getCharacterStream("myvarchar");
                string2 = "This is a test with german umlauts \u00e4\u00f6\u00fc";
                char[] cArray = new char[string2.length()];
                n = reader.read(cArray, 0, string2.length());
                if (n == string2.length()) {
                    String string3 = new String(cArray);
                    if (!string2.equals(string3)) {
                        bl = false;
                        output.println("Expected " + string2 + " but was " + string3);
                    }
                } else {
                    bl = false;
                    output.println("Premature end in getUnicodeStream(\"myvarchar\") " + n + " instead of " + string2.length());
                }
                reader.close();
                reader = resultSet.getCharacterStream(2);
                reader.close();
                output.println("Testing getBinaryStream()");
                inputStream = resultSet.getBinaryStream("myvarchar");
                inputStream.close();
                inputStream = resultSet.getBinaryStream(2);
                n = 0;
                byArray2 = new byte[byArray.length];
                do {
                    if ((n2 = inputStream.read(byArray2, n, byArray.length - n)) != -1) continue;
                    bl = false;
                    output.println("Premature end in  getBinaryStream(2) " + n + " instead of " + byArray.length);
                    break;
                } while ((n += n2) < byArray.length);
                n3 = 0;
                while (n3 < n) {
                    if (byArray2[n3] != byArray[n3]) {
                        bl = false;
                        output.println("Expected " + byArray2[n3] + "but was " + byArray[n3]);
                        break;
                    }
                    ++n3;
                }
                inputStream.close();
                output.println("Testing getCharacterStream()");
                try {
                    Method method = (class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = CSUnitTest.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getMethod("getCharacterStream", class$java$lang$String == null ? (class$java$lang$String = CSUnitTest.class$("java.lang.String")) : class$java$lang$String);
                    Method method2 = (class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = CSUnitTest.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getMethod("getCharacterStream", Integer.TYPE);
                    reader = (Reader)method.invoke((Object)resultSet, "myvarchar");
                    string2 = "This is a test with german umlauts \u00e4\u00f6\u00fc";
                    cArray = new char[string2.length()];
                    n = reader.read(cArray, 0, string2.length());
                    if (n == string2.length()) {
                        String string4 = new String(cArray);
                        if (!string2.equals(string4)) {
                            bl = false;
                            output.println("Expected " + string2 + " but was " + string4);
                        }
                    } else {
                        bl = false;
                        output.println("Premature end in getCharacterStream(\"myvarchar\") " + n + " instead of " + string2.length());
                    }
                    reader.close();
                    reader = (Reader)method2.invoke((Object)resultSet, new Integer(2));
                    reader.close();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    output.println("JDBC 2 only");
                }
                catch (Throwable throwable) {
                    bl = false;
                    output.println("Exception: " + throwable.getMessage());
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            bl = false;
            output.println("Exception caught.  " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testxx0053() throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        Statement statement = this.con.createStatement();
        this.dropTable("#t0053");
        try {
            String string = "create table #t0053 (                                   myvarchar                varchar(2000)  not null,     mynchar                  nchar(2000)    not null,     mynvarchar               nvarchar(2000) not null,     myntext                  ntext          not null      )   ";
            statement.executeUpdate(string);
            string = "insert into #t0053                 (myvarchar,                      mynchar,                        mynvarchar,                     myntext)                      values                           ('AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA',        '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc',                     '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc',                     '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc'                     )";
            statement.executeUpdate(string);
            string = "select * from #t0053";
            ResultSet resultSet = statement.executeQuery(string);
            if (!resultSet.next()) {
                bl = false;
            } else {
                System.err.print("Testing varchars > 255 chars: ");
                String string2 = resultSet.getString(1);
                if (string2.length() == 270) {
                    System.err.println("passed");
                } else {
                    System.err.println("failed");
                    bl = false;
                }
                System.err.print("Testing nchar: ");
                string2 = resultSet.getString(2);
                if (string2.length() == 2000 && "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc".equals(string2.trim())) {
                    System.err.println("passed");
                } else {
                    System.err.print("failed, got '");
                    System.err.print(string2.trim());
                    System.err.println("' instead of '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc'");
                    bl = false;
                }
                System.err.print("Testing nvarchar: ");
                string2 = resultSet.getString(3);
                if (string2.length() == 6 && "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc".equals(string2)) {
                    System.err.println("passed");
                } else {
                    System.err.print("failed, got '");
                    System.err.print(string2);
                    System.err.println("' instead of '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc'");
                    bl = false;
                }
                System.err.print("Testing ntext: ");
                string2 = resultSet.getString(4);
                if (string2.length() == 6 && "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc".equals(string2)) {
                    System.err.println("passed");
                } else {
                    System.err.print("failed, got '");
                    System.err.print(string2);
                    System.err.println("' instead of '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc'");
                    bl = false;
                }
            }
        }
        catch (SQLException sQLException) {
            bl = false;
            output.println("Exception caught.  " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testxx005x() throws Exception {
        long l;
        boolean bl = true;
        output.println("test getting a DECIMAL as a long from the database.");
        boolean bl2 = false;
        Statement statement = this.con.createStatement();
        ResultSet resultSet = statement.executeQuery("select convert(DECIMAL(4,0), 0)");
        if (!resultSet.next()) {
            bl = false;
        } else {
            l = resultSet.getLong(1);
            if (l != 0L) {
                bl = false;
            }
        }
        resultSet = statement.executeQuery("select convert(DECIMAL(4,0), 1)");
        if (!resultSet.next()) {
            bl = false;
        } else {
            l = resultSet.getLong(1);
            if (l != 1L) {
                bl = false;
            }
        }
        resultSet = statement.executeQuery("select convert(DECIMAL(4,0), -1)");
        if (!resultSet.next()) {
            bl = false;
        } else {
            l = resultSet.getLong(1);
            if (l != -1L) {
                bl = false;
            }
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testxx0057() throws Exception {
        output.println("test putting a zero length string into a parameter");
        int n = 0;
        Statement statement = this.con.createStatement();
        this.dropTable("#t0057");
        n = statement.executeUpdate("create table #t0057           (a varchar(10) not null,   b char(10)    not null) ");
        output.println("Creating table affected " + n + " rows");
        PreparedStatement preparedStatement = this.con.prepareStatement("insert into #t0057 values (?, ?)");
        preparedStatement.setString(1, "");
        preparedStatement.setString(2, "");
        n = preparedStatement.executeUpdate();
        output.println("Added " + n + " rows");
        if (n != 1) {
            output.println("Failed to add rows");
            Assert.fail();
        } else {
            preparedStatement.close();
            preparedStatement = this.con.prepareStatement("select a, b from #t0057");
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                output.println("Couldn't read rows from table.");
                Assert.fail();
            } else {
                output.println("a is |" + resultSet.getString("a") + "|");
                output.println("b is |" + resultSet.getString("b") + "|");
                Assert.assertEquals((Object)"", (Object)resultSet.getString("a"));
                Assert.assertEquals((Object)"          ", (Object)resultSet.getString("b"));
            }
        }
    }

    public void testxx0059() throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        Statement statement = this.con.createStatement();
        try {
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            ResultSet resultSet = databaseMetaData.getSchemas();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assert.assertTrue((resultSetMetaData.getColumnCount() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)resultSetMetaData.getColumnName(1).equals("TABLE_SCHEM"));
            while (resultSet.next()) {
                output.println("schema " + resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            output.println("Exception caught.  " + sQLException.getMessage());
            sQLException.printStackTrace();
            Assert.fail();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

