/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.common.encryption;

import com.aspire.common.encryption.DESLimit;
import com.aspire.common.encryption.StringEncode;
import com.sun.crypto.provider.SunJCE;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DES {
    private Cipher ecipher;
    private Cipher dcipher;
    private final String ALGORITHM = "DES";
    private final String TRANSFORMATION = "DES/ECB/NoPadding";
    private SecretKey secretKey = null;
    private DESLimit desLimit = null;

    public DES(String string) {
        try {
            byte[] byArray = StringEncode.hexStr2ByteArr(string);
            this.init(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DES(byte[] byArray) {
        this.init(byArray);
    }

    public DES(String string, DESLimit dESLimit) {
        this.desLimit = dESLimit;
        try {
            byte[] byArray = StringEncode.hexStr2ByteArr(string);
            this.init(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DES(byte[] byArray, DESLimit dESLimit) {
        this.desLimit = dESLimit;
        this.init(byArray);
    }

    private void init(byte[] byArray) {
        try {
            Security.addProvider(new SunJCE());
            DESKeySpec dESKeySpec = new DESKeySpec(byArray);
            this.secretKey = SecretKeyFactory.getInstance("DES", "SunJCE").generateSecret(dESKeySpec);
            this.ecipher = Cipher.getInstance("DES/ECB/NoPadding");
            this.dcipher = Cipher.getInstance("DES/ECB/NoPadding");
            this.ecipher.init(1, this.secretKey);
            this.dcipher.init(2, this.secretKey);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
    }

    private byte[] encrypt(byte[] byArray) throws Exception {
        return this.ecipher.doFinal(byArray);
    }

    public String encrypt(String string) throws Exception {
        if (this.desLimit == null || !this.desLimit.hasNoLimits()) {
            throw new Exception("Sorry, encrypt is not supported.");
        }
        byte[] byArray = this.crypt(string.getBytes(), 1);
        return StringEncode.byteArr2HexStr(byArray);
    }

    private byte[] crypt(byte[] byArray, int n) throws Exception {
        int n2;
        int n3;
        byte[] byArray2;
        int n4 = byArray.length;
        if (n4 % 8 != 0) {
            byArray2 = new byte[8 * (1 + n4 / 8)];
            n3 = 0;
            while (n3 < n4) {
                byArray2[n3] = byArray[n3];
                ++n3;
            }
            n2 = n4;
            while (n2 < byArray2.length) {
                byArray2[n2] = 0;
                ++n2;
            }
            byArray = byArray2;
        }
        byArray2 = null;
        if (n == 1) {
            byArray2 = this.encrypt(byArray);
        } else if (n == 2) {
            byArray2 = this.decrypt(byArray);
            n3 = 0;
            n2 = byArray2.length - 1;
            while (n2 >= 0) {
                if (byArray2[n2] != 0) break;
                ++n3;
                --n2;
            }
            if (n3 > 0) {
                byte[] byArray3 = new byte[byArray2.length - n3];
                int n5 = 0;
                while (n5 < byArray3.length) {
                    byArray3[n5] = byArray2[n5];
                    ++n5;
                }
                byArray2 = byArray3;
            }
        }
        return byArray2;
    }

    private byte[] decrypt(byte[] byArray) throws Exception {
        return this.dcipher.doFinal(byArray);
    }

    public String decrypt(String string) throws Exception {
        byte[] byArray = StringEncode.hexStr2ByteArr(string);
        return new String(this.crypt(byArray, 2));
    }
}

