/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver.tds;

import com.microsoft.jdbc.base.BaseWarnings;
import com.microsoft.jdbc.sqlserver.tds.TDSConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSRPCParameter;
import com.microsoft.jdbc.sqlserver.tds.TDSRequest;
import com.microsoft.util.UtilByteOrderedDataReader;
import com.microsoft.util.UtilByteOrderedDataWriter;
import com.microsoft.util.UtilDebug;
import com.microsoft.util.UtilException;
import java.sql.SQLException;
import java.util.Vector;

public class TDSRPCRequest
extends TDSRequest {
    private static String footprint = "$Revision:   1.49.1.2  $";
    public static final short PROCESS_NORMAL = 0;
    public static final short PROCESS_TIL_ROW = 2;
    public static final short PROCESS_TIL_END = 1;
    protected int processMode;
    protected int RPCOptions;
    protected String procedureName;
    protected Vector parameters;
    private int numReturnedParameters;
    int[] returnValueType = new int[1];

    public TDSRPCRequest(TDSConnection tDSConnection, UtilByteOrderedDataReader utilByteOrderedDataReader, UtilByteOrderedDataWriter utilByteOrderedDataWriter, String string) {
        super(tDSConnection, utilByteOrderedDataReader, utilByteOrderedDataWriter, 3);
        this.procedureName = string;
        this.parameters = new Vector();
        this.processMode = 0;
        this.RPCOptions = 0;
    }

    public void addParameter(TDSRPCParameter tDSRPCParameter) {
        this.parameters.addElement(tDSRPCParameter);
    }

    public TDSRPCParameter getOutputParam(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.parameters.size()) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.parameters.elementAt(n3);
            if (tDSRPCParameter.isOutput && ++n2 == n) {
                return tDSRPCParameter;
            }
            ++n3;
        }
        return null;
    }

    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (by) {
                case -127: {
                    this.processColMetaData();
                    return this.processMode != 0 && this.processMode != 2;
                }
                case -84: {
                    this.processReturnValue();
                    return true;
                }
            }
            return super.processReplyToken(by, baseWarnings);
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processReturnValue() throws SQLException {
        try {
            var1_1 = this.reader.readInt16();
            var2_3 = this.reader.readInt8();
            if (var2_3 != 0) {
                this.reader.readAndDiscardBytes(var1_1 - 1);
                return;
            }
            this.reader.readInt8();
            this.reader.readInt16();
            this.reader.readInt16();
            var3_4 = this.reader.readInt8();
            var4_5 = false;
            var5_6 = 0;
            var6_7 = 0;
            switch (var3_4) {
                case 36: 
                case 38: 
                case 104: 
                case 109: 
                case 111: {
                    this.reader.readUnsignedInt8();
                    break;
                }
                case 110: {
                    var6_7 = 4;
                    this.reader.readUnsignedInt8();
                    break;
                }
                case -91: 
                case -89: 
                case -83: 
                case -81: 
                case -25: 
                case -17: {
                    var5_6 = this.reader.readUnsignedInt16();
                    break;
                }
                case 106: 
                case 108: {
                    this.reader.readUnsignedInt8();
                    var5_6 = this.reader.readUnsignedInt8();
                    var6_7 = this.reader.readUnsignedInt8();
                    break;
                }
                default: {
                    UtilDebug.assert((String)"Unexpected TDSType", (boolean)false);
                    break;
                }
                case 48: 
                case 50: 
                case 52: 
                case 56: 
                case 61: 
                case 62: 
                case 127: 
            }
            var7_8 = null;
            if (this.conn.getTDSVersion() != 2) ** GOTO lbl53
            var8_9 /* !! */  = new byte[5];
            switch (var3_4) {
                case -89: 
                case -81: 
                case 35: {
                    this.reader.readBytes(var8_9 /* !! */ , 0, 5);
                    var7_8 = this.conn.getTransliteratorForCodePage(this.conn.mapCollationToCodePage(var8_9 /* !! */ ));
                    break;
                }
                case -25: 
                case -17: 
                case 99: {
                    this.reader.readBytes(var8_9 /* !! */ , 0, 5);
                    break;
                }
lbl53:
                // 1 sources

                if (var3_4 != -81 && var3_4 != -89 && var3_4 != 35) break;
                var7_8 = this.conn.nonUnicodeTransliterator;
                break;
            }
            var8_9 /* !! */  = (byte[])this.getReturnedValue(this.returnValueType, var3_4, var7_8, 1019, var5_6, var6_7);
            var9_10 = this.getOutputParam(++this.numReturnedParameters);
            var9_10.value = var8_9 /* !! */ ;
            var9_10.baseDataType = this.returnValueType[0];
            return;
        }
        catch (UtilException var1_2) {
            throw this.conn.exceptions.getException((Exception)var1_2);
        }
    }

    public void submitRequest() throws SQLException {
        try {
            this.reader.empty();
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                this.conn.setMessageType(this.messageType);
                this.writer.writeInt16(this.procedureName.length());
                this.writer.writeString(this.procedureName);
                this.writer.writeInt16(this.RPCOptions);
                int n = 0;
                while (n < this.parameters.size()) {
                    TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.parameters.elementAt(n);
                    tDSRPCParameter.write(this.conn, this.writer);
                    ++n;
                }
                this.writer.send();
            }
            this.reader.receive();
            this.numReturnedParameters = 0;
            this.returnValue = 0L;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }
}

