/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.property;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.Strings;
import org.jboss.util.property.Property;
import org.jboss.util.property.PropertyGroup;
import org.jboss.util.property.PropertyListener;
import org.jboss.varia.property.SystemPropertiesServiceMBean;

public class SystemPropertiesService
extends ServiceMBeanSupport
implements SystemPropertiesServiceMBean {
    protected String serverHome;

    public String set(String name, String value) {
        return Property.set((String)name, (String)value);
    }

    public String get(String name, String defaultValue) {
        return Property.get((String)name, (String)defaultValue);
    }

    public String get(String name) {
        return Property.get((String)name);
    }

    public String remove(String name) {
        return Property.remove((String)name);
    }

    private List makeList(String[] array) {
        ArrayList<String> list = new ArrayList<String>(array.length);
        int i = 0;
        while (i < array.length) {
            list.set(i, array[i]);
            ++i;
        }
        return list;
    }

    private String[] makeArray(List list) {
        String[] array = new String[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = (String)list.get(i);
            ++i;
        }
        return array;
    }

    public List getArray(String base, List defaultValues) {
        String[] array = this.makeArray(defaultValues);
        return this.makeList(Property.getArray((String)base, (String[])array));
    }

    public List getArray(String name) {
        return this.makeList(Property.getArray((String)name));
    }

    public boolean exists(String name) {
        return Property.exists((String)name);
    }

    public PropertyGroup getGroup(String basename) {
        return Property.getGroup((String)basename);
    }

    public PropertyGroup getGroup(String basename, int index) {
        return Property.getGroup((String)basename, (int)index);
    }

    public void addListener(PropertyListener listener) {
        Property.addListener((PropertyListener)listener);
    }

    public void addListeners(PropertyListener[] listeners) {
        Property.addListeners((PropertyListener[])listeners);
    }

    public boolean removeListener(PropertyListener listener) {
        return Property.removeListener((PropertyListener)listener);
    }

    public void load(URL url) throws IOException {
        this.log.trace((Object)("Loading system properties from: " + url));
        Properties props = System.getProperties();
        props.load(url.openConnection().getInputStream());
        this.log.info((Object)("Loaded system properties from: " + url));
    }

    public void load(String url) throws IOException, MalformedURLException {
        this.load(Strings.toURL((String)url, (String)this.serverHome));
    }

    public void addListener(String typename) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> type = Class.forName(typename);
        PropertyListener listener = (PropertyListener)type.newInstance();
        this.addListener(listener);
    }

    public void setURLList(String list) throws MalformedURLException, IOException {
        StringTokenizer stok = new StringTokenizer(list, ",");
        while (stok.hasMoreTokens()) {
            String url = stok.nextToken();
            this.load(url);
        }
    }

    public void setProperties(Properties props) throws IOException {
        this.log.debug((Object)("Merging with system properties: " + props));
        Properties sysProps = System.getProperties();
        Iterator<Object> keys = props.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = props.getProperty(key);
            value = Strings.replaceProperties((String)value);
            System.setProperty(key, value);
        }
    }

    public Map showAll() {
        return new HTMLMap((Map)System.getProperties());
    }

    public Map showGroup(String basename) {
        return new HTMLMap((Map)this.getGroup(basename));
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? SystemPropertiesServiceMBean.OBJECT_NAME : name;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.serverHome = ServerConfigLocator.locate().getServerHomeDir().getPath();
        return super.preRegister(server, name);
    }

    protected static class HTMLMap
    extends HashMap {
        public HTMLMap(Map map) {
            super(map);
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("<table>");
            Iterator iter = this.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                buff.append("<tr><td align=\"left\"><b>").append(key).append("</b></td><td align=\"left\">").append(this.get(key)).append("</td></tr>\n\r");
            }
            buff.append("</table>");
            return buff.toString();
        }
    }
}

