/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.lang.reflect.Constructor;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.TimerNotification;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.scheduler.Schedulable;
import org.jboss.varia.scheduler.SchedulerMBean;

public class Scheduler
extends ServiceMBeanSupport
implements SchedulerMBean {
    public static String JNDI_NAME = "scheduler:domain";
    public static String JMX_NAME = "scheduler";
    private static final int NOTIFICATION = 0;
    private static final int DATE = 1;
    private static final int REPETITIONS = 2;
    private static final int SCHEDULER_NAME = 3;
    private static final int NULL = 4;
    private long mActualSchedulePeriod;
    private long mRemainingRepetitions = 0L;
    private int mActualSchedule = -1;
    private ObjectName mTimer;
    private Schedulable mSchedulable;
    private boolean mScheduleIsStarted = false;
    private boolean mWaitForNextCallToStop = false;
    private boolean mStartOnStart = false;
    private boolean mIsRestartPending = true;
    private boolean mUseMBean = false;
    private Class mSchedulableClass;
    private String mSchedulableArguments;
    private String[] mSchedulableArgumentList = new String[0];
    private String mSchedulableArgumentTypes;
    private Class[] mSchedulableArgumentTypeList = new Class[0];
    private ObjectName mSchedulableMBean;
    private String mSchedulableMBeanMethod;
    private String mSchedulableMBeanMethodName;
    private int[] mSchedulableMBeanArguments = new int[0];
    private String[] mSchedulableMBeanArgumentTypes = new String[0];
    private DateFormat mDateFormatter;
    private Date mStartDate;
    private String mStartDateString;
    private boolean mStartDateIsNow;
    private long mSchedulePeriod;
    private long mInitialRepetitions;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$jboss$varia$scheduler$Schedulable;
    static /* synthetic */ Class class$javax$management$Notification;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public Scheduler() {
    }

    public Scheduler(String pSchedulableClass, String pInitArguments, String pInitTypes, String pInitialStartDate, long pSchedulePeriod, long pNumberOfRepetitions) {
        this.setStartAtStartup(true);
        this.setSchedulableClass(pSchedulableClass);
        this.setSchedulableArguments(pInitArguments);
        this.setSchedulableArgumentTypes(pInitTypes);
        this.setInitialStartDate(pInitialStartDate);
        this.setSchedulePeriod(pSchedulePeriod);
        this.setInitialRepetitions(pNumberOfRepetitions);
    }

    public void startSchedule() {
        if (!this.isStarted()) {
            try {
                if (this.mUseMBean) {
                    if (this.mSchedulableMBean == null) {
                        this.log.debug((Object)"Schedulable MBean Object Name is not set");
                        throw new InvalidParameterException("Schedulable MBean must be set");
                    }
                    if (this.mSchedulableMBeanMethodName == null) {
                        this.mSchedulableMBeanMethodName = "perform";
                        this.mSchedulableMBeanArguments = new int[]{1, 2};
                        this.mSchedulableMBeanArgumentTypes = new String[]{(class$java$util$Date == null ? (class$java$util$Date = Scheduler.class$("java.util.Date")) : class$java$util$Date).getName(), Integer.TYPE.getName()};
                    }
                } else {
                    if (this.mSchedulableClass == null) {
                        this.log.debug((Object)"Schedulable Class is not set");
                        throw new InvalidParameterException("Schedulable Class must be set");
                    }
                    if (this.mSchedulableArgumentList.length != this.mSchedulableArgumentTypeList.length) {
                        this.log.debug((Object)"Schedulable Class Arguments and Types do not match in length");
                        throw new InvalidParameterException("Schedulable Class Arguments and Types do not match in length");
                    }
                }
                if (this.mSchedulePeriod <= 0L) {
                    this.log.debug((Object)"Schedule Period is less than 0 (ms)");
                    throw new InvalidParameterException("Schedule Period must be set and greater than 0 (ms)");
                }
                if (!this.mUseMBean) {
                    Object[] lArgumentList = new Object[this.mSchedulableArgumentTypeList.length];
                    try {
                        int i = 0;
                        while (i < this.mSchedulableArgumentTypeList.length) {
                            Class lClass = this.mSchedulableArgumentTypeList[i];
                            if (lClass == Boolean.TYPE) {
                                lArgumentList[i] = new Boolean(this.mSchedulableArgumentList[i]);
                            } else if (lClass == Integer.TYPE) {
                                lArgumentList[i] = new Integer(this.mSchedulableArgumentList[i]);
                            } else if (lClass == Long.TYPE) {
                                lArgumentList[i] = new Long(this.mSchedulableArgumentList[i]);
                            } else if (lClass == Short.TYPE) {
                                lArgumentList[i] = new Short(this.mSchedulableArgumentList[i]);
                            } else if (lClass == Float.TYPE) {
                                lArgumentList[i] = new Float(this.mSchedulableArgumentList[i]);
                            } else if (lClass == Double.TYPE) {
                                lArgumentList[i] = new Double(this.mSchedulableArgumentList[i]);
                            } else if (lClass == Byte.TYPE) {
                                lArgumentList[i] = new Byte(this.mSchedulableArgumentList[i]);
                            } else if (lClass == Character.TYPE) {
                                lArgumentList[i] = new Character(this.mSchedulableArgumentList[i].charAt(0));
                            } else {
                                Constructor lConstructor = lClass.getConstructor(class$java$lang$String == null ? Scheduler.class$("java.lang.String") : class$java$lang$String);
                                lArgumentList[i] = lConstructor.newInstance(this.mSchedulableArgumentList[i]);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Could not load or create constructor argument", (Throwable)e);
                        throw new InvalidParameterException("Could not load or create a constructor argument");
                    }
                    try {
                        Constructor lSchedulableConstructor = this.mSchedulableClass.getConstructor(this.mSchedulableArgumentTypeList);
                        this.mSchedulable = (Schedulable)lSchedulableConstructor.newInstance(lArgumentList);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Could not find the constructor or create Schedulable instance", (Throwable)e);
                        throw new InvalidParameterException("Could not find the constructor or create the Schedulable Instance");
                    }
                }
                this.mRemainingRepetitions = this.mInitialRepetitions;
                this.mActualSchedulePeriod = this.mSchedulePeriod;
                Date lStartDate = null;
                if (this.mStartDateIsNow) {
                    lStartDate = this.mStartDate = new Date(new Date().getTime() + 1000L);
                } else if (this.mStartDate.getTime() < new Date().getTime()) {
                    long lNow = new Date().getTime() + 100L;
                    long lSkipRepeats = (lNow - this.mStartDate.getTime()) / this.mActualSchedulePeriod + 1L;
                    this.log.debug((Object)("Old start date: " + this.mStartDate + ", now: " + new Date(lNow) + ", Skip repeats: " + lSkipRepeats));
                    if (this.mRemainingRepetitions > 0L) {
                        if (lSkipRepeats >= this.mRemainingRepetitions) {
                            this.log.info((Object)"No repetitions left because start date is in the past and could not be reached by Initial Repetitions * Schedule Period");
                            return;
                        }
                        this.mRemainingRepetitions -= lSkipRepeats;
                    }
                    lStartDate = new Date(this.mStartDate.getTime() + lSkipRepeats * this.mActualSchedulePeriod);
                } else {
                    lStartDate = this.mStartDate;
                }
                this.log.debug((Object)("Schedule initial call to: " + lStartDate + ", remaining repetitions: " + this.mRemainingRepetitions));
                this.mActualSchedule = (Integer)this.getServer().invoke(this.mTimer, "addNotification", new Object[]{"Schedule", "Scheduler Notification", null, lStartDate, new Long(this.mActualSchedulePeriod), this.mRemainingRepetitions < 0L ? new Long(0L) : new Long(this.mRemainingRepetitions)}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = Scheduler.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = Scheduler.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = Scheduler.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$util$Date == null ? (class$java$util$Date = Scheduler.class$("java.util.Date")) : class$java$util$Date).getName(), Long.TYPE.getName(), Long.TYPE.getName()});
                if (this.mUseMBean) {
                    this.getServer().addNotificationListener(this.mTimer, new MBeanListener(this.mSchedulableMBean), (javax.management.NotificationFilter)new NotificationFilter(new Integer(this.mActualSchedule)), null);
                } else {
                    this.getServer().addNotificationListener(this.mTimer, new Listener(this.mSchedulable), (javax.management.NotificationFilter)new NotificationFilter(new Integer(this.mActualSchedule)), null);
                }
                this.mScheduleIsStarted = true;
                this.mIsRestartPending = false;
            }
            catch (Exception e) {
                this.log.error((Object)"operation failed", (Throwable)e);
            }
        }
    }

    public void stopSchedule(boolean pDoItNow) {
        try {
            if (this.mActualSchedule < 0) {
                this.mScheduleIsStarted = false;
                this.mWaitForNextCallToStop = false;
                return;
            }
            if (pDoItNow) {
                this.mWaitForNextCallToStop = false;
                this.log.debug((Object)("stopSchedule(), schedule id: " + this.mActualSchedule));
                this.getServer().invoke(this.mTimer, "removeNotification", new Object[]{new Integer(this.mActualSchedule)}, new String[]{(class$java$lang$Integer == null ? (class$java$lang$Integer = Scheduler.class$("java.lang.Integer")) : class$java$lang$Integer).getName()});
                this.log.debug((Object)("stopSchedule(), removed schedule id: " + this.mActualSchedule));
                this.mActualSchedule = -1;
                this.mScheduleIsStarted = false;
            } else {
                this.mWaitForNextCallToStop = true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
    }

    public void restartSchedule() {
        this.stopSchedule(true);
        this.startSchedule();
    }

    public String getSchedulableClass() {
        if (this.mSchedulableClass == null) {
            return null;
        }
        return this.mSchedulableClass.getName();
    }

    public void setSchedulableClass(String pSchedulableClass) throws InvalidParameterException {
        if (pSchedulableClass == null || pSchedulableClass.equals("")) {
            throw new InvalidParameterException("Schedulable Class cannot be empty or undefined");
        }
        try {
            this.mSchedulableClass = Thread.currentThread().getContextClassLoader().loadClass(pSchedulableClass);
            Class<?>[] lInterfaces = this.mSchedulableClass.getInterfaces();
            boolean lFound = false;
            int i = 0;
            while (i < lInterfaces.length) {
                if (lInterfaces[i] == (class$org$jboss$varia$scheduler$Schedulable == null ? Scheduler.class$("org.jboss.varia.scheduler.Schedulable") : class$org$jboss$varia$scheduler$Schedulable)) {
                    lFound = true;
                    break;
                }
                ++i;
            }
            if (!lFound) {
                throw new InvalidParameterException("Given class " + pSchedulableClass + " is not instance of Schedulable");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new InvalidParameterException("Given class " + pSchedulableClass + " is not valid or not found");
        }
        this.mIsRestartPending = true;
        this.mUseMBean = false;
    }

    public String getSchedulableArguments() {
        return this.mSchedulableArguments;
    }

    public void setSchedulableArguments(String pArgumentList) {
        if (pArgumentList == null || pArgumentList.equals("")) {
            this.mSchedulableArgumentList = new String[0];
        } else {
            StringTokenizer lTokenizer = new StringTokenizer(pArgumentList, ",");
            Vector<String> lList = new Vector<String>();
            while (lTokenizer.hasMoreTokens()) {
                String lToken = lTokenizer.nextToken().trim();
                if (lToken.equals("")) {
                    lList.add("null");
                    continue;
                }
                lList.add(lToken);
            }
            this.mSchedulableArgumentList = lList.toArray(new String[0]);
        }
        this.mSchedulableArguments = pArgumentList;
        this.mIsRestartPending = true;
    }

    public String getSchedulableArgumentTypes() {
        return this.mSchedulableArgumentTypes;
    }

    public void setSchedulableArgumentTypes(String pTypeList) throws InvalidParameterException {
        if (pTypeList == null || pTypeList.equals("")) {
            this.mSchedulableArgumentTypeList = new Class[0];
        } else {
            StringTokenizer lTokenizer = new StringTokenizer(pTypeList, ",");
            Vector<Class<Short>> lList = new Vector<Class<Short>>();
            while (lTokenizer.hasMoreTokens()) {
                String lToken = lTokenizer.nextToken().trim();
                Class<Comparable<Short>> lClass = null;
                if (lToken.equals("short")) {
                    lClass = Short.TYPE;
                } else if (lToken.equals("int")) {
                    lClass = Integer.TYPE;
                } else if (lToken.equals("long")) {
                    lClass = Long.TYPE;
                } else if (lToken.equals("byte")) {
                    lClass = Byte.TYPE;
                } else if (lToken.equals("char")) {
                    lClass = Character.TYPE;
                } else if (lToken.equals("float")) {
                    lClass = Float.TYPE;
                } else if (lToken.equals("double")) {
                    lClass = Double.TYPE;
                } else if (lToken.equals("boolean")) {
                    lClass = Boolean.TYPE;
                }
                if (lClass == null) {
                    try {
                        lClass = Thread.currentThread().getContextClassLoader().loadClass(lToken);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new InvalidParameterException("The argument type: " + lToken + " is not a valid class or could not be found");
                    }
                }
                lList.add(lClass);
            }
            this.mSchedulableArgumentTypeList = lList.toArray(new Class[0]);
        }
        this.mSchedulableArgumentTypes = pTypeList;
        this.mIsRestartPending = true;
    }

    public String getSchedulableMBean() {
        return this.mSchedulableMBean == null ? null : this.mSchedulableMBean.toString();
    }

    public void setSchedulableMBean(String pSchedulableMBean) throws InvalidParameterException {
        if (pSchedulableMBean == null) {
            throw new InvalidParameterException("Schedulable MBean must be specified");
        }
        try {
            this.mSchedulableMBean = new ObjectName(pSchedulableMBean);
            this.mUseMBean = true;
        }
        catch (MalformedObjectNameException mone) {
            this.log.error((Object)"Schedulable MBean Object Name is malformed", (Throwable)mone);
            throw new InvalidParameterException("Schedulable MBean is not correctly formatted");
        }
    }

    public String getSchedulableMBeanMethod() {
        return this.mSchedulableMBeanMethod;
    }

    public void setSchedulableMBeanMethod(String pSchedulableMBeanMethod) throws InvalidParameterException {
        if (pSchedulableMBeanMethod == null) {
            this.mSchedulableMBeanMethod = null;
            return;
        }
        int lIndex = pSchedulableMBeanMethod.indexOf(40);
        String lMethodName = "";
        if (lIndex < 0) {
            lMethodName = pSchedulableMBeanMethod.trim();
            this.mSchedulableMBeanArguments = new int[0];
            this.mSchedulableMBeanArgumentTypes = new String[0];
        } else if (lIndex > 0) {
            lMethodName = pSchedulableMBeanMethod.substring(0, lIndex).trim();
        }
        if (lMethodName.equals("")) {
            lMethodName = "perform";
        }
        if (lIndex >= 0) {
            String lRest;
            int lIndex2 = pSchedulableMBeanMethod.indexOf(41);
            if (lIndex2 < lIndex) {
                throw new InvalidParameterException("Schedulable MBean Method: closing bracket must be after opening bracket");
            }
            if (lIndex2 < pSchedulableMBeanMethod.length() - 1 && (lRest = pSchedulableMBeanMethod.substring(lIndex2 + 1).trim()).length() > 0) {
                throw new InvalidParameterException("Schedulable MBean Method: nothing should be after closing bracket");
            }
            String lArguments = pSchedulableMBeanMethod.substring(lIndex + 1, lIndex2).trim();
            if (lArguments.equals("")) {
                this.mSchedulableMBeanArguments = new int[0];
                this.mSchedulableMBeanArgumentTypes = new String[0];
            } else {
                StringTokenizer lTokenizer = new StringTokenizer(lArguments, ",");
                this.mSchedulableMBeanArguments = new int[lTokenizer.countTokens()];
                this.mSchedulableMBeanArgumentTypes = new String[lTokenizer.countTokens()];
                int i = 0;
                while (lTokenizer.hasMoreTokens()) {
                    String lToken = lTokenizer.nextToken().trim();
                    if (lToken.equals("NOTIFICATION")) {
                        this.mSchedulableMBeanArguments[i] = 0;
                        this.mSchedulableMBeanArgumentTypes[i] = (class$javax$management$Notification == null ? Scheduler.class$("javax.management.Notification") : class$javax$management$Notification).getName();
                    } else if (lToken.equals("DATE")) {
                        this.mSchedulableMBeanArguments[i] = 1;
                        this.mSchedulableMBeanArgumentTypes[i] = (class$java$util$Date == null ? Scheduler.class$("java.util.Date") : class$java$util$Date).getName();
                    } else if (lToken.equals("REPETITIONS")) {
                        this.mSchedulableMBeanArguments[i] = 2;
                        this.mSchedulableMBeanArgumentTypes[i] = Long.TYPE.getName();
                    } else if (lToken.equals("SCHEDULER_NAME")) {
                        this.mSchedulableMBeanArguments[i] = 3;
                        this.mSchedulableMBeanArgumentTypes[i] = (class$javax$management$ObjectName == null ? Scheduler.class$("javax.management.ObjectName") : class$javax$management$ObjectName).getName();
                    } else {
                        this.mSchedulableMBeanArguments[i] = 4;
                        this.mSchedulableMBeanArgumentTypes[i] = lToken;
                    }
                    ++i;
                }
            }
        }
        this.mSchedulableMBeanMethodName = lMethodName;
        this.mSchedulableMBeanMethod = pSchedulableMBeanMethod;
    }

    public boolean isUsingMBean() {
        return this.mUseMBean;
    }

    public long getSchedulePeriod() {
        return this.mSchedulePeriod;
    }

    public void setSchedulePeriod(long pPeriod) {
        if (pPeriod <= 0L) {
            throw new InvalidParameterException("Schedulable Period may be not less or equals than 0");
        }
        this.mSchedulePeriod = pPeriod;
        this.mIsRestartPending = true;
    }

    public String getInitialStartDate() {
        return this.mStartDateString;
    }

    public void setInitialStartDate(String pStartDate) {
        String string = this.mStartDateString = pStartDate == null ? "" : pStartDate.trim();
        if (this.mStartDateString.equals("")) {
            this.mStartDate = new Date(0L);
        } else if (this.mStartDateString.equals("NOW")) {
            this.mStartDate = new Date(new Date().getTime() + 1000L);
            this.mStartDateIsNow = true;
        } else {
            try {
                long lDate = new Long(pStartDate);
                this.mStartDate = new Date(lDate);
                this.mStartDateIsNow = false;
            }
            catch (Exception e) {
                try {
                    if (this.mDateFormatter == null) {
                        this.mDateFormatter = new SimpleDateFormat();
                    }
                    this.mStartDate = this.mDateFormatter.parse(this.mStartDateString);
                    this.mStartDateIsNow = false;
                }
                catch (Exception e2) {
                    this.log.error((Object)("Could not parse given date string: " + this.mStartDateString), (Throwable)e2);
                    throw new InvalidParameterException("Schedulable Date is not of correct format");
                }
            }
        }
        this.log.debug((Object)("Initial Start Date is set to: " + this.mStartDate));
    }

    public long getInitialRepetitions() {
        return this.mInitialRepetitions;
    }

    public void setInitialRepetitions(long pNumberOfCalls) {
        if (pNumberOfCalls <= 0L) {
            pNumberOfCalls = -1L;
        }
        this.mInitialRepetitions = pNumberOfCalls;
        this.mIsRestartPending = true;
    }

    public long getRemainingRepetitions() {
        return this.mRemainingRepetitions;
    }

    public boolean isStarted() {
        return this.mScheduleIsStarted;
    }

    public boolean isRestartPending() {
        return this.mIsRestartPending;
    }

    public boolean isStartAtStartup() {
        return this.mStartOnStart;
    }

    public void setStartAtStartup(boolean pStartAtStartup) {
        this.mStartOnStart = pStartAtStartup;
    }

    public boolean isActive() {
        return this.isStarted() && this.mRemainingRepetitions != 0L;
    }

    public ObjectName getObjectName(MBeanServer pServer, ObjectName pName) throws MalformedObjectNameException {
        return pName == null ? SchedulerMBean.OBJECT_NAME : pName;
    }

    protected void startService() throws Exception {
        this.mTimer = new ObjectName(":service=Timer");
        if (!this.getServer().isRegistered(this.mTimer)) {
            this.getServer().createMBean("javax.management.timer.Timer", this.mTimer);
            this.getServer().invoke(this.mTimer, "start", new Object[0], new String[0]);
        }
        if (this.mStartOnStart) {
            this.log.debug((Object)"Start Scheduler on start up time");
            this.startSchedule();
        }
    }

    protected void stopService() {
        this.stopSchedule(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SchedulableExample
    implements Schedulable {
        private static final Logger log = Logger.getLogger((Class)(class$org$jboss$varia$scheduler$Scheduler$SchedulableExample == null ? (class$org$jboss$varia$scheduler$Scheduler$SchedulableExample = SchedulableExample.class$("org.jboss.varia.scheduler.Scheduler$SchedulableExample")) : class$org$jboss$varia$scheduler$Scheduler$SchedulableExample));
        private String mName;
        private int mValue;
        static /* synthetic */ Class class$org$jboss$varia$scheduler$Scheduler$SchedulableExample;

        public SchedulableExample(String pName, int pValue) {
            this.mName = pName;
            this.mValue = pValue;
        }

        public void perform(Date pTimeOfCall, long pRemainingRepetitions) {
            log.info((Object)("Schedulable Examples is called at: " + pTimeOfCall + ", remaining repetitions: " + pRemainingRepetitions + ", test, name: " + this.mName + ", value: " + this.mValue));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class NotificationFilter
    implements javax.management.NotificationFilter {
        private Integer mId;

        public NotificationFilter(Integer pId) {
            this.mId = pId;
        }

        public boolean isNotificationEnabled(Notification pNotification) {
            if (pNotification instanceof TimerNotification) {
                TimerNotification lTimerNotification = (TimerNotification)pNotification;
                return lTimerNotification.getNotificationID().equals(this.mId);
            }
            return false;
        }
    }

    public class MBeanListener
    implements NotificationListener {
        private final Logger log = Logger.getLogger((Class)(class$org$jboss$varia$scheduler$Scheduler$Listener == null ? (class$org$jboss$varia$scheduler$Scheduler$Listener = MBeanListener.class$("org.jboss.varia.scheduler.Scheduler$Listener")) : class$org$jboss$varia$scheduler$Scheduler$Listener));
        private ObjectName mDelegate;
        static /* synthetic */ Class class$org$jboss$varia$scheduler$Scheduler$Listener;
        static /* synthetic */ Class class$java$lang$Integer;

        public MBeanListener(ObjectName pDelegate) {
            this.mDelegate = pDelegate;
        }

        public void handleNotification(Notification pNotification, Object pHandback) {
            block15: {
                this.log.debug((Object)("MBeanListener.handleNotification(), notification: " + pNotification));
                try {
                    this.log.debug((Object)("Scheduler is started: " + Scheduler.this.isStarted()));
                    Date lTimeStamp = new Date(pNotification.getTimeStamp());
                    if (Scheduler.this.isStarted()) {
                        if (Scheduler.this.getRemainingRepetitions() <= 0L && Scheduler.this.getRemainingRepetitions() >= 0L) break block15;
                        if (Scheduler.this.mRemainingRepetitions > 0L) {
                            Scheduler.this.mRemainingRepetitions--;
                        }
                        Object[] lArguments = new Object[Scheduler.this.mSchedulableMBeanArguments.length];
                        int i = 0;
                        while (i < lArguments.length) {
                            switch (Scheduler.this.mSchedulableMBeanArguments[i]) {
                                case 0: {
                                    lArguments[i] = pNotification;
                                    break;
                                }
                                case 1: {
                                    lArguments[i] = lTimeStamp;
                                    break;
                                }
                                case 2: {
                                    lArguments[i] = new Long(Scheduler.this.mRemainingRepetitions);
                                    break;
                                }
                                case 3: {
                                    lArguments[i] = Scheduler.this.getServiceName();
                                    break;
                                }
                                default: {
                                    lArguments[i] = null;
                                }
                            }
                            ++i;
                        }
                        this.log.debug((Object)("MBean Arguments are: " + Arrays.asList(lArguments)));
                        this.log.debug((Object)("MBean Arguments Types are: " + Arrays.asList(Scheduler.this.mSchedulableMBeanArgumentTypes)));
                        try {
                            Scheduler.this.getServer().invoke(this.mDelegate, Scheduler.this.mSchedulableMBeanMethodName, lArguments, Scheduler.this.mSchedulableMBeanArgumentTypes);
                        }
                        catch (JMRuntimeException jmre) {
                            this.log.error((Object)"Invoke of the Schedulable MBean failed", (Throwable)jmre);
                        }
                        catch (JMException jme) {
                            this.log.error((Object)"Invoke of the Schedulable MBean failed", (Throwable)jme);
                        }
                        this.log.debug((Object)("Remaining Repititions: " + Scheduler.this.getRemainingRepetitions() + ", wait for next call to stop: " + Scheduler.this.mWaitForNextCallToStop));
                        if (Scheduler.this.getRemainingRepetitions() == 0L || Scheduler.this.mWaitForNextCallToStop) {
                            Scheduler.this.stopSchedule(true);
                        }
                        break block15;
                    }
                    Scheduler.this.getServer().invoke(Scheduler.this.mTimer, "removeNotification", new Object[]{new Integer(Scheduler.this.mActualSchedule)}, new String[]{(class$java$lang$Integer == null ? (class$java$lang$Integer = MBeanListener.class$("java.lang.Integer")) : class$java$lang$Integer).getName()});
                    Scheduler.this.mActualSchedule = -1;
                }
                catch (Exception e) {
                    this.log.error((Object)"Handling a Scheduler call failed", (Throwable)e);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public class Listener
    implements NotificationListener {
        private final Logger log = Logger.getLogger((Class)(class$org$jboss$varia$scheduler$Scheduler$Listener == null ? (class$org$jboss$varia$scheduler$Scheduler$Listener = Listener.class$("org.jboss.varia.scheduler.Scheduler$Listener")) : class$org$jboss$varia$scheduler$Scheduler$Listener));
        private Schedulable mDelegate;
        static /* synthetic */ Class class$org$jboss$varia$scheduler$Scheduler$Listener;
        static /* synthetic */ Class class$java$lang$Integer;

        public Listener(Schedulable pDelegate) {
            this.mDelegate = pDelegate;
        }

        public void handleNotification(Notification pNotification, Object pHandback) {
            this.log.debug((Object)("Listener.handleNotification(), notification: " + pNotification));
            try {
                this.log.debug((Object)("Scheduler is started: " + Scheduler.this.isStarted()));
                Date lTimeStamp = new Date(pNotification.getTimeStamp());
                if (Scheduler.this.isStarted()) {
                    if (Scheduler.this.getRemainingRepetitions() > 0L || Scheduler.this.getRemainingRepetitions() < 0L) {
                        if (Scheduler.this.mRemainingRepetitions > 0L) {
                            Scheduler.this.mRemainingRepetitions--;
                        }
                        this.mDelegate.perform(lTimeStamp, Scheduler.this.getRemainingRepetitions());
                        this.log.debug((Object)("Remaining Repititions: " + Scheduler.this.getRemainingRepetitions() + ", wait for next call to stop: " + Scheduler.this.mWaitForNextCallToStop));
                        if (Scheduler.this.getRemainingRepetitions() == 0L || Scheduler.this.mWaitForNextCallToStop) {
                            Scheduler.this.stopSchedule(true);
                        }
                    }
                } else {
                    Scheduler.this.getServer().invoke(Scheduler.this.mTimer, "removeNotification", new Object[]{new Integer(Scheduler.this.mActualSchedule)}, new String[]{(class$java$lang$Integer == null ? (class$java$lang$Integer = Listener.class$("java.lang.Integer")) : class$java$lang$Integer).getName()});
                    Scheduler.this.mActualSchedule = -1;
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Handling a Scheduler call failed", (Throwable)e);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

