/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.varia.scheduler.AbstractScheduleProvider;
import org.jboss.varia.scheduler.XMLScheduleProviderMBean;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLScheduleProvider
extends AbstractScheduleProvider
implements XMLScheduleProviderMBean {
    private Element mSchedules;
    private DateFormat mDateFormatter;
    private ArrayList mIDList = new ArrayList();

    public Element getSchedules() {
        return this.mSchedules;
    }

    public void setSchedules(Element pSchedules) {
        this.mSchedules = pSchedules;
    }

    public void startProviding() throws Exception {
        try {
            NodeList lSchedules = this.mSchedules.getElementsByTagName("schedule");
            int i = 0;
            while (i < lSchedules.getLength()) {
                Node lSchedule = lSchedules.item(i);
                NodeList lAttributes = lSchedule.getChildNodes();
                Text lItem = this.getNode(lAttributes, "target-mbean-name");
                if (lItem == null) {
                    this.log.error((Object)"No 'target-mbean-name' is specified therefore this Schedule is ignored");
                } else {
                    this.log.info((Object)("Got 'target-mbean-name' element: " + lItem + ", node value: " + lItem.getData() + lItem.getChildNodes()));
                    String lTarget = lItem.getData();
                    lItem = this.getNode(lAttributes, "target-method-name");
                    if (lItem == null) {
                        this.log.error((Object)"No 'target-method-name' is specified therefore this Schedule is ignored");
                    } else {
                        String lMethodName = lItem.getData();
                        lItem = this.getNode(lAttributes, "target-method-signature");
                        if (lItem == null) {
                            this.log.error((Object)"No 'target-method-signature' is specified therefore this Schedule is ignored");
                        } else {
                            String lMethodSignature = lItem.getData();
                            lItem = this.getNode(lAttributes, "start-date");
                            if (lItem == null) {
                                this.log.error((Object)"No 'start-date' is specified therefore this Schedule is ignored");
                            } else {
                                String lStartDate = lItem.getData();
                                lItem = this.getNode(lAttributes, "period");
                                if (lItem == null) {
                                    this.log.error((Object)"No 'period' is specified therefore this Schedule is ignored");
                                } else {
                                    String lPeriod = lItem.getData();
                                    lItem = this.getNode(lAttributes, "repetitions");
                                    if (lItem == null) {
                                        this.log.error((Object)"No 'repetitions' is specified therefore this Schedule is ignored");
                                    } else {
                                        String lRepeptions = lItem.getData();
                                        try {
                                            int lID = this.addSchedule(new ObjectName(lTarget), lMethodName, this.getSignature(lMethodSignature), this.getStartDate(lStartDate), new Long(lPeriod), new Integer(lRepeptions));
                                            this.mIDList.add(new Integer(lID));
                                        }
                                        catch (NumberFormatException nfe) {
                                            this.log.error((Object)"Could not convert a number", (Throwable)nfe);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected Text getNode(NodeList pList, String pName) {
        if (pList == null) {
            return null;
        }
        int i = 0;
        while (i < pList.getLength()) {
            Node lNode = pList.item(i);
            switch (lNode.getNodeType()) {
                case 1: {
                    Element lChild = (Element)lNode;
                    if (!lChild.getNodeName().equals(pName)) break;
                    return (Text)lChild.getFirstChild();
                }
            }
            ++i;
        }
        return null;
    }

    public void stopProviding() {
        Iterator i = this.mIDList.iterator();
        while (i.hasNext()) {
            Integer lID = (Integer)i.next();
            try {
                this.removeSchedule(lID);
            }
            catch (JMException jme) {
                this.log.error((Object)"Could not remove Schedule in stop providing", (Throwable)jme);
            }
        }
    }

    protected String[] getSignature(String pMethodSignature) {
        if (pMethodSignature == null || "".equals(pMethodSignature.trim())) {
            return new String[0];
        }
        StringTokenizer lTokenizer = new StringTokenizer(pMethodSignature, ",");
        String[] lReturn = new String[lTokenizer.countTokens()];
        int i = 0;
        while (lTokenizer.hasMoreTokens()) {
            lReturn[i++] = lTokenizer.nextToken().trim();
        }
        return lReturn;
    }

    protected Date getStartDate(String pStartDate) {
        pStartDate = pStartDate == null ? "" : pStartDate.trim();
        Date lReturn = null;
        if (pStartDate.equals("")) {
            lReturn = new Date(0L);
        } else if (pStartDate.equals("NOW")) {
            lReturn = new Date(new Date().getTime() + 1000L);
        } else {
            try {
                long lDate = new Long(pStartDate);
                lReturn = new Date(lDate);
            }
            catch (Exception e) {
                try {
                    if (this.mDateFormatter == null) {
                        this.mDateFormatter = new SimpleDateFormat();
                    }
                    lReturn = this.mDateFormatter.parse(pStartDate);
                }
                catch (Exception e2) {
                    this.log.error((Object)("Could not parse given date string: " + pStartDate), (Throwable)e2);
                    throw new InvalidParameterException("Schedulable Date is not of correct format");
                }
            }
        }
        this.log.debug((Object)("Initial Start Date is set to: " + lReturn));
        return lReturn;
    }

    public ObjectName getObjectName(MBeanServer pServer, ObjectName pName) throws MalformedObjectNameException {
        return pName == null ? XMLScheduleProviderMBean.OBJECT_NAME : pName;
    }
}

