/*
 * Decompiled with CFR 0.152.
 */
package com.jspsmart.upload;

import com.jspsmart.upload.File;
import com.jspsmart.upload.Files;
import com.jspsmart.upload.Request;
import com.jspsmart.upload.SmartUploadException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class SmartUpload {
    protected byte[] m_binArray;
    protected HttpServletRequest m_request;
    protected HttpServletResponse m_response;
    protected ServletContext m_application;
    private int m_totalBytes = 0;
    private int m_currentIndex = 0;
    private int m_startData = 0;
    private int m_endData = 0;
    private String m_boundary = new String();
    private long m_totalMaxFileSize = 0L;
    private long m_maxFileSize = 0L;
    private Vector m_deniedFilesList = new Vector();
    private Vector m_allowedFilesList = new Vector();
    private boolean m_denyPhysicalPath = false;
    private boolean m_forcePhysicalPath = false;
    private String m_contentDisposition = new String();
    public static final int SAVE_AUTO = 0;
    public static final int SAVE_VIRTUAL = 1;
    public static final int SAVE_PHYSICAL = 2;
    private Files m_files = new Files();
    private Request m_formRequest = new Request();

    public final void init(ServletConfig config) throws ServletException {
        this.m_application = config.getServletContext();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.m_request = request;
        this.m_response = response;
    }

    public final void initialize(ServletConfig config, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.m_application = config.getServletContext();
        this.m_request = request;
        this.m_response = response;
    }

    public final void initialize(PageContext pageContext) throws ServletException {
        this.m_application = pageContext.getServletContext();
        this.m_request = (HttpServletRequest)pageContext.getRequest();
        this.m_response = (HttpServletResponse)pageContext.getResponse();
    }

    public final void initialize(ServletContext application, HttpSession session, HttpServletRequest request, HttpServletResponse response, JspWriter out) throws ServletException {
        this.m_application = application;
        this.m_request = request;
        this.m_response = response;
    }

    public void upload() throws SmartUploadException, IOException, ServletException {
        int readBytes = 0;
        long totalFileSize = 0L;
        boolean found = false;
        String dataHeader = new String();
        String fieldName = new String();
        String fileName = new String();
        String fileExt = new String();
        String filePathName = new String();
        String contentType = new String();
        String contentDisp = new String();
        String typeMIME = new String();
        String subTypeMIME = new String();
        boolean isFile = false;
        this.m_totalBytes = this.m_request.getContentLength();
        this.m_binArray = new byte[this.m_totalBytes];
        for (int totalRead = 0; totalRead < this.m_totalBytes; totalRead += readBytes) {
            try {
                this.m_request.getInputStream();
                readBytes = this.m_request.getInputStream().read(this.m_binArray, totalRead, this.m_totalBytes - totalRead);
                continue;
            }
            catch (Exception e) {
                throw new SmartUploadException("Unable to upload.");
            }
        }
        while (!found && this.m_currentIndex < this.m_totalBytes) {
            if (this.m_binArray[this.m_currentIndex] == 13) {
                found = true;
            } else {
                this.m_boundary = String.valueOf(this.m_boundary).concat(String.valueOf((char)this.m_binArray[this.m_currentIndex]));
            }
            ++this.m_currentIndex;
        }
        if (this.m_currentIndex == 1) {
            return;
        }
        ++this.m_currentIndex;
        while (this.m_currentIndex < this.m_totalBytes) {
            dataHeader = this.getDataHeader();
            this.m_currentIndex += 2;
            isFile = dataHeader.indexOf("filename") > 0;
            fieldName = this.getDataFieldValue(dataHeader, "name");
            if (isFile) {
                filePathName = this.getDataFieldValue(dataHeader, "filename");
                fileName = this.getFileName(filePathName);
                fileExt = this.getFileExt(fileName);
                contentType = this.getContentType(dataHeader);
                contentDisp = this.getContentDisp(dataHeader);
                typeMIME = this.getTypeMIME(contentType);
                subTypeMIME = this.getSubTypeMIME(contentType);
            }
            this.getDataSection();
            if (isFile && fileName.length() > 0) {
                if (this.m_deniedFilesList.contains(fileExt)) {
                    throw new SecurityException("The extension of the file is denied to be uploaded (1015).");
                }
                if (!this.m_allowedFilesList.isEmpty() && !this.m_allowedFilesList.contains(fileExt)) {
                    throw new SecurityException("The extension of the file is not allowed to be uploaded (1010).");
                }
                if (this.m_maxFileSize > (long)0 && (long)(this.m_endData - this.m_startData + 1) > this.m_maxFileSize) {
                    throw new SecurityException(String.valueOf(new StringBuffer("Size exceeded for this file : ").append(fileName).append(" (1105).")));
                }
                if (this.m_totalMaxFileSize > (long)0 && (totalFileSize += (long)(this.m_endData - this.m_startData + 1)) > this.m_totalMaxFileSize) {
                    throw new SecurityException("Total File Size exceeded (1110).");
                }
            }
            if (isFile) {
                File newFile = new File();
                newFile.setParent(this);
                newFile.setFieldName(fieldName);
                newFile.setFileName(fileName);
                newFile.setFileExt(fileExt);
                newFile.setFilePathName(filePathName);
                newFile.setIsMissing(filePathName.length() == 0);
                newFile.setContentType(contentType);
                newFile.setContentDisp(contentDisp);
                newFile.setTypeMIME(typeMIME);
                newFile.setSubTypeMIME(subTypeMIME);
                if (contentType.indexOf("application/x-macbinary") > 0) {
                    this.m_startData += 128;
                }
                newFile.setSize(this.m_endData - this.m_startData + 1);
                newFile.setStartData(this.m_startData);
                newFile.setEndData(this.m_endData);
                this.m_files.addFile(newFile);
            } else {
                String value = new String(this.m_binArray, this.m_startData, this.m_endData - this.m_startData + 1);
                this.m_formRequest.putParameter(fieldName, value);
            }
            if ((char)this.m_binArray[this.m_currentIndex + 1] == '-') break;
            this.m_currentIndex += 2;
        }
    }

    public int save(String destPathName) throws SmartUploadException, IOException, ServletException {
        return this.save(destPathName, 0);
    }

    public int save(String destPathName, int option) throws SmartUploadException, IOException, ServletException {
        int count = 0;
        if (destPathName == null) {
            destPathName = this.m_application.getRealPath("/");
        }
        if (destPathName.indexOf("/") != -1) {
            if (destPathName.charAt(destPathName.length() - 1) != '/') {
                destPathName = String.valueOf(destPathName).concat("/");
            }
        } else if (destPathName.charAt(destPathName.length() - 1) != '\\') {
            destPathName = String.valueOf(destPathName).concat("\\");
        }
        for (int i = 0; i < this.m_files.getCount(); ++i) {
            if (this.m_files.getFile(i).isMissing()) continue;
            this.m_files.getFile(i).saveAs(String.valueOf(destPathName).concat(String.valueOf(this.m_files.getFile(i).getFileName())), option);
            ++count;
        }
        return count;
    }

    public int getSize() {
        return this.m_totalBytes;
    }

    public byte getBinaryData(int index) {
        byte retval;
        try {
            retval = this.m_binArray[index];
        }
        catch (Exception e) {
            throw new ArrayIndexOutOfBoundsException("Index out of range (1005).");
        }
        return retval;
    }

    public Files getFiles() {
        return this.m_files;
    }

    public Request getRequest() {
        return this.m_formRequest;
    }

    public void downloadFile(String sourceFilePathName) throws SmartUploadException, IOException, ServletException {
        this.downloadFile(sourceFilePathName, null, null);
    }

    public void downloadFile(String sourceFilePathName, String contentType) throws SmartUploadException, IOException, ServletException {
        this.downloadFile(sourceFilePathName, contentType, null);
    }

    public void downloadFile(String sourceFilePathName, String contentType, String destFileName) throws SmartUploadException, IOException, ServletException {
        this.downloadFile(sourceFilePathName, contentType, destFileName, 65000);
    }

    public void downloadFile(String sourceFilePathName, String contentType, String destFileName, int blockSize) throws SmartUploadException, IOException, ServletException {
        if (sourceFilePathName == null) {
            throw new IllegalArgumentException(String.valueOf(new StringBuffer("File '").append(sourceFilePathName).append("' not found (1040).")));
        }
        if (sourceFilePathName.equals("")) {
            throw new IllegalArgumentException(String.valueOf(new StringBuffer("File '").append(sourceFilePathName).append("' not found (1040).")));
        }
        if (!this.isVirtual(sourceFilePathName) && this.m_denyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        if (this.isVirtual(sourceFilePathName)) {
            sourceFilePathName = this.m_application.getRealPath(sourceFilePathName);
        }
        java.io.File file = new java.io.File(sourceFilePathName);
        FileInputStream fileIn = new FileInputStream(file);
        long fileLen = file.length();
        int readBytes = 0;
        int totalRead = 0;
        byte[] b = new byte[blockSize];
        if (contentType == null) {
            this.m_response.setContentType("application/x-msdownload");
        } else if (contentType.length() == 0) {
            this.m_response.setContentType("application/x-msdownload");
        } else {
            this.m_response.setContentType(contentType);
        }
        this.m_response.setContentLength((int)fileLen);
        String string = this.m_contentDisposition = this.m_contentDisposition == null ? "attachment;" : this.m_contentDisposition;
        if (destFileName == null) {
            this.m_response.setHeader("Content-Disposition", String.valueOf(new StringBuffer(String.valueOf(this.m_contentDisposition)).append(" filename=").append(this.getFileName(sourceFilePathName))));
        } else if (destFileName.length() == 0) {
            this.m_response.setHeader("Content-Disposition", this.m_contentDisposition);
        } else {
            this.m_response.setHeader("Content-Disposition", String.valueOf(new StringBuffer(String.valueOf(this.m_contentDisposition)).append(" filename=").append(destFileName)));
        }
        while ((long)totalRead < fileLen) {
            readBytes = fileIn.read(b, 0, blockSize);
            totalRead += readBytes;
            this.m_response.getOutputStream().write(b, 0, readBytes);
        }
        fileIn.close();
    }

    public void downloadField(ResultSet rs, String columnName, String contentType, String destFileName) throws SQLException, IOException, ServletException {
        if (rs == null) {
            throw new IllegalArgumentException("The RecordSet cannot be null (1045).");
        }
        if (columnName == null) {
            throw new IllegalArgumentException("The columnName cannot be null (1050).");
        }
        if (columnName.length() == 0) {
            throw new IllegalArgumentException("The columnName cannot be empty (1055).");
        }
        byte[] b = rs.getBytes(columnName);
        if (contentType == null) {
            this.m_response.setContentType("application/x-msdownload");
        } else if (contentType.length() == 0) {
            this.m_response.setContentType("application/x-msdownload");
        } else {
            this.m_response.setContentType(contentType);
        }
        this.m_response.setContentLength(b.length);
        if (destFileName == null) {
            this.m_response.setHeader("Content-Disposition", "attachment;");
        } else if (destFileName.length() == 0) {
            this.m_response.setHeader("Content-Disposition", "attachment;");
        } else {
            this.m_response.setHeader("Content-Disposition", "attachment; filename=".concat(String.valueOf(destFileName)));
        }
        this.m_response.getOutputStream().write(b, 0, b.length);
    }

    public void fieldToFile(ResultSet rs, String columnName, String destFilePathName) throws SQLException, SmartUploadException, IOException, ServletException {
        try {
            int c;
            if (this.m_application.getRealPath(destFilePathName) != null) {
                destFilePathName = this.m_application.getRealPath(destFilePathName);
            }
            InputStream is_data = rs.getBinaryStream(columnName);
            FileOutputStream file = new FileOutputStream(destFilePathName);
            while ((c = is_data.read()) != -1) {
                file.write(c);
            }
            file.close();
        }
        catch (Exception e) {
            throw new SmartUploadException("Unable to save file from the DataBase (1020).");
        }
    }

    private String getDataFieldValue(String dataHeader, String fieldName) {
        String token = new String();
        String value = new String();
        int pos = 0;
        int i = 0;
        int start = 0;
        int end = 0;
        token = String.valueOf(new StringBuffer(String.valueOf(fieldName)).append("=").append('\"'));
        pos = dataHeader.indexOf(token);
        if (pos > 0) {
            start = i = pos + token.length();
            token = "\"";
            end = dataHeader.indexOf(token, i);
            if (start > 0 && end > 0) {
                value = dataHeader.substring(start, end);
            }
        }
        return value;
    }

    private String getFileExt(String fileName) {
        String value = new String();
        int start = 0;
        int end = 0;
        if (fileName == null) {
            return null;
        }
        start = fileName.lastIndexOf(46) + 1;
        end = fileName.length();
        value = fileName.substring(start, end);
        if (fileName.lastIndexOf(46) > 0) {
            return value;
        }
        return "";
    }

    private String getContentType(String dataHeader) {
        String token = new String();
        String value = new String();
        int start = 0;
        int end = 0;
        token = "Content-Type:";
        start = dataHeader.indexOf(token) + token.length();
        if (start != -1) {
            end = dataHeader.length();
            value = dataHeader.substring(start, end);
        }
        return value;
    }

    private String getTypeMIME(String ContentType) {
        String value = new String();
        int pos = 0;
        pos = ContentType.indexOf("/");
        if (pos != -1) {
            return ContentType.substring(1, pos);
        }
        return ContentType;
    }

    private String getSubTypeMIME(String ContentType) {
        String value = new String();
        int start = 0;
        int end = 0;
        start = ContentType.indexOf("/") + 1;
        if (start != -1) {
            end = ContentType.length();
            return ContentType.substring(start, end);
        }
        return ContentType;
    }

    private String getContentDisp(String dataHeader) {
        String value = new String();
        int start = 0;
        int end = 0;
        start = dataHeader.indexOf(":") + 1;
        end = dataHeader.indexOf(";");
        value = dataHeader.substring(start, end);
        return value;
    }

    private void getDataSection() {
        boolean found = false;
        String dataHeader = new String();
        int searchPos = this.m_currentIndex;
        int keyPos = 0;
        int boundaryLen = this.m_boundary.length();
        this.m_startData = this.m_currentIndex;
        this.m_endData = 0;
        while (searchPos < this.m_totalBytes) {
            if (this.m_binArray[searchPos] == (byte)this.m_boundary.charAt(keyPos)) {
                if (keyPos == boundaryLen - 1) {
                    this.m_endData = searchPos - boundaryLen + 1 - 3;
                    break;
                }
                ++searchPos;
                ++keyPos;
                continue;
            }
            ++searchPos;
            keyPos = 0;
        }
        this.m_currentIndex = this.m_endData + boundaryLen + 3;
    }

    private String getDataHeader() {
        int start = this.m_currentIndex;
        int end = 0;
        boolean len = false;
        boolean found = false;
        while (!found) {
            if (this.m_binArray[this.m_currentIndex] == 13 && this.m_binArray[this.m_currentIndex + 2] == 13) {
                found = true;
                end = this.m_currentIndex - 1;
                this.m_currentIndex += 2;
                continue;
            }
            ++this.m_currentIndex;
        }
        String dataHeader = new String(this.m_binArray, start, end - start + 1);
        return dataHeader;
    }

    private String getFileName(String filePathName) {
        String token = new String();
        String value = new String();
        int pos = 0;
        boolean i = false;
        boolean start = false;
        boolean end = false;
        pos = filePathName.lastIndexOf(47);
        if (pos != -1) {
            return filePathName.substring(pos + 1, filePathName.length());
        }
        pos = filePathName.lastIndexOf(92);
        if (pos != -1) {
            return filePathName.substring(pos + 1, filePathName.length());
        }
        return filePathName;
    }

    public void setDeniedFilesList(String deniedFilesList) throws SQLException, IOException, ServletException {
        String ext = "";
        if (deniedFilesList != null) {
            ext = "";
            for (int i = 0; i < deniedFilesList.length(); ++i) {
                if (deniedFilesList.charAt(i) == ',') {
                    if (!this.m_deniedFilesList.contains(ext)) {
                        this.m_deniedFilesList.addElement(ext);
                    }
                    ext = "";
                    continue;
                }
                ext = String.valueOf(ext).concat(String.valueOf(deniedFilesList.charAt(i)));
            }
            if (ext != "") {
                this.m_deniedFilesList.addElement(ext);
            }
        } else {
            this.m_deniedFilesList = null;
        }
    }

    public void setAllowedFilesList(String allowedFilesList) {
        String ext = "";
        if (allowedFilesList != null) {
            ext = "";
            for (int i = 0; i < allowedFilesList.length(); ++i) {
                if (allowedFilesList.charAt(i) == ',') {
                    if (!this.m_allowedFilesList.contains(ext)) {
                        this.m_allowedFilesList.addElement(ext);
                    }
                    ext = "";
                    continue;
                }
                ext = String.valueOf(ext).concat(String.valueOf(allowedFilesList.charAt(i)));
            }
            if (ext != "") {
                this.m_allowedFilesList.addElement(ext);
            }
        } else {
            this.m_allowedFilesList = null;
        }
    }

    public void setDenyPhysicalPath(boolean deny) {
        this.m_denyPhysicalPath = deny;
    }

    public void setForcePhysicalPath(boolean force) {
        this.m_forcePhysicalPath = force;
    }

    public void setContentDisposition(String contentDisposition) {
        this.m_contentDisposition = contentDisposition;
    }

    public void setTotalMaxFileSize(long totalMaxFileSize) {
        this.m_totalMaxFileSize = totalMaxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.m_maxFileSize = maxFileSize;
    }

    protected String getPhysicalPath(String filePathName, int option) throws IOException {
        java.io.File physicalPath;
        String path = new String();
        String fileName = new String();
        String fileSeparator = new String();
        boolean isPhysical = false;
        fileSeparator = System.getProperty("file.separator");
        if (filePathName == null) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        if (filePathName.equals("")) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        if (filePathName.lastIndexOf("\\") >= 0) {
            path = filePathName.substring(0, filePathName.lastIndexOf("\\"));
            fileName = filePathName.substring(filePathName.lastIndexOf("\\") + 1);
        }
        if (filePathName.lastIndexOf("/") >= 0) {
            path = filePathName.substring(0, filePathName.lastIndexOf("/"));
            fileName = filePathName.substring(filePathName.lastIndexOf("/") + 1);
        }
        if ((physicalPath = new java.io.File(path = path.length() == 0 ? "/" : path)).exists()) {
            isPhysical = true;
        }
        if (option == 0) {
            if (this.isVirtual(path)) {
                path = (path = this.m_application.getRealPath(path)).endsWith(fileSeparator) ? String.valueOf(path).concat(String.valueOf(fileName)) : String.valueOf(new StringBuffer(String.valueOf(path)).append(fileSeparator).append(fileName));
                return path;
            }
            if (isPhysical) {
                if (this.m_denyPhysicalPath) {
                    throw new IllegalArgumentException("Physical path is denied (1125).");
                }
                return filePathName;
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        if (option == 1) {
            if (this.isVirtual(path)) {
                path = (path = this.m_application.getRealPath(path)).endsWith(fileSeparator) ? String.valueOf(path).concat(String.valueOf(fileName)) : String.valueOf(new StringBuffer(String.valueOf(path)).append(fileSeparator).append(fileName));
                return path;
            }
            if (isPhysical) {
                throw new IllegalArgumentException("The path is not a virtual path.");
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        if (option == 2) {
            if (isPhysical) {
                if (this.m_denyPhysicalPath) {
                    throw new IllegalArgumentException("Physical path is denied (1125).");
                }
                return filePathName;
            }
            if (this.isVirtual(path)) {
                throw new IllegalArgumentException("The path is not a physical path.");
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        return null;
    }

    public void uploadInFile(String destFilePathName) throws SmartUploadException, IOException {
        int intsize = 0;
        int readBytes = 0;
        if (destFilePathName == null) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (destFilePathName.length() == 0) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (!this.isVirtual(destFilePathName) && this.m_denyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        intsize = this.m_request.getContentLength();
        this.m_binArray = new byte[intsize];
        for (int pos = 0; pos < intsize; pos += readBytes) {
            try {
                readBytes = this.m_request.getInputStream().read(this.m_binArray, pos, intsize - pos);
                continue;
            }
            catch (Exception e) {
                throw new SmartUploadException("Unable to upload.");
            }
        }
        if (this.isVirtual(destFilePathName)) {
            destFilePathName = this.m_application.getRealPath(destFilePathName);
        }
        try {
            java.io.File file = new java.io.File(destFilePathName);
            FileOutputStream fileOut = new FileOutputStream(file);
            fileOut.write(this.m_binArray);
            fileOut.close();
        }
        catch (Exception e) {
            throw new SmartUploadException("The Form cannot be saved in the specified file (1030).");
        }
    }

    private boolean isVirtual(String pathName) {
        if (this.m_application.getRealPath(pathName) != null) {
            java.io.File virtualFile = new java.io.File(this.m_application.getRealPath(pathName));
            return virtualFile.exists();
        }
        return false;
    }
}

