/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceEntityResolver
extends DelegatingEntityResolver {
    private final ResourceLoader resourceLoader;

    public ResourceEntityResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = super.resolveEntity(publicId, systemId);
        if (source == null && systemId != null) {
            String resourcePath = null;
            try {
                String decodedSystemId = URLDecoder.decode(systemId);
                String givenUrl = new URL(decodedSystemId).toString();
                String systemRootUrl = new File("").toURL().toString();
                if (givenUrl.startsWith(systemRootUrl)) {
                    resourcePath = givenUrl.substring(systemRootUrl.length());
                }
            }
            catch (MalformedURLException ex) {
                resourcePath = systemId;
            }
            if (resourcePath != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Trying to locate XML entity [" + systemId + "] as resource [" + resourcePath + "]"));
                }
                Resource resource = this.resourceLoader.getResource(resourcePath);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found XML entity [" + systemId + "] as resource [" + resourcePath + "]"));
                }
                source = new InputSource(resource.getInputStream());
                source.setPublicId(publicId);
                source.setSystemId(systemId);
            }
        }
        return source;
    }
}

