/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class NestedCheckedException
extends Exception {
    private static final long serialVersionUID = 7100714597678207546L;
    private Throwable cause;

    public NestedCheckedException(String msg) {
        super(msg);
    }

    public NestedCheckedException(String msg, Throwable ex) {
        super(msg);
        this.cause = ex;
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public String getMessage() {
        String message = super.getMessage();
        Throwable cause = this.getCause();
        if (cause != null) {
            return message + "; nested exception is " + cause;
        }
        return message;
    }

    public void printStackTrace(PrintStream ps) {
        if (this.getCause() == null) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            ps.print("Caused by: ");
            this.getCause().printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.getCause() == null) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            pw.print("Caused by: ");
            this.getCause().printStackTrace(pw);
        }
    }

    public Throwable getRootCause() {
        Throwable cause = this.getCause();
        if (cause instanceof NestedCheckedException) {
            return ((NestedCheckedException)cause).getRootCause();
        }
        return cause;
    }

    public boolean contains(Class exClass) {
        if (exClass == null) {
            return false;
        }
        if (exClass.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause instanceof NestedCheckedException) {
            return ((NestedCheckedException)cause).contains(exClass);
        }
        return cause != null && exClass.isInstance(cause);
    }
}

