/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.JpaDialect;

public abstract class JpaAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private JpaDialect jpaDialect = new DefaultJpaDialect();
    private boolean flushEager = false;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setJpaDialect(JpaDialect jpaDialect) {
        this.jpaDialect = jpaDialect != null ? jpaDialect : new DefaultJpaDialect();
    }

    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public void setFlushEager(boolean flushEager) {
        this.flushEager = flushEager;
    }

    public boolean isFlushEager() {
        return this.flushEager;
    }

    public void afterPropertiesSet() {
        JpaDialect jpaDialect;
        if (this.getEntityManagerFactory() == null && this.getEntityManager() == null) {
            throw new IllegalArgumentException("entityManagerFactory or entityManager is required");
        }
        if (this.getEntityManagerFactory() instanceof EntityManagerFactoryInfo && (jpaDialect = ((EntityManagerFactoryInfo)this.getEntityManagerFactory()).getJpaDialect()) != null) {
            this.setJpaDialect(jpaDialect);
        }
    }

    public void flushIfNecessary(EntityManager em, boolean existingTransaction) throws PersistenceException {
        if (this.isFlushEager()) {
            this.logger.debug((Object)"Eagerly flushing JPA entity manager");
            em.flush();
        }
    }

    public RuntimeException translateIfNecessary(RuntimeException ex) {
        return DataAccessUtils.translateIfNecessary(ex, this.getJpaDialect());
    }
}

