/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import org.springframework.beans.BeanUtils;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;

public class LocalEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean {
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        if (this.getPersistenceProviderClass() != null) {
            PersistenceProvider pp = (PersistenceProvider)BeanUtils.instantiateClass(this.getPersistenceProviderClass());
            EntityManagerFactory emf = pp.createEntityManagerFactory(this.getPersistenceUnitName(), this.getJpaPropertyMap());
            if (emf == null) {
                throw new IllegalStateException("PersistenceProvider [" + pp + "] did not return an EntityManagerFactory for name '" + this.getPersistenceUnitName() + "'");
            }
            return emf;
        }
        return Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)this.getJpaPropertyMap());
    }
}

