/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.i18n.SimpleLocaleContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.scope.RequestContextHolder;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.portlet.FrameworkPortlet;
import org.springframework.web.portlet.HandlerAdapter;
import org.springframework.web.portlet.HandlerExceptionResolver;
import org.springframework.web.portlet.HandlerExecutionChain;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.HandlerMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.context.PortletRequestAttributes;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.web.portlet.multipart.PortletMultipartResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewRendererServlet;
import org.springframework.web.servlet.ViewResolver;

public class DispatcherPortlet
extends FrameworkPortlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "portletMultipartResolver";
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";
    public static final String HANDLER_ADAPTER_BEAN_NAME = "handlerAdapter";
    public static final String HANDLER_EXCEPTION_RESOLVER_BEAN_NAME = "handlerExceptionResolver";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String DEFAULT_VIEW_RENDERER_URL = "/WEB-INF/servlet/view";
    public static final String HANDLER_EXECUTION_CHAIN_ATTRIBUTE = (class$org$springframework$web$portlet$DispatcherPortlet == null ? (class$org$springframework$web$portlet$DispatcherPortlet = DispatcherPortlet.class$("org.springframework.web.portlet.DispatcherPortlet")) : class$org$springframework$web$portlet$DispatcherPortlet).getName() + ".HANDLER";
    private static final String ACTION_EXCEPTION_SESSION_ATTRIBUTE = (class$org$springframework$web$portlet$DispatcherPortlet == null ? (class$org$springframework$web$portlet$DispatcherPortlet = DispatcherPortlet.class$("org.springframework.web.portlet.DispatcherPortlet")) : class$org$springframework$web$portlet$DispatcherPortlet).getName() + ".ACTION_EXCEPTION";
    private static final String ACTION_EXCEPTION_RENDER_PARAMETER = "actionException";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.portlet.PageNotFound";
    private static final String DEFAULT_STRATEGIES_PATH = "DispatcherPortlet.properties";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.portlet.PageNotFound");
    private static final Properties defaultStrategies;
    private boolean detectAllHandlerMappings = true;
    private boolean detectAllHandlerAdapters = true;
    private boolean detectAllHandlerExceptionResolvers = true;
    private boolean detectAllViewResolvers = true;
    private String viewRendererUrl = "/WEB-INF/servlet/view";
    private PortletMultipartResolver multipartResolver;
    private List handlerMappings;
    private List handlerAdapters;
    private List handlerExceptionResolvers;
    private List viewResolvers;
    static /* synthetic */ Class class$org$springframework$web$portlet$DispatcherPortlet;
    static /* synthetic */ Class class$org$springframework$web$portlet$multipart$PortletMultipartResolver;
    static /* synthetic */ Class class$org$springframework$web$portlet$HandlerMapping;
    static /* synthetic */ Class class$org$springframework$web$portlet$HandlerAdapter;
    static /* synthetic */ Class class$org$springframework$web$portlet$HandlerExceptionResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$ViewResolver;

    public void setDetectAllHandlerMappings(boolean detectAllHandlerMappings) {
        this.detectAllHandlerMappings = detectAllHandlerMappings;
    }

    public void setDetectAllHandlerAdapters(boolean detectAllHandlerAdapters) {
        this.detectAllHandlerAdapters = detectAllHandlerAdapters;
    }

    public void setDetectAllHandlerExceptionResolvers(boolean detectAllHandlerExceptionResolvers) {
        this.detectAllHandlerExceptionResolvers = detectAllHandlerExceptionResolvers;
    }

    public void setDetectAllViewResolvers(boolean detectAllViewResolvers) {
        this.detectAllViewResolvers = detectAllViewResolvers;
    }

    public void setViewRendererUrl(String viewRendererUrl) {
        this.viewRendererUrl = viewRendererUrl;
    }

    protected void initFrameworkPortlet() throws PortletException, BeansException {
        this.initMultipartResolver();
        this.initHandlerMappings();
        this.initHandlerAdapters();
        this.initHandlerExceptionResolvers();
        this.initViewResolvers();
    }

    private void initMultipartResolver() throws BeansException {
        block3: {
            try {
                this.multipartResolver = (PortletMultipartResolver)this.getPortletApplicationContext().getBean(MULTIPART_RESOLVER_BEAN_NAME, class$org$springframework$web$portlet$multipart$PortletMultipartResolver == null ? (class$org$springframework$web$portlet$multipart$PortletMultipartResolver = DispatcherPortlet.class$("org.springframework.web.portlet.multipart.PortletMultipartResolver")) : class$org$springframework$web$portlet$multipart$PortletMultipartResolver);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using MultipartResolver [" + this.multipartResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.multipartResolver = null;
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info((Object)"Unable to locate PortletMultipartResolver with name 'portletMultipartResolver': no multipart request handling provided");
            }
        }
    }

    private void initHandlerMappings() throws BeansException {
        if (this.detectAllHandlerMappings) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.getPortletApplicationContext(), class$org$springframework$web$portlet$HandlerMapping == null ? (class$org$springframework$web$portlet$HandlerMapping = DispatcherPortlet.class$("org.springframework.web.portlet.HandlerMapping")) : class$org$springframework$web$portlet$HandlerMapping, true, false);
            if (!matchingBeans.isEmpty()) {
                this.handlerMappings = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerMappings, new OrderComparator());
            }
        } else {
            try {
                Object hm = this.getPortletApplicationContext().getBean(HANDLER_MAPPING_BEAN_NAME, class$org$springframework$web$portlet$HandlerMapping == null ? (class$org$springframework$web$portlet$HandlerMapping = DispatcherPortlet.class$("org.springframework.web.portlet.HandlerMapping")) : class$org$springframework$web$portlet$HandlerMapping);
                this.handlerMappings = Collections.singletonList(hm);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerMappings == null) {
            this.handlerMappings = this.getDefaultStrategies(class$org$springframework$web$portlet$HandlerMapping == null ? (class$org$springframework$web$portlet$HandlerMapping = DispatcherPortlet.class$("org.springframework.web.portlet.HandlerMapping")) : class$org$springframework$web$portlet$HandlerMapping);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No HandlerMappings found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    private void initHandlerAdapters() throws BeansException {
        if (this.detectAllHandlerAdapters) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.getPortletApplicationContext(), class$org$springframework$web$portlet$HandlerAdapter == null ? (class$org$springframework$web$portlet$HandlerAdapter = DispatcherPortlet.class$("org.springframework.web.portlet.HandlerAdapter")) : class$org$springframework$web$portlet$HandlerAdapter, true, false);
            if (!matchingBeans.isEmpty()) {
                this.handlerAdapters = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerAdapters, new OrderComparator());
            }
        } else {
            try {
                Object ha = this.getPortletApplicationContext().getBean(HANDLER_ADAPTER_BEAN_NAME, class$org$springframework$web$portlet$HandlerAdapter == null ? (class$org$springframework$web$portlet$HandlerAdapter = DispatcherPortlet.class$("org.springframework.web.portlet.HandlerAdapter")) : class$org$springframework$web$portlet$HandlerAdapter);
                this.handlerAdapters = Collections.singletonList(ha);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerAdapters == null) {
            this.handlerAdapters = this.getDefaultStrategies(class$org$springframework$web$portlet$HandlerAdapter == null ? (class$org$springframework$web$portlet$HandlerAdapter = DispatcherPortlet.class$("org.springframework.web.portlet.HandlerAdapter")) : class$org$springframework$web$portlet$HandlerAdapter);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No HandlerAdapters found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    private void initHandlerExceptionResolvers() throws BeansException {
        if (this.detectAllHandlerExceptionResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.getPortletApplicationContext(), class$org$springframework$web$portlet$HandlerExceptionResolver == null ? (class$org$springframework$web$portlet$HandlerExceptionResolver = DispatcherPortlet.class$("org.springframework.web.portlet.HandlerExceptionResolver")) : class$org$springframework$web$portlet$HandlerExceptionResolver, true, false);
            this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
            Collections.sort(this.handlerExceptionResolvers, new OrderComparator());
        } else {
            try {
                Object her = this.getPortletApplicationContext().getBean(HANDLER_EXCEPTION_RESOLVER_BEAN_NAME, class$org$springframework$web$portlet$HandlerExceptionResolver == null ? (class$org$springframework$web$portlet$HandlerExceptionResolver = DispatcherPortlet.class$("org.springframework.web.portlet.HandlerExceptionResolver")) : class$org$springframework$web$portlet$HandlerExceptionResolver);
                this.handlerExceptionResolvers = Collections.singletonList(her);
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.handlerExceptionResolvers = this.getDefaultStrategies(class$org$springframework$web$portlet$HandlerExceptionResolver == null ? (class$org$springframework$web$portlet$HandlerExceptionResolver = DispatcherPortlet.class$("org.springframework.web.portlet.HandlerExceptionResolver")) : class$org$springframework$web$portlet$HandlerExceptionResolver);
            }
        }
    }

    private void initViewResolvers() throws BeansException {
        if (this.detectAllViewResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.getPortletApplicationContext(), class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherPortlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver, true, false);
            if (!matchingBeans.isEmpty()) {
                this.viewResolvers = new ArrayList(matchingBeans.values());
                Collections.sort(this.viewResolvers, new OrderComparator());
            }
        } else {
            try {
                Object vr = this.getPortletApplicationContext().getBean(VIEW_RESOLVER_BEAN_NAME, class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherPortlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver);
                this.viewResolvers = Collections.singletonList(vr);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.viewResolvers == null) {
            this.viewResolvers = this.getDefaultStrategies(class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherPortlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No ViewResolvers found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    protected Object getDefaultStrategy(Class strategyInterface) throws BeansException {
        List strategies = this.getDefaultStrategies(strategyInterface);
        if (strategies.size() != 1) {
            throw new BeanInitializationException("DispatcherPortlet needs exactly 1 strategy for interface [" + strategyInterface.getName() + "]");
        }
        return strategies.get(0);
    }

    protected List getDefaultStrategies(Class strategyInterface) throws BeansException {
        String key = strategyInterface.getName();
        try {
            ArrayList<Object> strategies = null;
            String value = defaultStrategies.getProperty(key);
            if (value != null) {
                String[] classNames = StringUtils.commaDelimitedListToStringArray(value);
                strategies = new ArrayList<Object>(classNames.length);
                for (int i = 0; i < classNames.length; ++i) {
                    Class clazz = ClassUtils.forName(classNames[i], ((Object)((Object)this)).getClass().getClassLoader());
                    Object strategy = this.createDefaultStrategy(clazz);
                    strategies.add(strategy);
                }
            } else {
                strategies = Collections.EMPTY_LIST;
            }
            return strategies;
        }
        catch (ClassNotFoundException ex) {
            throw new BeanInitializationException("Could not find DispatcherPortlet's default strategy class for interface [" + key + "]", ex);
        }
    }

    protected Object createDefaultStrategy(Class clazz) {
        return this.getPortletApplicationContext().getAutowireCapableBeanFactory().createBean(clazz, 0, false);
    }

    protected void doActionService(ActionRequest request, ActionResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherPortlet with name '" + this.getPortletName() + "' received action request"));
        }
        ActionRequest processedRequest = request;
        HandlerExecutionChain mappedHandler = null;
        int interceptorIndex = -1;
        LocaleContextHolder.setLocaleContext(new SimpleLocaleContext(request.getLocale()));
        PortletRequestAttributes requestAttributes = new PortletRequestAttributes((PortletRequest)request);
        RequestContextHolder.setRequestAttributes(requestAttributes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bound request context to thread: " + request));
        }
        try {
            processedRequest = this.checkMultipart(request);
            mappedHandler = this.getHandler((PortletRequest)processedRequest, false);
            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                this.noHandlerFound((PortletRequest)processedRequest, (PortletResponse)response);
                return;
            }
            if (mappedHandler.getInterceptors() != null) {
                int i = 0;
                while (i < mappedHandler.getInterceptors().length) {
                    HandlerInterceptor interceptor = mappedHandler.getInterceptors()[i];
                    if (!interceptor.preHandleAction(processedRequest, response, mappedHandler.getHandler())) {
                        this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, null);
                        return;
                    }
                    interceptorIndex = i++;
                }
            }
            HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
            ha.handleAction(processedRequest, response, mappedHandler.getHandler());
            this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, null);
        }
        catch (Exception ex) {
            this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, ex);
            this.logger.debug((Object)"Caught exception during action phase - forwarding to render phase", (Throwable)ex);
            PortletSession session = request.getPortletSession();
            session.setAttribute(ACTION_EXCEPTION_SESSION_ATTRIBUTE, (Object)ex);
            response.setRenderParameter(ACTION_EXCEPTION_RENDER_PARAMETER, ex.toString());
        }
        catch (Error err) {
            PortletException ex = new PortletException("Error occured during request processing: " + err.getMessage(), (Throwable)err);
            this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, (Exception)ex);
            throw ex;
        }
        finally {
            if (processedRequest instanceof MultipartActionRequest && processedRequest != request) {
                this.multipartResolver.cleanupMultipart((MultipartActionRequest)processedRequest);
            }
            requestAttributes.updateAccessedAttributes();
            RequestContextHolder.setRequestAttributes(null);
            LocaleContextHolder.setLocaleContext(null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleared thread-bound request context: " + request));
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void doRenderService(RenderRequest request, RenderResponse response) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ActionRequest checkMultipart(ActionRequest request) throws MultipartException {
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
            if (request instanceof MultipartActionRequest) {
                this.logger.debug((Object)"Request is already a MultipartActionRequest - probably in a forward");
            } else {
                return this.multipartResolver.resolveMultipart(request);
            }
        }
        return request;
    }

    protected HandlerExecutionChain getHandler(PortletRequest request, boolean cache) throws Exception {
        HandlerExecutionChain handler = (HandlerExecutionChain)request.getAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
        if (handler != null) {
            if (!cache) {
                request.removeAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
            }
            return handler;
        }
        Iterator it = this.handlerMappings.iterator();
        while (it.hasNext()) {
            HandlerMapping hm = (HandlerMapping)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler map [" + hm + "] in DispatcherPortlet with name '" + this.getPortletName() + "'"));
            }
            if ((handler = hm.getHandler(request)) == null) continue;
            if (cache) {
                request.setAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE, (Object)handler);
            }
            return handler;
        }
        return null;
    }

    protected void noHandlerFound(PortletRequest request, PortletResponse response) throws PortletException {
        if (pageNotFoundLogger.isWarnEnabled()) {
            pageNotFoundLogger.warn((Object)("No mapping found for current request in DispatcherPortlet with name '" + this.getPortletName() + "'" + " mode '" + request.getPortletMode() + "'" + " type '" + (request instanceof ActionRequest ? "action" : "render") + "'" + " session '" + request.getRequestedSessionId() + "'" + " user '" + this.getUsernameForRequest(request) + "'"));
        }
        throw new UnavailableException("No handler found for request");
    }

    protected HandlerAdapter getHandlerAdapter(Object handler) throws PortletException {
        Iterator it = this.handlerAdapters.iterator();
        while (it.hasNext()) {
            HandlerAdapter ha = (HandlerAdapter)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler adapter [" + ha + "]"));
            }
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new PortletException("No adapter for handler [" + handler + "]: Does your handler implement a supported interface like Controller?");
    }

    protected ModelAndView processHandlerException(RenderRequest request, RenderResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView exMv = null;
        Iterator it = this.handlerExceptionResolvers.iterator();
        while (exMv == null && it.hasNext()) {
            HandlerExceptionResolver resolver = (HandlerExceptionResolver)it.next();
            exMv = resolver.resolveException(request, response, handler, ex);
        }
        if (exMv != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HandlerExceptionResolver returned ModelAndView [" + exMv + "] for exception"));
            }
            this.logger.warn((Object)"Handler execution resulted in exception - forwarding to resolved error view", (Throwable)ex);
            return exMv;
        }
        throw ex;
    }

    private void triggerAfterActionCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, ActionRequest request, ActionResponse response, Exception ex) throws Exception {
        if (mappedHandler != null && mappedHandler.getInterceptors() != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                HandlerInterceptor interceptor = mappedHandler.getInterceptors()[i];
                try {
                    interceptor.afterActionCompletion(request, response, mappedHandler.getHandler(), ex);
                    continue;
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }

    protected void render(ModelAndView mv, RenderRequest request, RenderResponse response) throws Exception {
        View view = null;
        if (mv.isReference()) {
            view = this.resolveViewName(mv.getViewName(), mv.getModelInternal(), request);
            if (view == null) {
                throw new PortletException("Could not resolve view with name '" + mv.getViewName() + "' in portlet with name '" + this.getPortletName() + "'");
            }
        } else {
            Object viewObject = mv.getView();
            if (viewObject == null) {
                throw new PortletException("ModelAndView [" + mv + "] neither contains a view name nor a " + "View object in portlet with name '" + this.getPortletName() + "'");
            }
            if (!(viewObject instanceof View)) {
                throw new PortletException("View object [" + viewObject + "] is not an instance of [org.springframework.web.servlet.View] - " + "DispatcherPortlet does not support any other view types");
            }
            view = (View)viewObject;
        }
        if (view == null) {
            throw new PortletException("Could not resolve view with name '" + mv.getViewName() + "' in portlet with name '" + this.getPortletName() + "'");
        }
        if (response.getContentType() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Portlet response content type already set to [" + response.getContentType() + "]"));
            }
        } else {
            String contentType = view.getContentType();
            if (contentType != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting portlet response content type to view-determined type [" + contentType + "]"));
                }
                response.setContentType(contentType);
            }
        }
        request.setAttribute(ViewRendererServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.getPortletApplicationContext());
        request.setAttribute(ViewRendererServlet.VIEW_ATTRIBUTE, (Object)view);
        request.setAttribute(ViewRendererServlet.MODEL_ATTRIBUTE, (Object)mv.getModel());
        this.getPortletContext().getRequestDispatcher(this.viewRendererUrl).include(request, response);
    }

    protected View resolveViewName(String viewName, Map model, RenderRequest request) throws Exception {
        Iterator it = this.viewResolvers.iterator();
        while (it.hasNext()) {
            ViewResolver viewResolver = (ViewResolver)it.next();
            View view = viewResolver.resolveViewName(viewName, request.getLocale());
            if (view == null) continue;
            return view;
        }
        return null;
    }

    private void triggerAfterRenderCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, RenderRequest request, RenderResponse response, Exception ex) throws Exception {
        if (mappedHandler != null && mappedHandler.getInterceptors() != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                HandlerInterceptor interceptor = mappedHandler.getInterceptors()[i];
                try {
                    interceptor.afterRenderCompletion(request, response, mappedHandler.getHandler(), ex);
                    continue;
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, class$org$springframework$web$portlet$DispatcherPortlet == null ? (class$org$springframework$web$portlet$DispatcherPortlet = DispatcherPortlet.class$("org.springframework.web.portlet.DispatcherPortlet")) : class$org$springframework$web$portlet$DispatcherPortlet);
            defaultStrategies = PropertiesLoaderUtils.loadProperties(resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load 'DispatcherPortlet.properties': " + ex.getMessage());
        }
    }
}

