/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerXAConnection;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public final class SQLServerXADataSource
extends SQLServerConnectionPoolDataSource
implements XADataSource {
    static Logger xaLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.XA");

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getXAConnection", new Object[]{string, "Password not traced"});
        }
        SQLServerXAConnection sQLServerXAConnection = new SQLServerXAConnection(this, string, string2);
        if (xaLogger.isLoggable(Level.FINER)) {
            xaLogger.finer(this.toString() + " user:" + string + sQLServerXAConnection.toString());
        }
        if (xaLogger.isLoggable(Level.FINER)) {
            xaLogger.finer(this.toString() + " Start get physical connection.");
        }
        SQLServerConnection sQLServerConnection = (SQLServerConnection)sQLServerXAConnection.getPhysicalConnection();
        if (xaLogger.isLoggable(Level.FINE)) {
            xaLogger.fine(this.toString() + " End get physical connection, " + sQLServerConnection.toString());
        }
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getXAConnection", sQLServerXAConnection);
        }
        return sQLServerXAConnection;
    }

    public XAConnection getXAConnection() throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getXAConnection");
        }
        return this.getXAConnection(this.getUser(), this.getPassword());
    }

    public Reference getReference() {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getReference");
        }
        Reference reference = this.getReferenceInternal("com.microsoft.sqlserver.jdbc.SQLServerXADataSource");
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getReference", reference);
        }
        return reference;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("");
    }

    private static class SerializationProxy
    implements Serializable {
        private final Reference ref;
        private static final long serialVersionUID = 454661379842314126L;

        SerializationProxy(SQLServerXADataSource sQLServerXADataSource) {
            this.ref = sQLServerXADataSource.getReferenceInternal(null);
        }

        private Object readResolve() {
            SQLServerXADataSource sQLServerXADataSource = new SQLServerXADataSource();
            sQLServerXADataSource.initializeFromReference(this.ref);
            return sQLServerXADataSource;
        }
    }
}

