/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;

final class StreamColInfo
extends StreamPacket {
    private TDSReader tdsReader;
    private TDSReaderMark colInfoMark;

    StreamColInfo() {
        super(165);
    }

    void setFromTDS(TDSReader tDSReader) throws SQLServerException {
        if (165 != tDSReader.readUnsignedByte()) assert (false) : "Not a COLINFO token";
        this.tdsReader = tDSReader;
        int n = tDSReader.readUnsignedShort();
        this.colInfoMark = tDSReader.mark();
        tDSReader.skip(n);
    }

    int applyTo(Column[] columnArray) throws SQLServerException {
        int n = 0;
        TDSReaderMark tDSReaderMark = this.tdsReader.mark();
        this.tdsReader.reset(this.colInfoMark);
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            this.tdsReader.readUnsignedByte();
            column.setTableNum(this.tdsReader.readUnsignedByte());
            if (column.getTableNum() > n) {
                n = column.getTableNum();
            }
            column.setInfoStatus(this.tdsReader.readUnsignedByte());
            if (!column.hasDifferentName()) continue;
            column.setBaseColumnName(this.tdsReader.readUnicodeString(this.tdsReader.readUnsignedByte()));
        }
        this.tdsReader.reset(tDSReaderMark);
        return n;
    }
}

