/*
 * Decompiled with CFR 0.152.
 */
package tyrex.security.ldap;

import javax.security.auth.Destroyable;

public final class LDAPCredentials
implements Destroyable {
    private String _dn;
    private char[] _password;
    private String _host;
    private int _port;

    public LDAPCredentials(String string, int n, String string2, char[] cArray) {
        if (string == null) {
            throw new IllegalArgumentException("Argument 'host' is null");
        }
        this._host = string;
        this._port = n;
        if (string2 == null) {
            throw new IllegalArgumentException("Argument 'dn' is null");
        }
        this._dn = string2;
        this._password = (char[])cArray.clone();
    }

    public String getDN() {
        if (this._dn == null) {
            throw new IllegalArgumentException("This credentials have been destroyed");
        }
        return this._dn;
    }

    public String getHost() {
        if (this._dn == null) {
            throw new IllegalArgumentException("This credentials have been destroyed");
        }
        return this._host;
    }

    public int getPort() {
        if (this._dn == null) {
            throw new IllegalArgumentException("This credentials have been destroyed");
        }
        return this._port;
    }

    public char[] getPassword() {
        if (this._dn == null) {
            throw new IllegalArgumentException("This credentials have been destroyed");
        }
        return (char[])this._password.clone();
    }

    public void destroy() {
        this._dn = null;
        this._host = null;
        if (this._password != null) {
            int n = 0;
            while (n < this._password.length) {
                this._password[n] = '\u0000';
                ++n;
            }
            this._password = null;
        }
    }

    public boolean isDestroyed() {
        return this._dn == null;
    }
}

