/*
 * Decompiled with CFR 0.152.
 */
package tyrex.services;

import java.io.PrintWriter;
import tyrex.util.Configuration;
import tyrex.util.Logger;
import tyrex.util.Messages;

public class DaemonMaster
extends ThreadGroup
implements Runnable {
    private static final long CHECK_EVERY = 60000L;
    private DaemonRecord _first;
    private int _count;
    private static final DaemonMaster _instance = new DaemonMaster();

    private DaemonMaster() {
        super(Messages.message("tyrex.util.daemonMaster"));
        Thread thread = new Thread(this, this, Messages.message("tyrex.util.daemonMaster"));
        thread.setPriority(10);
        thread.setDaemon(true);
        thread.start();
    }

    public static int getCount() {
        return DaemonMaster._instance._count;
    }

    public static void addDaemon(Runnable runnable, String string) {
        DaemonMaster.addDaemon(runnable, string, 5);
    }

    public static void addDaemon(Runnable runnable, String string, int n) {
        DaemonMaster daemonMaster = _instance;
        synchronized (daemonMaster) {
            if (runnable == null) {
                throw new IllegalArgumentException("Argument runnable is null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Argument name is null");
            }
            DaemonRecord daemonRecord = DaemonMaster._instance._first;
            while (daemonRecord != null) {
                if (daemonRecord._runnable == runnable) {
                    return;
                }
                daemonRecord = daemonRecord._next;
            }
            Thread thread = new Thread(_instance, runnable, string);
            DaemonMaster._instance._first = new DaemonRecord(runnable, string, n, thread, DaemonMaster._instance._first);
            ++DaemonMaster._instance._count;
            if (Configuration.verbose) {
                Logger.tyrex.info((Object)("Starting daemon: " + string));
            }
            thread.setPriority(n);
            thread.start();
        }
    }

    public static boolean removeDaemon(Runnable runnable) {
        DaemonMaster daemonMaster = _instance;
        synchronized (daemonMaster) {
            DaemonRecord daemonRecord = DaemonMaster._instance._first;
            DaemonRecord daemonRecord2 = null;
            while (daemonRecord != null) {
                if (daemonRecord._runnable == runnable) {
                    if (daemonRecord2 == null) {
                        DaemonMaster._instance._first = daemonRecord._next;
                    } else {
                        daemonRecord2._next = daemonRecord._next;
                    }
                    --DaemonMaster._instance._count;
                    daemonRecord._thread.interrupt();
                    boolean bl = true;
                    return bl;
                }
                daemonRecord2 = daemonRecord;
                daemonRecord = daemonRecord._next;
            }
        }
        return false;
    }

    public static synchronized void dump(PrintWriter printWriter) {
        printWriter.println("Daemon master managing " + DaemonMaster._instance._count + " daemons");
        DaemonRecord daemonRecord = DaemonMaster._instance._first;
        while (daemonRecord != null) {
            printWriter.println("  " + daemonRecord._name);
            printWriter.println("    Thread:   " + daemonRecord._thread);
            printWriter.println("    Runnable: " + daemonRecord._runnable);
            printWriter.println("    Priority: " + daemonRecord._priority);
            daemonRecord = daemonRecord._next;
        }
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        Logger.tyrex.error((Object)("Uncaught exception in daemon " + thread.getName()), throwable);
        DaemonMaster daemonMaster = _instance;
        synchronized (daemonMaster) {
            _instance.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block4: while (true) {
                DaemonMaster daemonMaster = this;
                synchronized (daemonMaster) {
                    DaemonRecord daemonRecord = this._first;
                    while (true) {
                        if (daemonRecord == null) {
                            this.wait(60000L);
                            continue block4;
                        }
                        if (!daemonRecord._thread.isAlive()) {
                            Logger.tyrex.error((Object)("Detected daemon " + daemonRecord._name + " stopped: restarting"));
                            daemonRecord._thread = new Thread(this, daemonRecord._runnable, daemonRecord._name);
                            daemonRecord._thread.setPriority(daemonRecord._priority);
                            daemonRecord._thread.start();
                        }
                        daemonRecord = daemonRecord._next;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Logger.tyrex.error((Object)"Error reported by daemon master", throwable);
            return;
        }
    }

    private static class DaemonRecord {
        final Runnable _runnable;
        final String _name;
        final int _priority;
        Thread _thread;
        DaemonRecord _next;

        DaemonRecord(Runnable runnable, String string, int n, Thread thread, DaemonRecord daemonRecord) {
            this._name = string;
            this._runnable = runnable;
            this._priority = n;
            this._thread = thread;
            this._next = daemonRecord;
        }
    }
}

