/*
 * Decompiled with CFR 0.152.
 */
package tyrex.services;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import tyrex.services.Clock;
import tyrex.util.Configuration;
import tyrex.util.Logger;
import tyrex.util.Messages;

public final class UUID {
    public static final String PREFIX = "ID:";
    public static final int RESOLUTION_BYTES = 16;
    public static final int MAXIMUM_LENGTH = 64;
    public static final int MAXIMUM_PREFIX = 28;
    public static final String PROPERTY_NODE_IDENTIFIER = "uuid.nodeIdentifier";
    public static final String PROPERTY_CLOCK_SEQUENCE = "uuid.clockSequence";
    public static final String UUID_STATE_FILE = "uuid.state";
    private static final int UUID_VARIANT_OCTET = 8;
    private static final int UUID_VARIANT_BYTE = 128;
    private static final int UUID_VERSION_CLOCK_OCTET = 1;
    private static final int UUID_VERSION_CLOCK_BYTE = 16;
    private static final int UUID_VERSION_NAME_OCTET = 3;
    private static final int UUID_VERSION_NAME_BYTE = 48;
    private static final int UUID_VERSION_RANDOM_CLOCK = 4;
    private static final int UUID_VERSION_RANDOM_BYTE = 64;
    private static final long JAVA_UUID_CLOCK_DIFF = 12219292800000L;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static int _uuidsPerTick;
    private static int _uuidsThisTick;
    private static long _lastClock;
    private static char[] _clockSeqOctet;
    private static byte[] _clockSeqByte;
    private static char[] _nodeIdentifierOctet;
    private static byte[] _nodeIdentifierByte;
    static /* synthetic */ Class class$tyrex$services$UUID;

    public static String create() {
        return String.valueOf(UUID.createTimeUUIDChars());
    }

    public static String create(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument prefix is null");
        }
        StringBuffer stringBuffer = new StringBuffer(36 + string.length());
        stringBuffer.append(string);
        stringBuffer.append(UUID.createTimeUUIDChars());
        return stringBuffer.toString();
    }

    public static byte[] createBinary() {
        return UUID.createTimeUUIDBytes();
    }

    public static byte[] toBytes(String string, String string2) throws InvalidIDException {
        if (string2 == null) {
            throw new IllegalArgumentException("Argument identifier is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Argument prefix is null");
        }
        if (!string2.startsWith(string)) {
            throw new InvalidIDException(Messages.format("tyrex.util.idInvalidPrefix", string, string2));
        }
        int n = 0;
        byte[] byArray = new byte[(string2.length() - string.length()) / 2];
        int n2 = string.length();
        while (n2 < string2.length()) {
            char c = string2.charAt(n2);
            if (c != '-') {
                byte by;
                if (c >= '0' && c <= '9') {
                    by = (byte)(c - 48 << 4);
                } else if (c >= 'A' && c <= 'F') {
                    by = (byte)(c - 55 << 4);
                } else if (c >= 'a' && c <= 'f') {
                    by = (byte)(c - 87 << 4);
                } else {
                    throw new InvalidIDException(Messages.format("tyrex.util.idInvalidCharacter", String.valueOf(c), string2));
                }
                if (++n2 == string2.length()) {
                    throw new InvalidIDException(Messages.format("tyrex.util.idInvalidOddDigits", string2));
                }
                c = string2.charAt(n2);
                if (c >= '0' && c <= '9') {
                    by = (byte)(by | c - 48);
                } else if (c >= 'A' && c <= 'F') {
                    by = (byte)(by | c - 55);
                } else if (c >= 'a' && c <= 'f') {
                    by = (byte)(by | c - 87);
                } else {
                    throw new InvalidIDException(Messages.format("tyrex.util.idInvalidCharacter", String.valueOf(c), string2));
                }
                byArray[n] = by;
                ++n;
            }
            ++n2;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        while (n-- > 0) {
            byArray2[n] = byArray[n];
        }
        return byArray2;
    }

    public static byte[] toBytes(String string) throws InvalidIDException {
        if (string == null) {
            throw new IllegalArgumentException("Argument identifier is null");
        }
        int n = 0;
        byte[] byArray = new byte[string.length() / 2];
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c != '-') {
                byte by;
                if (c >= '0' && c <= '9') {
                    by = (byte)(c - 48 << 4);
                } else if (c >= 'A' && c <= 'F') {
                    by = (byte)(c - 55 << 4);
                } else if (c >= 'a' && c <= 'f') {
                    by = (byte)(c - 87 << 4);
                } else {
                    throw new InvalidIDException(Messages.format("tyrex.util.idInvalidCharacter", String.valueOf(c), string));
                }
                if (++n2 == string.length()) {
                    throw new InvalidIDException(Messages.format("tyrex.util.idInvalidOddDigits", string));
                }
                c = string.charAt(n2);
                if (c >= '0' && c <= '9') {
                    by = (byte)(by | c - 48);
                } else if (c >= 'A' && c <= 'F') {
                    by = (byte)(by | c - 55);
                } else if (c >= 'a' && c <= 'f') {
                    by = (byte)(by | c - 87);
                } else {
                    throw new InvalidIDException(Messages.format("tyrex.util.idInvalidCharacter", String.valueOf(c), string));
                }
                byArray[n] = by;
                ++n;
            }
            ++n2;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        while (n-- > 0) {
            byArray2[n] = byArray[n];
        }
        return byArray2;
    }

    public static String fromBytes(String string, byte[] byArray) {
        if (string == null) {
            throw new IllegalArgumentException("Argument prefix is null");
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Argument bytes is null or an empty array");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(HEX_DIGITS[(byArray[n] & 0xF0) >> 4]);
            stringBuffer.append(HEX_DIGITS[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String fromBytes(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Argument bytes is null or an empty array");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        while (n-- > 0) {
            stringBuffer.append(HEX_DIGITS[(byArray[n] & 0xF0) >> 4]);
            stringBuffer.append(HEX_DIGITS[byArray[n] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static String trim(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument identifier is null");
        }
        if (string.length() > 64) {
            return string.substring(0, 64);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static char[] createTimeUUIDChars() {
        var5 = UUID.class$tyrex$services$UUID == null ? (UUID.class$tyrex$services$UUID = UUID.class$("tyrex.services.UUID")) : UUID.class$tyrex$services$UUID;
        synchronized (var5) {
            var0_1 = Clock.clock();
            block5: while (true) {
                if (var0_1 > UUID._lastClock) {
                    var3_2 = UUID._lastClock + (long)(UUID._uuidsThisTick / 100);
                    if (var0_1 <= var3_2) {
                        var0_1 = Clock.synchronize();
                    }
                    if (var0_1 > var3_2) {
                        UUID._uuidsThisTick = 0;
                        UUID._lastClock = var0_1;
                        UUID._uuidsPerTick = Clock.getUnsynchTicks() * 100;
                        break;
                    }
                }
                if (UUID._uuidsThisTick + 1 < UUID._uuidsPerTick) {
                    ++UUID._uuidsThisTick;
                    break;
                }
                var0_1 = Clock.synchronize();
                if (var0_1 > UUID._lastClock) continue;
                if (Configuration.verbose) {
                    Logger.tyrex.debug((Object)Messages.message("tyrex.uuid.fastHolding"));
                }
                while (true) {
                    if (var0_1 <= UUID._lastClock) ** break;
                    continue block5;
                    try {
                        Thread.currentThread();
                        Thread.sleep(Clock.getUnsynchTicks());
                    }
                    catch (InterruptedException var6_3) {
                        // empty catch block
                    }
                    var0_1 = Clock.synchronize();
                }
                break;
            }
            var0_1 = (UUID._lastClock + 12219292800000L) * 100L + (long)UUID._uuidsThisTick;
            var2_4 = new char[]{UUID.HEX_DIGITS[(int)(var0_1 >> 28 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 24 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 20 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 16 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 12 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 8 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 4 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 & 15L)], '-', UUID.HEX_DIGITS[(int)(var0_1 >> 44 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 40 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 36 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 32 & 15L)], '-', UUID.HEX_DIGITS[(int)(var0_1 >> 60 & 15L | 1L)], UUID.HEX_DIGITS[(int)(var0_1 >> 56 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 52 & 15L)], UUID.HEX_DIGITS[(int)(var0_1 >> 48 & 15L)], '-', UUID._clockSeqOctet[0], UUID._clockSeqOctet[1], UUID._clockSeqOctet[2], UUID._clockSeqOctet[3], '-', UUID._nodeIdentifierOctet[0], UUID._nodeIdentifierOctet[1], UUID._nodeIdentifierOctet[2], UUID._nodeIdentifierOctet[3], UUID._nodeIdentifierOctet[4], UUID._nodeIdentifierOctet[5], UUID._nodeIdentifierOctet[6], UUID._nodeIdentifierOctet[7], UUID._nodeIdentifierOctet[8], UUID._nodeIdentifierOctet[9], UUID._nodeIdentifierOctet[10], UUID._nodeIdentifierOctet[11]};
        }
        return var2_4;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] createTimeUUIDBytes() {
        var5 = UUID.class$tyrex$services$UUID == null ? (UUID.class$tyrex$services$UUID = UUID.class$("tyrex.services.UUID")) : UUID.class$tyrex$services$UUID;
        synchronized (var5) {
            var0_1 = Clock.clock();
            block5: while (true) {
                if (var0_1 > UUID._lastClock) {
                    var3_2 = UUID._lastClock + (long)(UUID._uuidsThisTick / 100);
                    if (var0_1 <= var3_2) {
                        var0_1 = Clock.synchronize();
                    }
                    if (var0_1 > var3_2) {
                        UUID._uuidsThisTick = 0;
                        UUID._lastClock = var0_1;
                        UUID._uuidsPerTick = Clock.getUnsynchTicks() * 100;
                        break;
                    }
                }
                if (UUID._uuidsThisTick + 1 < UUID._uuidsPerTick) {
                    ++UUID._uuidsThisTick;
                    break;
                }
                var0_1 = Clock.synchronize();
                if (var0_1 > UUID._lastClock) continue;
                if (Configuration.verbose) {
                    Logger.tyrex.debug((Object)Messages.message("tyrex.uuid.fastHolding"));
                }
                while (true) {
                    if (var0_1 <= UUID._lastClock) ** break;
                    continue block5;
                    try {
                        Thread.currentThread();
                        Thread.sleep(Clock.getUnsynchTicks());
                    }
                    catch (InterruptedException var6_3) {
                        // empty catch block
                    }
                    var0_1 = Clock.synchronize();
                }
                break;
            }
            var0_1 = (UUID._lastClock + 12219292800000L) * 100L + (long)UUID._uuidsThisTick;
            var2_4 = new byte[]{(byte)(var0_1 >> 24 & 255L), (byte)(var0_1 >> 16 & 255L), (byte)(var0_1 >> 8 & 255L), (byte)(var0_1 & 255L), (byte)(var0_1 >> 40 & 255L), (byte)(var0_1 >> 32 & 255L), (byte)(var0_1 >> 60 & 255L | 16L), (byte)(var0_1 >> 48 & 255L), UUID._clockSeqByte[0], UUID._clockSeqByte[1], UUID._nodeIdentifierByte[0], UUID._nodeIdentifierByte[1], UUID._nodeIdentifierByte[2], UUID._nodeIdentifierByte[3], UUID._nodeIdentifierByte[4], UUID._nodeIdentifierByte[5]};
        }
        return var2_4;
    }

    private static void loadState() {
        String string;
        String string2 = Configuration.getProperty("tyrex.uuid.stateFile");
        if (string2 == null) {
            string2 = UUID_STATE_FILE;
        }
        Properties properties = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            if (Configuration.verbose) {
                Logger.tyrex.info((Object)Messages.format("tyrex.uuid.stateFileMissing", string2));
            }
            properties = null;
        }
        long l = -1L;
        int n = -1;
        if (properties != null && (string = properties.getProperty(PROPERTY_NODE_IDENTIFIER)) != null) {
            try {
                string = string.trim();
                l = 0L;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    l = (l << 8) + Long.parseLong(string3, 16);
                }
                String string4 = properties.getProperty(PROPERTY_CLOCK_SEQUENCE);
                if (string4 != null) {
                    try {
                        string4 = string4.trim();
                        n = Integer.parseInt(string4, 10);
                        ++n;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logger.tyrex.info((Object)Messages.message("tyrex.uuid.clockSequenceInvalid"));
                        l = -1L;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logger.tyrex.info((Object)Messages.message("tyrex.uuid.nodeIdentifierInvalid"));
            }
        }
        if (n == -1) {
            n = Configuration.getRandom().nextInt(4096);
        }
        _clockSeqOctet = new char[4];
        UUID._clockSeqOctet[0] = HEX_DIGITS[(n &= 0x1FFF) >> 12 & 0xF];
        UUID._clockSeqOctet[1] = HEX_DIGITS[n >> 8 & 0xF];
        UUID._clockSeqOctet[2] = HEX_DIGITS[n >> 4 & 0xF];
        UUID._clockSeqOctet[3] = HEX_DIGITS[n & 0xF];
        _clockSeqByte = new byte[2];
        UUID._clockSeqByte[0] = (byte)(n >> 8 & 0xFF);
        UUID._clockSeqByte[1] = (byte)(n & 0xFF);
        if (l != -1L && properties != null) {
            ((Hashtable)properties).put(PROPERTY_CLOCK_SEQUENCE, String.valueOf(n));
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                properties.save(fileOutputStream, Messages.message("tyrex.uuid.stateFileHeader"));
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Logger.tyrex.error((Object)Messages.format("tyrex.uuid.stateFileFailure", string2), (Throwable)iOException);
                l = -1L;
            }
        }
        if (l == -1L) {
            l = Configuration.getRandom().nextLong();
            l |= 0x8000L;
            n = Configuration.getRandom().nextInt(4096);
            _clockSeqOctet = new char[4];
            UUID._clockSeqOctet[1] = HEX_DIGITS[(n &= 0x1FFF) >> 8 & 0xF];
            UUID._clockSeqOctet[2] = HEX_DIGITS[n >> 4 & 0xF];
            UUID._clockSeqOctet[3] = HEX_DIGITS[n & 0xF];
            _clockSeqByte = new byte[2];
            UUID._clockSeqByte[0] = (byte)(n >> 8 & 0xFF);
            UUID._clockSeqByte[1] = (byte)(n & 0xFF);
        }
        _nodeIdentifierOctet = new char[12];
        int n2 = 0;
        while (n2 < 12) {
            UUID._nodeIdentifierOctet[n2] = HEX_DIGITS[(int)(l >> (11 - n2) * 4 & 0xFL)];
            ++n2;
        }
        _nodeIdentifierByte = new byte[6];
        int n3 = 0;
        while (n3 < 6) {
            UUID._nodeIdentifierByte[n3] = (byte)(l >> (5 - n3) * 8 & 0xFFL);
            ++n3;
        }
        string = new String();
        int n4 = 0;
        while (n4 < 12) {
            if (n4 > 0) {
                string = string + ":";
            }
            string = string + HEX_DIGITS[(int)(l >> (11 - n4) * 4 & 0xFL)] + HEX_DIGITS[(int)(l >> (10 - n4) * 4 & 0xFL)];
            n4 += 2;
        }
        _uuidsPerTick = Clock.getUnsynchTicks() * 100;
        if (Configuration.verbose) {
            Logger.tyrex.info((Object)Messages.format("tyrex.uuid.initializing", String.valueOf(string), String.valueOf(n), String.valueOf(_uuidsPerTick)));
        }
        UUID._clockSeqOctet[0] = HEX_DIGITS[n >> 12 & 0xF | 8];
        UUID._clockSeqByte[0] = (byte)(n >> 8 & 0xFF | 0x80);
    }

    public static void main(String[] stringArray) {
        int n = 1000000;
        int n2 = 0;
        while (n2 < 10) {
            System.out.println(UUID.create());
            ++n2;
        }
        long l = System.currentTimeMillis();
        HashSet<String> hashSet = new HashSet<String>(n / 100, 100.0f);
        int n3 = 0;
        while (n3 < n) {
            String string;
            if (n3 % 10000 == 0) {
                System.out.println("Checked " + n3);
            }
            if (hashSet.contains(string = UUID.create())) {
                System.out.println("Duplicate id " + string);
            } else {
                hashSet.add(string);
            }
            ++n3;
        }
        l = System.currentTimeMillis() - l;
        System.out.println("Generated " + n + " UUIDs in " + l + "ms");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        UUID.loadState();
        _uuidsThisTick = _uuidsPerTick;
        _lastClock = Clock.clock();
    }

    public static class InvalidIDException
    extends Exception {
        public InvalidIDException(String string) {
            super(string);
        }
    }
}

